/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.component.ItemComponent;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.BookShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DualTableBaseBlock;
import moonfather.workshop_for_handsome_adventurer.blocks.DualToolRack;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.integration.WailaBaseProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class WthitPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)new WorkstationProvider(), TooltipPosition.HEAD, DualTableBaseBlock.class);
        registrar.addIcon((IBlockComponentProvider)new WorkstationProvider(), DualTableBaseBlock.class);
        registrar.addComponent((IBlockComponentProvider)new PotionShelfProvider(), TooltipPosition.TAIL, PotionShelfBlockEntity.class);
        registrar.addBlockData((IServerDataProvider)new PotionShelfDataProvider(), PotionShelf.class);
        registrar.addComponent((IBlockComponentProvider)new BookShelfProvider(), TooltipPosition.TAIL, BookShelfBlockEntity.class);
        registrar.addComponent((IBlockComponentProvider)new ToolRackProvider1(), TooltipPosition.TAIL, ToolRackBlockEntity.class);
        registrar.addComponent((IBlockComponentProvider)new ToolRackProvider2(), TooltipPosition.TAIL, DualToolRack.class);
    }

    private static class WorkstationProvider
    implements IBlockComponentProvider {
        private static final Map<Block, ItemComponent> map = new HashMap<Block, ItemComponent>();
        private static final ResourceLocation topLine = new ResourceLocation("waila", "object_name");

        private WorkstationProvider() {
        }

        @Nullable
        public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
            return this.getPlacerItem(accessor);
        }

        public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            tooltip.setLine(topLine, this.getPlacerItem((IBlockAccessor)accessor).stack.m_41786_());
        }

        private ItemComponent getPlacerItem(IBlockAccessor accessor) {
            Block block = accessor.getBlock();
            if (map.containsKey(block)) {
                return map.get(block);
            }
            ItemStack placer = block.getCloneItemStack(accessor.getBlockState(), accessor.getHitResult(), (BlockGetter)accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
            ItemComponent result = new ItemComponent(placer);
            map.put(block, result);
            return result;
        }
    }

    private static class PotionShelfProvider
    implements IBlockComponentProvider {
        private static final String message = "message.workshop_for_handsome_adventurer.shelf_probe_tooltip";

        private PotionShelfProvider() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof PotionShelfBlockEntity) {
                PotionShelfBlockEntity shelf = (PotionShelfBlockEntity)blockEntity;
                int slot = PotionShelf.getPotionShelfSlot(accessor.getHitResult(), accessor.getPosition(), accessor.getSide());
                if (!shelf.GetItem(slot).m_41619_()) {
                    int room;
                    int count;
                    if (accessor.getServerData().m_128441_("Bottles" + slot)) {
                        count = accessor.getServerData().m_128451_("Bottles" + slot);
                        room = accessor.getServerData().m_128451_("Space" + slot);
                    } else {
                        count = shelf.GetRemainingItems(slot);
                        room = shelf.GetRemainingRoom(slot);
                    }
                    tooltip.addLine((Component)Component.m_237110_((String)message, (Object[])new Object[]{count, count + room}));
                    ItemStack bottle = shelf.GetItem(slot);
                    tooltip.addLine().with((ITooltipComponent)new ItemComponent(bottle)).with(bottle.m_41786_());
                } else {
                    tooltip.addLine((Component)Component.m_237110_((String)message, (Object[])new Object[]{0, shelf.GetRemainingRoom(slot)}));
                }
            }
        }
    }

    private static class PotionShelfDataProvider
    implements IServerDataProvider<PotionShelfBlockEntity> {
        private PotionShelfDataProvider() {
        }

        public void appendServerData(CompoundTag compoundTag, IServerAccessor<PotionShelfBlockEntity> serverAccessor, IPluginConfig config) {
            int max = ((PotionShelfBlockEntity)((Object)serverAccessor.getTarget())).getNumberOfItemsInOneRow() * 2;
            for (int i = 0; i < max; ++i) {
                int bottles = ((PotionShelfBlockEntity)((Object)serverAccessor.getTarget())).GetRemainingItems(i);
                compoundTag.m_128405_("Bottles" + i, bottles);
                int space = ((PotionShelfBlockEntity)((Object)serverAccessor.getTarget())).GetRemainingRoom(i);
                compoundTag.m_128405_("Space" + i, space);
            }
        }
    }

    private static class BookShelfProvider
    extends WailaBaseProvider
    implements IBlockComponentProvider {
        private BookShelfProvider() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof BookShelfBlockEntity) {
                BookShelfBlockEntity shelf = (BookShelfBlockEntity)blockEntity;
                int slot = BookShelf.getBookShelfSlot((BookShelf)accessor.getBlock(), new BlockHitResult(accessor.getHitResult().m_82450_(), accessor.getSide(), accessor.getPosition(), false));
                if (slot >= 0 && !shelf.GetItem(slot).m_41619_()) {
                    List<Component> enchantments;
                    tooltip.addLine().with((ITooltipComponent)new ItemComponent(shelf.GetItem(slot))).with(shelf.GetItem(slot).m_41786_());
                    if (((Boolean)OptionsHolder.CLIENT.DetailedWailaInfoForEnchantedBooks.get()).booleanValue() && (enchantments = this.getEnchantmentParts(shelf.GetItem(slot))) != null) {
                        for (int i = 0; i < enchantments.size(); i += 2) {
                            tooltip.addLine().with(enchantments.get(i)).with(enchantments.get(i + 1));
                        }
                    }
                }
            }
        }
    }

    private static class ToolRackProvider1
    extends WailaBaseProvider
    implements IBlockComponentProvider {
        private ToolRackProvider1() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            List<Component> enchantments;
            ItemStack tool = ItemStack.f_41583_;
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof ToolRackBlockEntity) {
                ToolRackBlockEntity rack = (ToolRackBlockEntity)blockEntity;
                if (accessor.getBlockEntity() instanceof PotionShelfBlockEntity || accessor.getBlockEntity() instanceof BookShelfBlockEntity) {
                    return;
                }
                int slot = ToolRack.getToolRackSlot((ToolRack)accessor.getBlock(), new BlockHitResult(accessor.getHitResult().m_82450_(), accessor.getSide(), accessor.getPosition(), false));
                tool = rack.GetItem(slot);
            }
            if (tool.m_41619_()) {
                return;
            }
            tooltip.addLine().with((ITooltipComponent)new ItemComponent(tool)).with(tool.m_41786_());
            if (((Boolean)OptionsHolder.CLIENT.DetailedWailaInfoForEnchantedTools.get()).booleanValue() && (enchantments = this.getEnchantmentParts(tool)) != null) {
                for (int i = 0; i < enchantments.size(); i += 2) {
                    tooltip.addLine().with(enchantments.get(i)).with(enchantments.get(i + 1));
                }
            }
        }
    }

    private static class ToolRackProvider2
    extends WailaBaseProvider
    implements IBlockComponentProvider {
        private ToolRackProvider2() {
        }

        public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            List<Component> enchantments;
            ItemStack tool = ItemStack.f_41583_;
            Block block = accessor.getBlock();
            if (block instanceof DualToolRack) {
                DualToolRack block2 = (DualToolRack)block;
                if (accessor.getBlockEntity() == null) {
                    ToolRackBlockEntity rack = (ToolRackBlockEntity)accessor.getWorld().m_7702_(accessor.getPosition().m_7494_());
                    int slot = ToolRack.getToolRackSlot(block2, new BlockHitResult(accessor.getHitResult().m_82450_(), accessor.getSide(), accessor.getPosition().m_7494_(), false));
                    tool = rack.GetItem(slot);
                }
            }
            if (tool.m_41619_()) {
                return;
            }
            tooltip.addLine().with((ITooltipComponent)new ItemComponent(tool)).with(tool.m_41786_());
            if (((Boolean)OptionsHolder.CLIENT.DetailedWailaInfoForEnchantedTools.get()).booleanValue() && (enchantments = this.getEnchantmentParts(tool)) != null) {
                for (int i = 0; i < enchantments.size(); i += 2) {
                    tooltip.addLine().with(enchantments.get(i)).with(enchantments.get(i + 1));
                }
            }
        }
    }
}

