/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.AssetReader;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.BaseResourcePack;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.CustomTripletSupport;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.DynamicAssetConfig;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeManager;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;

public class OurClientPack
extends BaseResourcePack {
    private final String JOIN = "%s:%s";
    private final Map<String, String> strippedLogCache = new HashMap<String, String>();
    private final Map<String, String> plankCache = new HashMap<String, String>();
    private static final String TEMPLATE_PLANKS = "%s:block/%s_planks";
    private static final String TEMPLATE_LOG = "%s:block/stripped_%s_log";
    private static final String TEMPLATE_ANY_BLOCK = "%s:block/%s";
    private static final String[] files = new String[]{"blockstates/book_shelf_double_spruce.json", "blockstates/book_shelf_minimal_spruce.json", "blockstates/book_shelf_open_double_spruce.json", "blockstates/book_shelf_open_minimal_spruce.json", "blockstates/book_shelf_with_lanterns_spruce.json", "blockstates/dual_table_bottom_left_spruce.json", "blockstates/dual_table_bottom_right_spruce.json", "blockstates/dual_table_top_left_spruce.json", "blockstates/dual_table_top_right_spruce.json", "blockstates/potion_shelf_spruce.json", "blockstates/simple_table_spruce.json", "blockstates/tool_rack_double_spruce.json", "blockstates/tool_rack_framed_spruce.json", "blockstates/tool_rack_pframed_spruce.json", "blockstates/tool_rack_single_spruce.json", "models/block/book_shelf_double_spruce.json", "models/block/book_shelf_minimal_spruce.json", "models/block/book_shelf_open_double_spruce.json", "models/block/book_shelf_open_minimal_spruce.json", "models/block/book_shelf_with_lit_lanterns_spruce.json", "models/block/book_shelf_with_unlit_lanterns_spruce.json", "models/block/dual_rack_bottom_spruce.json", "models/block/dual_rack_top_spruce.json", "models/block/dual_table_part_bottom_left_spruce.json", "models/block/dual_table_part_bottom_right_spruce.json", "models/block/dual_table_part_top_left_spruce.json", "models/block/dual_table_part_top_left2_spruce.json", "models/block/dual_table_part_top_left3_spruce.json", "models/block/dual_table_part_top_right_spruce.json", "models/block/dual_table_part_top_right2_spruce.json", "models/block/dual_table_part_top_right3_spruce.json", "models/block/framed_rack_full_bottom_spruce.json", "models/block/framed_rack_full_top_spruce.json", "models/block/framed_rack_hollow_bottom_spruce.json", "models/block/framed_rack_hollow_top_spruce.json", "models/block/mini_rack_spruce.json", "models/block/potion_shelf_spruce.json", "models/block/simple_table_spruce.json", "models/block/simple_table_with_drawer_spruce.json", "models/item/book_shelf_double_spruce.json", "models/item/book_shelf_minimal_spruce.json", "models/item/book_shelf_open_double_spruce.json", "models/item/book_shelf_open_minimal_spruce.json", "models/item/book_shelf_with_lanterns_spruce.json", "models/item/potion_shelf_spruce.json", "models/item/simple_table_spruce.json", "models/item/tool_rack_double_spruce.json", "models/item/tool_rack_framed_spruce.json", "models/item/tool_rack_pframed_spruce.json", "models/item/tool_rack_single_spruce.json", "models/item/workstation_placer_spruce.json", "blockstates/tetra_table_spruce.json", "models/block/tetra_table_spruce.json", "models/item/tetra_table_spruce.json"};

    public OurClientPack() {
        super(PackType.CLIENT_RESOURCES, 13);
    }

    @Override
    protected void buildResources(Map<ResourceLocation, String> cache) {
        String SPRUCE_PLANKS = "minecraft:block/spruce_planks";
        String SPRUCE_LOG = "minecraft:block/stripped_spruce_log";
        String SPRUCE = "spruce";
        for (String spruceFile : files) {
            String json = AssetReader.getInstance(PackType.CLIENT_RESOURCES, "workshop_for_handsome_adventurer").getText(new ResourceLocation("workshop_for_handsome_adventurer", spruceFile));
            if (json == null) continue;
            for (String string : WoodTypeLister.getWoodIds()) {
                String replaced = json.replace("minecraft:block/spruce_planks", this.getPlanks(string)).replace("minecraft:block/stripped_spruce_log", this.getStrippedLog(string)).replace("spruce", string);
                if (WoodTypeManager.isUsingDarkerWorkstation(string)) {
                    replaced = replaced.replace("/stripped_dark_oak_log", "/stripped_spruce_log");
                }
                String namespace = spruceFile.contains("tetra") ? "tetra_tables" : "workshop_for_handsome_adventurer";
                cache.put(new ResourceLocation(namespace, spruceFile.replace("spruce", string)), replaced);
            }
        }
        InputStream originalLang = AssetReader.getInstance(PackType.CLIENT_RESOURCES, "workshop_for_handsome_adventurer").getStream(new ResourceLocation("workshop_for_handsome_adventurer", "lang/en_us.json"));
        if (originalLang != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(originalLang));
            StringBuilder builder = new StringBuilder();
            builder.append("{\n");
            boolean first = true;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.contains("spruce")) continue;
                    if (line.endsWith(",")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    for (String wood : WoodTypeLister.getWoodIds()) {
                        Object replacement;
                        if (!first) {
                            builder.append(",\n");
                        } else {
                            first = false;
                        }
                        if (!wood.contains("_")) {
                            replacement = line.replace("spruce", wood);
                        } else {
                            String[] temp = line.split(":", 2);
                            replacement = temp[0].replace("spruce", wood) + ":" + temp[1].replace("spruce", CustomTripletSupport.stripPrefix(wood).replace('_', ' '));
                        }
                        builder.append((String)replacement);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            builder.append("\n}\n");
            cache.put(new ResourceLocation("workshop_for_handsome_adventurer", "lang/en_us.json"), builder.toString());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("  \"aliases\": [\n");
        builder.append("    {\n");
        builder.append("      \"stacks\": [\n");
        String line = "\"item:workshop_for_handsome_adventurer:simple_table_";
        boolean first = true;
        for (String string : WoodTypeLister.getWoodIds()) {
            if (!first) {
                builder.append(",\n");
            } else {
                first = false;
            }
            builder.append(line + string + "\"");
        }
        builder.append("      ],\n");
        builder.append("      \"text\": [\n");
        builder.append("        \"alias.emi.workbench\"\n");
        builder.append("      ]\n");
        builder.append("    }\n  ]\n}\n");
        cache.put(new ResourceLocation("emi", "aliases/list2.json"), builder.toString());
    }

    @Override
    protected boolean isNotOurRecipe(String namespace) {
        return !namespace.equals("workshop_for_handsome_adventurer") && !namespace.equals("tetra_tables");
    }

    private String getPlanks(String wood) {
        if (this.plankCache.containsKey(wood)) {
            return this.plankCache.get(wood);
        }
        String auto = WoodTypeManager.getFinder().getTexturePathForPlanks(WoodTypeLister.getHostMod(wood), wood);
        String result = null;
        if (auto != null) {
            result = "%s:%s".formatted(WoodTypeLister.getHostMod(wood), auto);
        }
        if (result == null) {
            DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
            String template = WoodTypeManager.getTexture1Template(wood);
            result = template != null ? template.formatted(WoodTypeLister.getHostMod(wood), CustomTripletSupport.stripPrefix(wood)) : (specialSet != null ? TEMPLATE_PLANKS.replace("_planks", "").formatted(specialSet.modId(), specialSet.planks()) : TEMPLATE_PLANKS.formatted(WoodTypeLister.getHostMod(wood), wood));
        }
        this.plankCache.put(wood, result);
        return result;
    }

    private String getStrippedLog(String wood) {
        String auto;
        if (this.strippedLogCache.containsKey(wood)) {
            return this.strippedLogCache.get(wood);
        }
        DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
        String sub = WoodTypeManager.getLogRecipeSubstitute(wood);
        if (sub != null) {
            int start = sub.indexOf(":");
            String mod = start == -1 ? WoodTypeLister.getHostMod(wood) : sub.substring(0, start);
            auto = WoodTypeManager.getFinder().getTexturePathForLogs(mod, wood, sub.substring(start + 1));
        } else {
            auto = specialSet != null ? WoodTypeManager.getFinder().getTexturePathForLogs(specialSet.modId(), wood, specialSet.log()) : WoodTypeManager.getFinder().getTexturePathForLogs(WoodTypeLister.getHostMod(wood), wood);
        }
        String result = null;
        if (auto != null) {
            result = "%s:%s".formatted(WoodTypeLister.getHostMod(wood), auto);
        }
        if (result == null) {
            if (sub == null) {
                String template = WoodTypeManager.getTexture2Template(wood);
                result = template != null ? template.formatted(WoodTypeLister.getHostMod(wood), CustomTripletSupport.stripPrefix(wood)) : TEMPLATE_LOG.formatted(WoodTypeLister.getHostMod(wood), CustomTripletSupport.stripPrefix(wood));
            } else {
                String template;
                ResourceLocation rl = new ResourceLocation(sub);
                String namespace = rl.m_135827_();
                String path = rl.m_135815_();
                String sub2 = WoodTypeManager.getLogTextureSubstitute(wood);
                if (sub2 != null) {
                    if (sub2.contains(":")) {
                        ResourceLocation rl2 = new ResourceLocation(sub2);
                        namespace = rl2.m_135827_();
                        path = rl2.m_135815_();
                    } else {
                        namespace = WoodTypeLister.getHostMod(wood);
                        path = sub2;
                    }
                }
                if ((template = WoodTypeManager.getTexture2TemplateForMod(rl.m_135827_())) == null) {
                    template = TEMPLATE_ANY_BLOCK;
                }
                result = template.formatted(namespace, path);
            }
        }
        this.strippedLogCache.put(wood, result);
        return result;
    }

    @Override
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer == LanguageMetadataSection.f_263724_) {
            return (T)new LanguageMetadataSection(Map.of("en_us", new LanguageInfo("US", "English", false)));
        }
        return super.m_5550_(deserializer);
    }

    @Override
    public String m_5542_() {
        return "Workshop - auto-generated client assets";
    }
}

