/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public abstract class BaseResourcePack
implements PackResources {
    private final Map<ResourceLocation, String> dataCache = new ConcurrentHashMap<ResourceLocation, String>();
    private final PackType type;
    private final PackMetadataSection packMetadata;
    private Set<String> namespaces = null;
    private final Set<String> fixedNamespaces = Set.of("workshop_for_handsome_adventurer", "tetra_tables");

    protected BaseResourcePack(PackType type, int packFormat) {
        this.type = type;
        this.packMetadata = new PackMetadataSection((Component)Component.m_237113_((String)this.m_5542_()), packFormat);
    }

    protected abstract void buildResources(Map<ResourceLocation, String> var1);

    protected abstract boolean isNotOurRecipe(String var1);

    private void buildOnDemand() {
        if (this.namespaces == null) {
            LogUtils.getLogger().info("(w) Starting dynamic {} : {}.", (Object)this.type.toString(), (Object)this.hashCode());
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.buildResources(this.dataCache);
            this.namespaces = this.dataCache.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
            stopwatch.stop();
            LogUtils.getLogger().info("(w) Generated dynamic {} : {} in {} ms.", new Object[]{this.type.toString(), this.hashCode(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... fileName) {
        this.buildOnDemand();
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (this.isNotOurRecipe(location.m_135827_())) {
            return null;
        }
        if (!(this.namespaces != null || location.m_135827_().equals("workshop_for_handsome_adventurer") && (location.m_135815_().contains("spruce") || location.m_135815_().contains("en_us")))) {
            this.buildOnDemand();
        }
        if (type == this.type && this.dataCache.containsKey(location)) {
            return this.supplierForPath(location);
        }
        return null;
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        if (this.isNotOurRecipe(namespace)) {
            return;
        }
        if (type == this.type) {
            this.buildOnDemand();
            this.dataCache.keySet().stream().filter(loc -> loc.m_135827_().equals(namespace)).filter(loc -> loc.m_135815_().startsWith(path)).forEach(loc -> output.accept(loc, this.supplierForPath((ResourceLocation)loc)));
        }
    }

    private IoSupplier<InputStream> supplierForPath(ResourceLocation loc) {
        return () -> new ByteArrayInputStream(this.dataCache.get(loc).getBytes(StandardCharsets.UTF_8));
    }

    public Set<String> m_5698_(PackType type) {
        if (type != this.type) {
            return Set.of();
        }
        if (this.namespaces == null) {
            return this.fixedNamespaces;
        }
        return this.namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer == PackMetadataSection.f_243696_) {
            return (T)this.packMetadata;
        }
        return null;
    }

    public String m_5542_() {
        return "test_dag:" + this.getClass().getSimpleName();
    }

    public boolean m_246538_() {
        return false;
    }

    public void close() {
    }

    public boolean isHidden() {
        return false;
    }
}

