/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import java.util.List;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.TetraHammerSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SimpleTable
extends Block
implements EntityBlock {
    private Component MessageInaccessible = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.workshop_table_obscured");
    private MutableComponent Tooltip1;
    private MutableComponent Tooltip2;
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG1 = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG2 = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)3.0);
    private static final VoxelShape SHAPE_LEG3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0);
    private static final VoxelShape SHAPE_LEG4 = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_TABLE = Shapes.m_83124_((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG1, SHAPE_LEG2, SHAPE_LEG3, SHAPE_LEG4});
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.crafting");
    public static final BooleanProperty HAS_INVENTORY = BooleanProperty.m_61465_((String)"has_inventory");

    public SimpleTable(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public SimpleTable() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_().m_284180_(MapColor.f_283748_).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HAS_INVENTORY, (Comparable)Boolean.valueOf(false)));
        this.Tooltip1 = Component.m_237115_((String)"block.workshop_for_handsome_adventurer.simple_table.tooltip1").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9966CC));
        this.Tooltip2 = Component.m_237115_((String)"block.workshop_for_handsome_adventurer.simple_table.tooltip2").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9966CC));
    }

    public VoxelShape m_7952_(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return SHAPE_TABLE;
    }

    public VoxelShape m_7947_(BlockState p_60581_, BlockGetter p_60582_, BlockPos p_60583_) {
        return SHAPE_TABLE;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE_TABLE;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter worldReader, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, worldReader, list, tooltipFlag);
        list.add((Component)this.Tooltip1);
        list.add((Component)this.Tooltip2);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (this.isObscured(level, pos)) {
            if (level.f_46443_) {
                player.m_5661_(this.MessageInaccessible, true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (ModList.get().isLoaded("tetra_tables") && !player.m_6047_() && TetraHammerSupport.isHammer(player.m_21205_())) {
            String id = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString();
            String wood = id.substring(id.indexOf("simple_table") + 13);
            String newName = "tetra_table_" + wood;
            for (ResourceLocation key : ForgeRegistries.BLOCKS.getKeys()) {
                if (!key.toString().endsWith(newName)) continue;
                level.m_46597_(pos, ((Block)ForgeRegistries.BLOCKS.getValue(key)).m_49966_());
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (ModList.get().isLoaded("tetra") && !player.m_6047_() && TetraHammerSupport.isHammer(player.m_21205_())) {
            level.m_46597_(pos, TetraHammerSupport.getWorkBench());
            return InteractionResult.CONSUME;
        }
        player.m_5893_(state.m_60750_(level, pos));
        player.m_36220_(Stats.f_12967_);
        return InteractionResult.CONSUME;
    }

    private boolean isObscured(Level level, BlockPos pos) {
        if (!level.m_6425_(pos.m_7494_()).m_76152_().equals(Fluids.f_76191_)) {
            return true;
        }
        VoxelShape s = level.m_8055_(pos.m_7494_()).m_60655_((BlockGetter)level, pos.m_7494_(), Direction.DOWN);
        if (s.m_83281_()) {
            return false;
        }
        double area = (s.m_83297_(Direction.Axis.X) - s.m_83288_(Direction.Axis.X)) * (s.m_83297_(Direction.Axis.Z) - s.m_83288_(Direction.Axis.Z));
        double lesserDim = Math.min(s.m_83297_(Direction.Axis.X) - s.m_83288_(Direction.Axis.X), s.m_83297_(Direction.Axis.Z) - s.m_83288_(Direction.Axis.Z));
        return area > 0.1875 || lesserDim > 0.1875;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (te instanceof SimpleTableBlockEntity) {
                SimpleTableBlockEntity entity = (SimpleTableBlockEntity)te;
                entity.DropAll();
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return ((BlockEntityType)Registration.SIMPLE_TABLE_BE.get()).m_155264_(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }

    public MenuProvider m_7246_(BlockState state, Level level, BlockPos blockPos) {
        return new SimpleMenuProvider((containerId, inventory, p_52231_) -> new SimpleTableMenu(containerId, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)blockPos), (MenuType)Registration.CRAFTING_SINGLE_MENU_TYPE.get()), CONTAINER_TITLE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HAS_INVENTORY});
    }
}

