/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import moonfather.workshop_for_handsome_adventurer.Constants;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class PotionShelf
extends ToolRack {
    private final MutableComponent ShelfMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_invalid_item");
    private final MutableComponent MaxedMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_slot_maxed");
    private final MutableComponent RemainingRoomMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
    private final MutableComponent RemainingItemsMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_remaining_items");
    private final MutableComponent WrongPotionMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_wrong_potion");
    private static final VoxelShape SHAPE_FRAME1N = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)3.0);
    private static final VoxelShape SHAPE_FRAME1E = Block.m_49796_((double)13.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_FRAME1S = Block.m_49796_((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_FRAME1W = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0);

    public PotionShelf() {
        super(6, "potion_shelf", null);
    }

    @Override
    protected boolean canDepositItem(ItemStack mainHandItem) {
        if (mainHandItem == null || mainHandItem.m_41619_()) {
            return true;
        }
        if (mainHandItem.m_41783_() != null && mainHandItem.m_41783_().m_128441_("Potion")) {
            return true;
        }
        if (mainHandItem.m_150930_(Items.f_42590_)) {
            return true;
        }
        return mainHandItem.m_204117_(Constants.Tags.ALLOWED_ON_POTION_SHELF);
    }

    public static int getPotionShelfSlot(BlockHitResult blockHitResult) {
        return PotionShelf.getPotionShelfSlot((HitResult)blockHitResult, blockHitResult.m_82425_(), blockHitResult.m_82434_());
    }

    public static int getPotionShelfSlot(HitResult hitResult, BlockPos blockPos, Direction direction) {
        int aboveThisRow = 0;
        double frac = hitResult.m_82450_().f_82480_ - (double)blockPos.m_123342_();
        if (frac < 0.5) {
            aboveThisRow = 3;
        }
        int integral = (int)hitResult.m_82450_().f_82481_;
        frac = (hitResult.m_82450_().f_82481_ - (double)integral) * (double)direction.m_122429_();
        integral = (int)hitResult.m_82450_().f_82479_;
        int horizontalIndex = (frac -= (hitResult.m_82450_().f_82479_ - (double)integral) * (double)direction.m_122431_()) >= -0.3333333333333333 && frac < 0.0 || frac >= 0.6666666666666666 && frac < 1.0 ? 0 : (frac >= 0.3333333333333333 && frac < 0.6666666666666666 || frac - 1.0 >= 0.3333333333333333 && frac - 1.0 < 0.6666666666666666 || frac + 1.0 >= 0.3333333333333333 && frac + 1.0 < 0.6666666666666666 ? 1 : 2);
        return aboveThisRow + horizontalIndex;
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        PotionShelfBlockEntity BE;
        ItemStack existing;
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (!this.canDepositItem(player.m_21205_())) {
            player.m_5661_((Component)this.ShelfMessage, true);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int slot = PotionShelf.getPotionShelfSlot(blockHitResult);
        if (slot >= this.itemCount) {
            slot -= this.itemCount;
        }
        if ((existing = (BE = (PotionShelfBlockEntity)level.m_7702_(pos)).GetItem(slot)).m_41619_() && !player.m_21205_().m_41619_()) {
            if (player.m_21205_().m_41741_() > 1 && player.m_6047_()) {
                BE.DepositPotionStack(slot, player.m_21205_());
            } else {
                BE.DepositPotion(slot, player.m_21205_());
            }
            player.m_5496_(SoundEvents.f_12635_, 0.5f, 0.7f);
            MutableComponent remainingRoomMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
            player.m_5661_((Component)remainingRoomMessage.m_130946_(BE.GetRemainingRoom(slot).toString()), true);
        } else if (!existing.m_41619_() || !player.m_21205_().m_41619_()) {
            if (!existing.m_41619_() && player.m_21205_().m_41619_()) {
                if (existing.m_41741_() > 1 && player.m_6047_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, BE.TakeOutPotionStack(slot));
                } else {
                    player.m_21008_(InteractionHand.MAIN_HAND, BE.TakeOutPotion(slot));
                }
                player.m_5496_(SoundEvents.f_12019_, 0.5f, 1.0f);
                if (BE.GetRemainingItems(slot) > 0) {
                    MutableComponent remainingItemsMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_remaining_items");
                    player.m_5661_((Component)remainingItemsMessage.m_130946_(BE.GetRemainingItems(slot).toString()), true);
                }
            } else if (ItemStack.m_150942_((ItemStack)existing, (ItemStack)player.m_21205_())) {
                if (BE.IsSlotMaxed(slot)) {
                    player.m_5661_((Component)this.MaxedMessage, true);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (player.m_21205_().m_41741_() > 1 && player.m_6047_()) {
                    BE.DepositPotionStack(slot, player.m_21205_());
                } else {
                    BE.DepositPotion(slot, player.m_21205_());
                }
                player.m_5496_(SoundEvents.f_12635_, 0.5f, 0.7f);
                MutableComponent remainingRoomMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
                player.m_5661_((Component)remainingRoomMessage.m_130946_(BE.GetRemainingRoom(slot).toString()), true);
            } else {
                player.m_5661_((Component)this.WrongPotionMessage, true);
            }
        }
        level.m_7260_(pos, blockState, blockState, 2);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        if (event.getEntity().m_6047_() && (state = event.getLevel().m_8055_(event.getPos())).m_60734_() instanceof PotionShelf && event.getFace() == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !event.getEntity().m_21205_().m_41619_()) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    @Override
    protected void PrepareListOfShapes() {
        this.shapes.clear();
        this.shapes.put(Direction.NORTH, SHAPE_FRAME1N);
        this.shapes.put(Direction.EAST, SHAPE_FRAME1E);
        this.shapes.put(Direction.SOUTH, SHAPE_FRAME1S);
        this.shapes.put(Direction.WEST, SHAPE_FRAME1W);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return ((BlockEntityType)Registration.POTION_SHELF_BE.get()).m_155264_(pos, blockState);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        PotionShelfBlockEntity BE = (PotionShelfBlockEntity)level.m_7702_(pos);
        if (BE == null || !state.m_61138_((Property)FACING)) {
            return Items.f_42398_.m_7968_();
        }
        BlockHitResult bhr = new BlockHitResult(target.m_82450_(), ((Direction)state.m_61143_((Property)FACING)).m_122424_(), pos, true);
        int slot = PotionShelf.getPotionShelfSlot(bhr);
        ItemStack existing = BE.GetItem(slot);
        if (!existing.m_41619_()) {
            return existing.m_41777_();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

