/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.screens;

import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketSender;
import moonfather.workshop_for_handsome_adventurer.block_entities.screens.SimpleTableCraftingScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class DualTableCraftingScreen
extends SimpleTableCraftingScreen {
    private static final ResourceLocation[] BACKGROUND_LOCATION = new ResourceLocation[5];
    private StateSwitchingButton jeiButton = null;
    private int lastDestinationGrid = 1;

    public DualTableCraftingScreen(SimpleTableMenu p_98448_, Inventory p_98449_, Component p_98450_) {
        super(p_98448_, p_98449_, p_98450_);
        this.f_97727_ = 233;
    }

    @Override
    protected String getCustomizationTooltipPath() {
        return "message.workshop_for_handsome_adventurer.extension_slot2";
    }

    @Override
    protected ResourceLocation getBackgroundImage() {
        if (BACKGROUND_LOCATION[0] == null) {
            for (int i = 0; i <= 4; ++i) {
                DualTableCraftingScreen.BACKGROUND_LOCATION[i] = new ResourceLocation("workshop_for_handsome_adventurer:textures/gui/gui_dual_table_%d_slots.png".formatted(i));
            }
        }
        return BACKGROUND_LOCATION[(Integer)OptionsHolder.COMMON.DualTableNumberOfSlots.get()];
    }

    protected void m_280003_(GuiGraphics graphics, int p_97809_, int p_97810_) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_ + 54 + 13, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 54 + 13, 0x404040, false);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ((DualTableMenu)this.f_97732_).registerClientHandlerForRecipeTargetChange(this::recipeTargetButtonChangeHandler);
        this.createJeiButton();
    }

    private void recipeTargetButtonChangeHandler(Integer value) {
        this.lastDestinationGrid = value;
        if (this.jeiButton != null) {
            this.jeiButton.m_94635_(value == 2);
        }
    }

    @Override
    public void setPositionsX() {
        super.setPositionsX();
        if (this.jeiButton != null) {
            this.jeiButton.m_264152_(80 + this.renderLeftPos, 62 + this.f_97736_);
        }
    }

    private void createJeiButton() {
        if (ModList.get().isLoaded("jei") || ModList.get().isLoaded("roughlyenoughitems") || ModList.get().isLoaded("emi")) {
            this.getBackgroundImage();
            this.jeiButton = new DestinationPickerButton(0, 0, 40, 28, false);
            int texturePosY = 0;
            if (ModList.get().isLoaded("roughlyenoughitems")) {
                texturePosY = 56;
            }
            if (ModList.get().isLoaded("emi")) {
                texturePosY = 112;
            }
            this.jeiButton.m_94624_(176, texturePosY, 40, 28, BACKGROUND_LOCATION[0]);
            this.jeiButton.m_264152_(80 + this.renderLeftPos, 62 + this.f_97736_);
            this.jeiButton.m_94635_(((DualTableMenu)this.f_97732_).getRecipeTargetGrid() == 2);
            this.m_142416_((GuiEventListener)this.jeiButton);
        }
    }

    private class DestinationPickerButton
    extends StateSwitchingButton {
        private static final int JEI_BUTTON_WIDTH = 40;
        private static final int JEI_BUTTON_HEIGTH = 28;
        private static final int JEI_BUTTON_POSX = 176;
        private static final int JEI_BUTTON_POSY = 0;
        private static final int JEI_BUTTON_MARGIN = 0;
        private static final int JEI_BUTTON_RENDERX = 80;
        private static final int JEI_BUTTON_RENDERY = 62;

        public DestinationPickerButton(int p_94615_, int p_94616_, int p_94617_, int p_94618_, boolean p_94619_) {
            super(p_94615_, p_94616_, p_94617_, p_94618_, p_94619_);
        }

        public boolean m_6375_(double x, double y, int p_93643_) {
            double localX = x - (double)this.m_252754_();
            double localY = y - (double)this.m_252907_();
            if (localX >= 10.0 && localX <= 20.0 && localY >= 4.0 && localY <= 14.0) {
                if (DualTableCraftingScreen.this.lastDestinationGrid != 2) {
                    PacketSender.sendDestinationGridChangeToServer(2);
                    DualTableCraftingScreen.this.lastDestinationGrid = 2;
                    this.m_94635_(true);
                }
                return true;
            }
            if (localX >= 10.0 && localX <= 20.0 && localY >= 14.0 && localY <= 24.0) {
                if (DualTableCraftingScreen.this.lastDestinationGrid != 1) {
                    PacketSender.sendDestinationGridChangeToServer(1);
                    DualTableCraftingScreen.this.lastDestinationGrid = 1;
                    this.m_94635_(false);
                }
                return true;
            }
            return super.m_6375_(x, y, p_93643_);
        }

        public boolean m_93696_() {
            return false;
        }
    }
}

