/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.BaseContainerBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.InventoryAccessHelper;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableDataSlots;
import moonfather.workshop_for_handsome_adventurer.block_entities.container_translators.IExcessSlotManager;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketSender;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.blocks.SimpleTable;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.PolymorphAccessorServer;
import moonfather.workshop_for_handsome_adventurer.integration.TetraBeltSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleTableMenu
extends AbstractContainerMenu {
    public static final int CUST_CONTAINER_SIZE = 4;
    public static final int TAB_SMUGGLING_CONTAINER_SIZE = 32;
    public static final int TAB_SMUGGLING_SOFT_LIMIT = 8;
    public static final int LEFT_PANEL_WIDTH = 176;
    public static final int RESULT_SLOT = 0;
    public static final int CRAFT_SLOT_START = 1;
    public static final int CRAFT_SLOT_END = 9;
    public static final int INV_SLOT_START = 10;
    public static final int INV_SLOT_END = 36;
    public static final int HOTBAR_ROW_SLOT_START = 37;
    public static final int HOTBAR_ROW_SLOT_END = 45;
    public static final int CUST_SLOT_START = 46;
    public static final int CUST_SLOT_END = 49;
    public static final int TABS_SLOT_START = 50;
    public static final int TABS_SLOT_END = 81;
    public static final int ACCESS_SLOT_START = 82;
    public static final int ACCESS_SLOT_END = 135;
    protected final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Player player;
    protected final ContainerLevelAccess access;
    private final SimpleContainer customizationSlots = new SimpleContainer(4);
    private final Container tabElements = new SimpleContainer(32);
    private Container chestSlots = null;
    protected boolean initialLoading = true;
    private boolean clientFlagScreenTooNarrow = false;
    private int lastInventoryAccessRange = 0;
    private int lastLanternCount = 0;
    private final InventoryAccessHelper inventoryAccessHelper = new InventoryAccessHelper();
    public int selectedTab = -1;
    protected SimpleTableDataSlots DataSlots = new SimpleTableDataSlots(this);

    public SimpleTableMenu(int containerId, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, inventory, ContainerLevelAccess.f_39287_, (MenuType)Registration.CRAFTING_SINGLE_MENU_TYPE.get());
    }

    public SimpleTableMenu(int containerId, Inventory inventory, ContainerLevelAccess levelAccess, @Nullable MenuType<?> menuType) {
        super(menuType, containerId);
        int hor;
        int ver;
        this.access = levelAccess;
        this.player = inventory.f_35978_;
        this.DataSlots.addSlots();
        this.m_38897_((Slot)new ResultSlot(inventory.f_35978_, this.craftSlots, (Container)this.resultSlots, 0, 120, 35));
        for (ver = 0; ver < 3; ++ver) {
            for (hor = 0; hor < 3; ++hor) {
                this.m_38897_(new Slot((Container)this.craftSlots, hor + ver * 3, 26 + hor * 18, 17 + ver * 18));
            }
        }
        for (ver = 0; ver < 3; ++ver) {
            for (hor = 0; hor < 9; ++hor) {
                this.m_38897_(new Slot((Container)inventory, hor + ver * 9 + 9, 8 + hor * 18, 84 + ver * 18));
            }
        }
        for (int hor2 = 0; hor2 < 9; ++hor2) {
            this.m_38897_(new Slot((Container)inventory, hor2, 8 + hor2 * 18, 142));
        }
        int custSlotCount = this.getCustomizationSlotCount();
        this.m_38897_(new CustomizationSlot((Container)this.customizationSlots, 0, 152, 17 + (0 < custSlotCount ? 0 : 9009)));
        this.m_38897_(new CustomizationSlot((Container)this.customizationSlots, 1, 152, 39 + (1 < custSlotCount ? 0 : 9009)));
        this.m_38897_(new CustomizationSlot((Container)this.customizationSlots, 2, 152, 61 + (2 < custSlotCount ? 0 : 9009)));
        this.m_38897_(new CustomizationSlot((Container)this.customizationSlots, 3, 152, 83 + (3 < custSlotCount ? 0 : 9009)));
        this.access.m_39292_(this::loadFromWorld);
        this.lastLanternCount = this.getLanternCount();
        if (!this.player.m_9236_().f_46443_) {
            this.customizationSlots.m_19164_((ContainerListener)new CustomizationListenerServer(this));
        } else {
            this.customizationSlots.m_19164_((ContainerListener)new CustomizationListenerClient(this));
        }
        for (int i = 0; i < this.tabElements.m_6643_(); ++i) {
            this.m_38897_(new Slot(this.tabElements, i, 9009, 9009 + i * 30));
        }
        this.storeAdjacentInventoriesInSlots();
        this.chestSlots = new DisabledContainer(54);
        this.setUpperContainerTrueSize(54);
        for (int ver2 = 0; ver2 < this.chestSlots.m_6643_() / 9; ++ver2) {
            for (int hor3 = 0; hor3 < 9; ++hor3) {
                this.m_38897_(new VariableSizeContainerSlot(this.chestSlots, ver2 * 9 + hor3, 5 + hor3 * 18 - 176, 30 + ver2 * 18, this::getUpperContainerTrueSize, this::isSlotSpecificallyDisabled));
            }
        }
        this.initialLoading = false;
    }

    public DataSlot m_38895_(DataSlot slot) {
        return super.m_38895_(slot);
    }

    public int getCustomizationSlotCount() {
        return (Integer)OptionsHolder.COMMON.SimpleTableNumberOfSlots.get();
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, BlockPos tablePos, Player player, CraftingContainer craftingContainer, ResultContainer resultContainer, int resultSlotIndex) {
        if (!level.f_46443_) {
            CraftingRecipe craftingrecipe;
            if (resultSlotIndex >= menu.f_38839_.size()) {
                return;
            }
            Optional optional = ModList.get().isLoaded("polymorph") ? PolymorphAccessorServer.getRecipe(menu, craftingContainer, level, player) : level.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)craftingContainer, level);
            ServerPlayer serverplayer = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            if (optional.isPresent() && resultContainer.m_40135_(level, serverplayer, (Recipe)(craftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = craftingrecipe.m_5874_((Container)craftingContainer, level.m_9598_());
            }
            resultContainer.m_6836_(0, itemstack);
            menu.m_150404_(resultSlotIndex, itemstack);
            serverplayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), resultSlotIndex, itemstack));
            SimpleTableMenu.updateInventoryOnClientSide(level, tablePos);
        }
    }

    public void m_6199_(Container container) {
        if (this.isCraftingGrid(container)) {
            this.access.m_39292_((level, pos) -> SimpleTableMenu.slotChangedCraftingGrid(this, level, pos, this.player, this.craftSlots, this.resultSlots, 0));
        }
    }

    public void handleCraftingUpdateRequest(int resultSlotIndex) {
        this.m_6199_((Container)this.craftSlots);
    }

    protected void setActiveResultSlotForPolymorph(int index) {
        if (this.player != null && !this.player.m_9236_().f_46443_) {
            this.DataSlots.setSlotValue(6, index);
        }
    }

    protected void clearAdditional() {
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        boolean hasDrawer = this.hasChestInCustomizationSlots();
        this.m_150411_(player, (Container)this.craftSlots);
        this.clearAdditional();
        this.access.m_39292_((level, pos) -> this.storeDataValues((Level)level, (BlockPos)pos));
        this.access.m_39292_((level, pos) -> this.storeCustomizationsToWorld((Container)this.customizationSlots, (Level)level, (BlockPos)pos));
        this.access.m_39292_((level, pos) -> this.updateDrawerInWorld((Level)level, (BlockPos)pos, hasDrawer));
        this.access.m_39292_((level, pos) -> SimpleTableMenu.updateInventoryOnClientSide(level, pos));
    }

    private static void updateInventoryOnClientSide(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        level.m_7260_(pos, state, state, 2);
    }

    protected void storeDataValues(Level level, BlockPos pos) {
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, pos) -> {
            if (!(level.m_8055_(pos).m_60734_() instanceof SimpleTable)) {
                return false;
            }
            return player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
        }, (Object)true);
    }

    protected boolean isSlotACraftingResultSlot(int index) {
        return index == 0;
    }

    protected boolean isSlotACraftingGridSlot(int index) {
        return index >= 1 && index <= 9;
    }

    protected boolean moveItemStackToCraftingGrid(ItemStack itemstack1) {
        return this.moveItemStackToOccupiedSlotsOnly(itemstack1, 1, 10, false);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (this.isSlotACraftingResultSlot(slotIndex)) {
                this.access.m_39292_((level, p_39379_) -> itemstack1.m_41720_().m_7836_(itemstack1, level, player));
                if (!this.m_38903_(itemstack1, 10, 46, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotIndex >= 10 && slotIndex <= 45 ? !this.moveItemStackToCraftingGrid(itemstack1) && (!this.showInventoryAccess() || !this.moveItemStackToOccupiedSlotsOnly(itemstack1, 82, 136, false)) && (slotIndex < 37 ? !this.m_38903_(itemstack1, 37, 46, false) : !this.m_38903_(itemstack1, 10, 37, false)) : (slotIndex >= 82 && slotIndex <= 135 ? !this.moveItemStackToCraftingGrid(itemstack1) && !this.moveItemStackToOccupiedSlotsOnly(itemstack1, 10, 37, false) && !this.m_38903_(itemstack1, 37, 46, true) && !this.m_38903_(itemstack1, 10, 37, false) : this.isSlotACraftingGridSlot(slotIndex) && (!this.showInventoryAccess() || !this.moveItemStackToOccupiedSlotsOnly(itemstack1, 82, 136, false)) && !this.m_38903_(itemstack1, 10, 46, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            if (slotIndex == 0) {
                player.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    protected boolean moveItemStackToOccupiedSlotsOnly(ItemStack itemStack, int startingSlot, int endingSlotPlus1, boolean reverse) {
        boolean result = false;
        int i = startingSlot;
        if (reverse) {
            i = endingSlotPlus1 - 1;
        }
        if (itemStack.m_41753_()) {
            while (!itemStack.m_41619_() && !(reverse ? i < startingSlot : i >= endingSlotPlus1)) {
                int maxSize;
                ItemStack itemstack;
                Slot slot = (Slot)this.f_38839_.get(i);
                i = reverse ? --i : ++i;
                if (!slot.m_6659_() || (itemstack = slot.m_7993_()).m_41619_() || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)itemstack)) continue;
                int j = itemstack.m_41613_() + itemStack.m_41613_();
                if (j <= (maxSize = Math.min(slot.m_6641_(), itemStack.m_41741_()))) {
                    itemStack.m_41764_(0);
                    itemstack.m_41764_(j);
                    slot.m_6654_();
                    result = true;
                    continue;
                }
                if (itemstack.m_41613_() >= maxSize) continue;
                itemStack.m_41774_(maxSize - itemstack.m_41613_());
                itemstack.m_41764_(maxSize);
                slot.m_6654_();
                result = true;
            }
        }
        return result;
    }

    public boolean m_5882_(ItemStack p_39381_, Slot slot) {
        return slot.f_40218_ != this.resultSlots && slot.f_40218_ != this.tabElements && slot.f_40218_ != this.customizationSlots && slot.m_6659_() && super.m_5882_(p_39381_, slot);
    }

    protected void m_150411_(Player player, Container container) {
        if (this.isCraftingGrid(container)) {
            this.access.m_39292_((level, pos) -> {
                if (!(level.m_7702_(pos) instanceof SimpleTableBlockEntity)) {
                    super.m_150411_(player, container);
                    return;
                }
                if (!this.hasChestInCustomizationSlots()) {
                    if (this.showInventoryAccess()) {
                        this.clearContainerWithInventoryAccess(player, container);
                    }
                    super.m_150411_(player, container);
                    this.clearInWorld(container, (Level)level, (BlockPos)pos);
                    return;
                }
                this.storeCraftingGridToWorld(container, (Level)level, (BlockPos)pos);
            });
        }
    }

    protected void clearContainerWithInventoryAccess(Player player, Container container) {
        if (!player.m_6084_() || player instanceof ServerPlayer && ((ServerPlayer)player).m_9232_()) {
            for (int j = 0; j < container.m_6643_(); ++j) {
                player.m_36176_(container.m_8016_(j), false);
            }
        } else {
            for (int i = 0; i < container.m_6643_(); ++i) {
                this.moveItemStackToOccupiedSlotsOnly(container.m_8020_(i), 82, 136, false);
            }
        }
    }

    private boolean isCraftingGrid(Container container) {
        return container instanceof CraftingContainer;
    }

    protected int getSlotOffsetInDataStorage(Container container) {
        return 0;
    }

    private void storeCraftingGridToWorld(Container container, Level level, BlockPos pos) {
        SimpleTableBlockEntity be = (SimpleTableBlockEntity)level.m_7702_(pos);
        if (be == null) {
            return;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            be.DepositItem(this.getSlotOffsetInDataStorage(container) + i, container.m_8016_(i));
        }
    }

    private void storeCustomizationsToWorld(Container container, Level level, BlockPos pos) {
        SimpleTableBlockEntity be = (SimpleTableBlockEntity)level.m_7702_(pos);
        if (be == null) {
            return;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            be.DepositCustomizationItem(i, container.m_8016_(i));
        }
    }

    protected void loadFromWorld(Level level, BlockPos pos) {
        int i;
        SimpleTableBlockEntity be = (SimpleTableBlockEntity)level.m_7702_(pos);
        if (be == null) {
            return;
        }
        for (i = 0; i < this.craftSlots.m_6643_(); ++i) {
            this.craftSlots.m_6836_(i, be.GetItem(i));
        }
        this.craftSlots.m_6596_();
        for (i = 0; i < this.customizationSlots.m_6643_(); ++i) {
            this.customizationSlots.m_6836_(i, be.GetCustomizationItem(i));
        }
    }

    private void clearInWorld(Container container, Level level, BlockPos pos) {
        BaseContainerBlockEntity be = (BaseContainerBlockEntity)level.m_7702_(pos);
        for (int i = 0; i < container.m_6643_(); ++i) {
            be.ClearItem(this.getSlotOffsetInDataStorage(container) + i);
        }
    }

    private void updateDrawerInWorld(Level level, BlockPos pos, boolean hasDrawer) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof SimpleTable)) {
            return;
        }
        if (!((Boolean)state.m_61143_((Property)SimpleTable.HAS_INVENTORY)).booleanValue() && hasDrawer) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SimpleTable.HAS_INVENTORY, (Comparable)Boolean.valueOf(true)), 130);
        } else if (((Boolean)state.m_61143_((Property)SimpleTable.HAS_INVENTORY)).booleanValue() && !hasDrawer) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SimpleTable.HAS_INVENTORY, (Comparable)Boolean.valueOf(false)), 130);
        }
    }

    private boolean hasChestInCustomizationSlots() {
        for (int i = 0; i < this.customizationSlots.m_6643_(); ++i) {
            if (!this.customizationSlots.m_8020_(i).m_204117_(CustomizationSlot.ChestTag)) continue;
            return true;
        }
        return false;
    }

    public boolean showInventoryAccess() {
        if (this.tabElements.m_8020_(0).m_41619_()) {
            return false;
        }
        for (int i = 0; i < this.customizationSlots.m_6643_(); ++i) {
            if (!this.customizationSlots.m_8020_(i).m_150930_(CustomizationSlot.getAccessItem())) continue;
            return true;
        }
        return false;
    }

    public int getInventoryAccessRange() {
        int result = 0;
        for (int i = 0; i < this.customizationSlots.m_6643_(); ++i) {
            if (!this.customizationSlots.m_8020_(i).m_150930_(CustomizationSlot.getAccessItem())) continue;
            ++result;
        }
        if (result > 2) {
            result = 2;
        }
        return result;
    }

    public int getLanternCount() {
        int result = 0;
        for (int i = 0; i < this.customizationSlots.m_6643_(); ++i) {
            ItemStack stack = this.customizationSlots.m_8020_(i);
            if (!stack.m_204117_(CustomizationSlot.LanternTag) || stack.m_41613_() <= result) continue;
            result = stack.m_41613_();
        }
        return result;
    }

    private void setLanternState(Level level, BlockPos pos, boolean value) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof AdvancedTableBottomPrimary) {
            AdvancedTableBottomPrimary block2 = (AdvancedTableBottomPrimary)block;
            block2.setLanternState(level, pos, value);
        }
    }

    private void storeAdjacentInventoriesInSlots() {
        int range = this.getInventoryAccessRange();
        this.access.m_39292_((level, pos) -> this.inventoryAccessHelper.loadAdjacentInventories((Level)level, (BlockPos)pos, this.player, range));
        this.lastInventoryAccessRange = range;
        this.inventoryAccessHelper.putInventoriesIntoAContainerForTransferToClient(this.tabElements, 16);
        this.tabElements.m_6596_();
    }

    public void changeTabTo(int index) {
        Optional haveContainer = this.access.m_6721_((level, pos) -> this.inventoryAccessHelper.tryInitializeInventoryAccess((Level)level, this.player, index));
        if (haveContainer.isPresent() && ((Boolean)haveContainer.get()).booleanValue()) {
            if (!this.chestSlots.equals(this.inventoryAccessHelper.chosenContainer)) {
                this.chestSlots = this.inventoryAccessHelper.chosenContainer;
                this.setUpperContainerTrueSize(this.inventoryAccessHelper.chosenContainerTrueSize);
                for (int i = 82; i <= 135; ++i) {
                    this.m_38853_((int)i).f_40218_ = this.chestSlots;
                }
                this.initExcessSlotMap();
            }
        } else {
            if (!(this.chestSlots instanceof DisabledContainer)) {
                this.chestSlots = new DisabledContainer(54);
                this.setUpperContainerTrueSize(54);
                for (int i = 82; i <= 135; ++i) {
                    this.m_38853_((int)i).f_40218_ = this.chestSlots;
                }
            }
            this.clearExcessSlotMap();
        }
        this.selectedTab = index;
        this.DataSlots.resetDataSlotFlagForClientFlag(0);
        this.m_150429_();
    }

    public void renameChest(String newName) {
        if (this.player.f_36078_ == 0 && !this.player.m_7500_()) {
            return;
        }
        if (newName.equals("")) {
            return;
        }
        if (this.inventoryAccessHelper.currentType.equals("block")) {
            net.minecraft.world.level.block.entity.BaseContainerBlockEntity bcbe;
            BlockEntity blockEntity = this.inventoryAccessHelper.chosenContainerForRename;
            if (!(!(blockEntity instanceof net.minecraft.world.level.block.entity.BaseContainerBlockEntity) || (bcbe = (net.minecraft.world.level.block.entity.BaseContainerBlockEntity)blockEntity).m_8077_() && bcbe.m_7770_().getString().equals(newName))) {
                bcbe.m_58638_((Component)Component.m_237113_((String)newName));
                this.player.m_6749_(-1);
            }
        } else if (this.inventoryAccessHelper.currentType.equals("belt")) {
            ItemStack s = (ItemStack)TetraBeltSupport.findToolbelt(this.player);
            s.m_41714_((Component)Component.m_237113_((String)newName));
            this.player.m_6749_(-1);
        } else if (this.inventoryAccessHelper.currentType.equals("leggings_item") || this.inventoryAccessHelper.currentType.equals("chest_item") || this.inventoryAccessHelper.currentType.equals("back_item") || this.inventoryAccessHelper.currentType.equals("floating")) {
            ItemStack s = InventoryAccessHelper.getItemFromNamedSlot(this.player, this.inventoryAccessHelper.currentType);
            s.m_41714_((Component)Component.m_237113_((String)newName));
            this.player.m_6749_(-1);
        }
    }

    private int getUpperContainerTrueSize() {
        return this.DataSlots.getSlotValue(2);
    }

    private void setUpperContainerTrueSize(int value) {
        if (value != this.getUpperContainerTrueSize()) {
            this.DataSlots.setSlotValue(2, value);
            this.m_150440_(2, value);
        }
    }

    private boolean isSlotSpecificallyDisabled(int slotIndex) {
        return slotIndex < 27 && (this.DataSlots.getSlotValue(3) & 1 << slotIndex) != 0 || slotIndex >= 27 && slotIndex < 54 && (this.DataSlots.getSlotValue(4) & 1 << slotIndex - 27) != 0;
    }

    private void initExcessSlotMap() {
        this.initExcessSlotMapInternal(3, 0);
        this.initExcessSlotMapInternal(4, 27);
    }

    private void clearExcessSlotMap() {
        this.DataSlots.setSlotValue(3, 0);
        this.m_150440_(3, 0);
        this.DataSlots.setSlotValue(4, 0);
        this.m_150440_(4, 0);
    }

    private void initExcessSlotMapInternal(int slot, int offset) {
        Container container = this.inventoryAccessHelper.chosenContainer;
        if (container instanceof IExcessSlotManager) {
            IExcessSlotManager esm = (IExcessSlotManager)container;
            int map = 0;
            int mask = 1;
            for (int k = 0; k < 27; ++k) {
                if (esm.isSlotSpecificallyDisabled(k + offset)) {
                    map |= mask;
                }
                mask <<= 1;
            }
            this.DataSlots.setSlotValue(slot, map);
            this.m_150440_(slot, map);
        }
    }

    public void registerClientHandlerForDataSlot(int slotIndex, Consumer<Integer> event) {
        this.DataSlots.registerClientHandlerForDataSlot(slotIndex, event);
    }

    public void updateAccessSlotsOnClient() {
        int range;
        if (!this.initialLoading) {
            DisabledContainer dc;
            Container container;
            if (this.clientFlagScreenTooNarrow && this.chestSlots.m_6893_() != 707 && (container = this.chestSlots) instanceof DisabledContainer) {
                dc = (DisabledContainer)container;
                dc.disabled = true;
            }
            if (this.showInventoryAccess() && this.chestSlots.m_6893_() == 707 && !this.clientFlagScreenTooNarrow && (container = this.chestSlots) instanceof DisabledContainer) {
                dc = (DisabledContainer)container;
                dc.disabled = false;
            }
            if (!this.showInventoryAccess() && this.chestSlots.m_6893_() != 707) {
                if (this.selectedTab != 0) {
                    this.changeTabTo(0);
                }
                if (this.chestSlots instanceof DisabledContainer && this.chestSlots.m_6893_() != 707) {
                    ((DisabledContainer)this.chestSlots).disabled = true;
                }
                this.m_150429_();
            }
        }
        if ((range = this.getInventoryAccessRange()) != this.lastInventoryAccessRange) {
            PacketSender.sendTabChangeToServer(0);
        }
        this.lastInventoryAccessRange = range;
    }

    public void setClientFlagScreenTooNarrow(boolean value) {
        this.clientFlagScreenTooNarrow = value;
    }

    public static class CustomizationSlot
    extends Slot {
        private static final TagKey<Item> ChestTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge:chests"));
        private static final TagKey<Item> LanternTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("workshop_for_handsome_adventurer", "lanterns"));
        private static final ResourceLocation EMPTY_SLOT_BG = new ResourceLocation("workshop_for_handsome_adventurer", "gui/c_slot");
        private static Item accessItem = null;
        private boolean acceptsLanterns = false;

        public CustomizationSlot(Container p_39521_, int p_39522_, int p_39523_, int p_39524_) {
            super(p_39521_, p_39522_, p_39523_, p_39524_);
            this.setBackground(InventoryMenu.f_39692_, EMPTY_SLOT_BG);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.m_204117_(ChestTag) || itemStack.m_150930_(CustomizationSlot.getAccessItem()) || this.acceptsLanterns && itemStack.m_204117_(LanternTag);
        }

        public int m_5866_(ItemStack itemStack) {
            return itemStack.m_204117_(LanternTag) ? 2 : 1;
        }

        private static Item getAccessItem() {
            if (accessItem == null && (accessItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)OptionsHolder.COMMON.AccessCustomizationItem.get()))).equals(Items.f_41852_)) {
                accessItem = Items.f_42656_;
            }
            return accessItem;
        }

        public void setAcceptsLanterns(boolean value) {
            this.acceptsLanterns = value;
        }
    }

    private class CustomizationListenerServer
    implements ContainerListener {
        private final SimpleTableMenu parent;

        public CustomizationListenerServer(SimpleTableMenu simpleTableMenu2) {
            this.parent = simpleTableMenu2;
        }

        public void m_5757_(Container container) {
            int lanternCount;
            int range = this.parent.getInventoryAccessRange();
            int lastRange = this.parent.lastInventoryAccessRange;
            if (range != this.parent.lastInventoryAccessRange) {
                this.parent.storeAdjacentInventoriesInSlots();
                this.parent.DataSlots.resetDataSlotFlagForClientFlag(0);
                this.parent.DataSlots.raiseDataSlotFlagForClientFlag(0);
                if (lastRange == 0) {
                    this.parent.m_150429_();
                }
                this.parent.lastInventoryAccessRange = range;
            }
            if ((lanternCount = this.parent.getLanternCount()) == 2 && this.parent.lastLanternCount != 2) {
                this.parent.access.m_39292_((l, p) -> this.parent.setLanternState((Level)l, (BlockPos)p, true));
                this.parent.lastLanternCount = lanternCount;
            } else if (lanternCount != 2 && this.parent.lastLanternCount == 2) {
                this.parent.access.m_39292_((l, p) -> this.parent.setLanternState((Level)l, (BlockPos)p, false));
                this.parent.lastLanternCount = lanternCount;
            }
        }
    }

    private class CustomizationListenerClient
    implements ContainerListener {
        private final SimpleTableMenu parent;

        public CustomizationListenerClient(SimpleTableMenu simpleTableMenu2) {
            this.parent = simpleTableMenu2;
        }

        public void m_5757_(Container container) {
            this.parent.updateAccessSlotsOnClient();
        }
    }

    private static class DisabledContainer
    extends SimpleContainer {
        private static final int MARKER_FOR_DISABLED = 707;
        private boolean disabled = true;

        public int m_6893_() {
            return this.disabled ? 707 : super.m_6893_();
        }

        public boolean m_7013_(int p_18952_, ItemStack p_18953_) {
            return !this.disabled && super.m_7013_(p_18952_, p_18953_);
        }

        public DisabledContainer(int size) {
            super(size);
        }
    }

    public static class VariableSizeContainerSlot
    extends Slot {
        private Supplier<Integer> containerTrueSizeGetter = null;
        private Function<Integer, Boolean> excessSettingGetter = null;

        public VariableSizeContainerSlot(Container p_40223_, int p_40224_, int p_40225_, int p_40226_, Supplier<Integer> containerTrueSize, Function<Integer, Boolean> excessSetting) {
            super(p_40223_, p_40224_, p_40225_, p_40226_);
            this.containerTrueSizeGetter = containerTrueSize;
            this.excessSettingGetter = excessSetting;
        }

        public boolean m_6659_() {
            return this.f_40218_.m_6893_() != 707 && !this.isExcessSlot();
        }

        public boolean m_5857_(ItemStack itemStack) {
            return this.m_6659_() && this.f_40218_.m_7013_(this.getSlotIndex(), itemStack);
        }

        public ItemStack m_7993_() {
            if (!this.isExcessSlot()) {
                return super.m_7993_();
            }
            return ItemStack.f_41583_;
        }

        public void m_5852_(ItemStack stack) {
            if (this.getSlotIndex() < this.getContainerTrueSize()) {
                super.m_5852_(stack);
            }
        }

        public int getContainerTrueSize() {
            return this.containerTrueSizeGetter.get();
        }

        public boolean isExcessSlot() {
            return this.getSlotIndex() >= this.getContainerTrueSize() || this.excessSettingGetter != null && this.excessSettingGetter.apply(this.getSlotIndex()) != false;
        }
    }

    public static class VariableSizeItemStackHandlerWrapper
    extends SimpleContainer {
        private final IItemHandler internal;

        public VariableSizeItemStackHandlerWrapper(IItemHandler wrapped) {
            super(54);
            this.internal = wrapped;
        }

        public boolean m_7013_(int slot, ItemStack itemStack) {
            return slot < this.internal.getSlots() && this.internal.isItemValid(slot, itemStack);
        }

        public ItemStack m_8020_(int slot) {
            return slot < this.internal.getSlots() ? this.internal.getStackInSlot(slot) : ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int slot, int count) {
            return slot < this.internal.getSlots() ? this.internal.extractItem(slot, count, false) : ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int slot) {
            return slot < this.internal.getSlots() ? this.internal.extractItem(slot, 9999, false) : ItemStack.f_41583_;
        }

        public void m_6836_(int slot, ItemStack itemStack) {
            if (slot < this.internal.getSlots()) {
                IItemHandler iItemHandler = this.internal;
                if (iItemHandler instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable i2 = (IItemHandlerModifiable)iItemHandler;
                    i2.setStackInSlot(slot, itemStack);
                } else {
                    this.internal.insertItem(slot, itemStack, false);
                }
            }
        }

        public boolean m_7983_() {
            for (int i = 0; i < this.internal.getSlots(); ++i) {
                if (this.internal.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }

        public void m_6596_() {
        }

        public int m_6893_() {
            return this.internal.getSlots() > 1 ? this.internal.getSlotLimit(1) : 64;
        }
    }

    public static class VariableSizeContainerWrapper
    extends SimpleContainer
    implements IExcessSlotManager {
        private IExcessSlotManager excessManager = null;
        private final Container internal;

        public VariableSizeContainerWrapper(Container wrapped) {
            super(54);
            Container container = this.internal = wrapped;
            if (container instanceof IExcessSlotManager) {
                IExcessSlotManager esm;
                this.excessManager = esm = (IExcessSlotManager)container;
            }
        }

        public boolean m_7013_(int slot, ItemStack itemStack) {
            return slot < this.internal.m_6643_() && this.internal.m_7013_(slot, itemStack);
        }

        public ItemStack m_8020_(int slot) {
            return slot < this.internal.m_6643_() ? this.internal.m_8020_(slot) : ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int slot, int count) {
            return slot < this.internal.m_6643_() ? this.internal.m_7407_(slot, count) : ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int slot) {
            return slot < this.internal.m_6643_() ? this.internal.m_8016_(slot) : ItemStack.f_41583_;
        }

        public void m_6836_(int slot, ItemStack itemStack) {
            if (slot < this.internal.m_6643_()) {
                this.internal.m_6836_(slot, itemStack);
            }
        }

        public boolean m_7983_() {
            return this.internal.m_7983_();
        }

        public void m_6596_() {
            this.internal.m_6596_();
        }

        public int m_6893_() {
            return this.internal.m_6893_();
        }

        @Override
        public boolean isSlotSpecificallyDisabled(int slotIndex) {
            return this.excessManager != null && this.excessManager.isSlotSpecificallyDisabled(slotIndex);
        }
    }

    public static class OptionallyDrawnSlot
    extends Slot {
        private final Supplier<Boolean> condition;

        public OptionallyDrawnSlot(Container p_40223_, int p_40224_, int p_40225_, int p_40226_, Supplier<Boolean> condition) {
            super(p_40223_, p_40224_, p_40225_, p_40226_);
            this.condition = condition;
        }

        public boolean shouldRender() {
            return this.condition != null && this.condition.get() != false;
        }

        public boolean m_6659_() {
            return this.shouldRender();
        }
    }
}

