/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.ArrayList;
import java.util.List;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PotionShelfBlockEntity
extends ToolRackBlockEntity {
    public static final int CAPACITY = 6;
    private final List<Integer> itemCounts = new ArrayList<Integer>(6);

    public PotionShelfBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.POTION_SHELF_BE.get(), pos, state, 6);
    }

    public PotionShelfBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state, 6);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        int[] array = compoundTag.m_128465_("Counts");
        for (int i = 0; i < array.length; ++i) {
            this.itemCounts.set(i, array[i]);
            if (array[i] != 0 || this.GetItem(i).m_41619_()) continue;
            this.ClearItem(i);
        }
    }

    @Override
    public CompoundTag saveInternal(CompoundTag compoundTag) {
        super.saveInternal(compoundTag);
        compoundTag.m_128408_("Counts", this.itemCounts);
        return compoundTag;
    }

    @Override
    public int getNumberOfItemsInOneRow() {
        return 3;
    }

    @Override
    public void DropAll() {
        this.VerifyCapacity();
        for (int slot = 0; slot < this.getCapacity(); ++slot) {
            for (int j = 0; j < this.itemCounts.get(slot); ++j) {
                ItemStack potion = this.GetItem(slot);
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)potion.m_41777_());
            }
            this.ClearItem(slot);
            this.itemCounts.set(slot, 0);
        }
    }

    public ItemStack TakeOutPotion(int slot) {
        this.VerifyCapacity();
        if (this.itemCounts.get(slot) == 1) {
            ItemStack result = this.GetItem(slot);
            this.ClearItem(slot);
            this.itemCounts.set(slot, 0);
            this.m_6596_();
            return result;
        }
        if (this.itemCounts.get(slot) > 1) {
            ItemStack result = this.GetItem(slot).m_41777_();
            result.m_41764_(1);
            this.itemCounts.set(slot, this.itemCounts.get(slot) - 1);
            this.m_6596_();
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void DepositPotion(int slot, ItemStack itemStack) {
        this.VerifyCapacity();
        if (this.itemCounts.get(slot) == 0) {
            ItemStack copy = itemStack.m_41777_();
            copy.m_41764_(1);
            itemStack.m_41774_(1);
            this.DepositItem(slot, copy);
            this.itemCounts.set(slot, 1);
        } else {
            itemStack.m_41774_(1);
            this.itemCounts.set(slot, this.itemCounts.get(slot) + 1);
        }
        this.m_6596_();
    }

    public void DepositPotionStack(int slot, ItemStack itemStack) {
        this.VerifyCapacity();
        int count = Math.min(itemStack.m_41613_(), this.GetRemainingRoom(slot));
        if (this.itemCounts.get(slot) == 0) {
            ItemStack copy = itemStack.m_41777_();
            copy.m_41764_(1);
            itemStack.m_41774_(count);
            this.DepositItem(slot, copy);
            this.itemCounts.set(slot, count);
        } else {
            itemStack.m_41774_(count);
            this.itemCounts.set(slot, this.itemCounts.get(slot) + count);
        }
        this.m_6596_();
    }

    public ItemStack TakeOutPotionStack(int slot) {
        this.VerifyCapacity();
        int count = Math.min(this.GetItem(slot).m_41741_(), this.itemCounts.get(slot));
        if (this.itemCounts.get(slot) == 0) {
            return ItemStack.f_41583_;
        }
        if (this.itemCounts.get(slot) == count) {
            ItemStack result = this.GetItem(slot);
            result.m_41764_(count);
            this.ClearItem(slot);
            this.itemCounts.set(slot, 0);
            this.m_6596_();
            return result;
        }
        ItemStack result = this.GetItem(slot).m_41777_();
        result.m_41764_(count);
        this.itemCounts.set(slot, this.itemCounts.get(slot) - count);
        this.m_6596_();
        return result;
    }

    public boolean IsSlotMaxed(int slot) {
        this.VerifyCapacity();
        if (this.GetItem(slot).m_41619_()) {
            return false;
        }
        return this.itemCounts.get(slot) >= Math.min((Integer)OptionsHolder.COMMON.SlotRoomMaximum.get(), this.GetItem(slot).m_41741_() * (Integer)OptionsHolder.COMMON.SlotRoomMultiplier.get());
    }

    public Integer GetRemainingRoom(int slot) {
        this.VerifyCapacity();
        if (this.itemCounts.get(slot) == 0) {
            return (Integer)OptionsHolder.COMMON.SlotRoomMaximum.get();
        }
        return Math.min((Integer)OptionsHolder.COMMON.SlotRoomMaximum.get(), this.GetItem(slot).m_41741_() * (Integer)OptionsHolder.COMMON.SlotRoomMultiplier.get()) - this.itemCounts.get(slot);
    }

    public Integer GetRemainingItems(int slot) {
        this.VerifyCapacity();
        return this.itemCounts.get(slot);
    }

    @Override
    protected void VerifyCapacity() {
        super.VerifyCapacity();
        for (int i = this.itemCounts.size(); i < this.getCapacity(); ++i) {
            this.itemCounts.add(0);
        }
    }
}

