/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.LinkedList;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.container_translators.TetraBeltTranslator;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.integration.CuriosAccessor;
import moonfather.workshop_for_handsome_adventurer.integration.TetraBeltSupport;
import moonfather.workshop_for_handsome_adventurer.integration.TravelersBackpack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;

public class InventoryAccessHelper {
    private LinkedList<InventoryAccessRecord> adjacentInventories = null;
    public String currentType;
    public Container chosenContainer;
    public int chosenContainerTrueSize = 0;
    public int chosenContainerVisibleSize = 0;
    private BlockPos chestPrimaryPos;
    public BlockEntity chosenContainerForRename = null;

    private void resolveBlockContainer(BlockEntity be, Player player, BlockPos pos, Level level) {
        Container container;
        ChestBlockEntity cbe;
        this.chosenContainer = null;
        this.chestPrimaryPos = null;
        this.chosenContainerTrueSize = 0;
        this.currentType = "";
        this.chosenContainerVisibleSize = 27;
        this.chosenContainerForRename = null;
        if (be == null) {
            return;
        }
        if (be instanceof ChestBlockEntity && (cbe = (ChestBlockEntity)be).m_6643_() <= 54) {
            CompoundContainer result;
            BlockEntity be2;
            BlockPos pos2;
            if (ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)pos)) {
                return;
            }
            this.chosenContainerTrueSize = cbe.m_6643_();
            this.chosenContainerVisibleSize = cbe.m_6643_() <= 27 ? 27 : 54;
            this.currentType = "block";
            DoubleBlockCombiner.BlockType type = ChestBlock.m_51582_((BlockState)be.m_58900_());
            if (type == DoubleBlockCombiner.BlockType.SINGLE) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)be);
                this.chosenContainerForRename = be;
            }
            if (type == DoubleBlockCombiner.BlockType.FIRST) {
                pos2 = pos.m_121945_(ChestBlock.m_51584_((BlockState)be.m_58900_()));
                be2 = level.m_7702_(pos2);
                if (be2 instanceof ChestBlockEntity && be2.m_58900_().m_61143_((Property)ChestBlock.f_51479_) != be.m_58900_().m_61143_((Property)ChestBlock.f_51479_)) {
                    if (ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)pos2)) {
                        return;
                    }
                    result = new CompoundContainer((Container)be, (Container)be2);
                    this.chosenContainer = result.m_6643_() == 54 ? result : new SimpleTableMenu.VariableSizeContainerWrapper((Container)result);
                    this.chosenContainerTrueSize = result.m_6643_();
                    this.chosenContainerVisibleSize = result.m_6643_() <= 27 ? 27 : 54;
                    this.chosenContainerForRename = be;
                } else {
                    return;
                }
            }
            if (type == DoubleBlockCombiner.BlockType.SECOND) {
                pos2 = pos.m_121945_(ChestBlock.m_51584_((BlockState)be.m_58900_()));
                be2 = level.m_7702_(pos2);
                if (be2 instanceof ChestBlockEntity && be2.m_58900_().m_61143_((Property)ChestBlock.f_51479_) != be.m_58900_().m_61143_((Property)ChestBlock.f_51479_)) {
                    if (ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)pos2)) {
                        return;
                    }
                    result = new CompoundContainer((Container)be2, (Container)be);
                    this.chosenContainer = result.m_6643_() == 54 ? result : new SimpleTableMenu.VariableSizeContainerWrapper((Container)result);
                    this.chosenContainerTrueSize = result.m_6643_();
                    this.chosenContainerVisibleSize = result.m_6643_() <= 27 ? 27 : 54;
                    this.chosenContainerForRename = be2;
                    this.chestPrimaryPos = pos2;
                } else {
                    return;
                }
            }
            return;
        }
        if (be instanceof Container && (container = (Container)be).m_6643_() <= 54) {
            if (be instanceof ShulkerBoxBlockEntity && !InventoryAccessHelper.canOpenShulkerBox(level, be.m_58900_(), pos)) {
                return;
            }
            this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper(container);
            this.chosenContainerTrueSize = container.m_6643_();
            this.chosenContainerVisibleSize = container.m_6643_() <= 27 ? 27 : 54;
            this.chosenContainerForRename = be;
            this.currentType = "block";
            return;
        }
        if (be instanceof EnderChestBlockEntity) {
            if (ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)pos)) {
                return;
            }
            this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)player.m_36327_());
            this.chosenContainerTrueSize = 27;
            this.chosenContainerVisibleSize = 27;
            this.currentType = "block";
            return;
        }
        if (be.m_58900_().m_60734_().m_7705_().contains("storagedrawers")) {
            return;
        }
        LazyOptional oih = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!oih.isPresent()) {
            oih = be.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP);
        }
        oih.ifPresent(ih -> {
            if (ih.getSlots() <= 54) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeItemStackHandlerWrapper((IItemHandler)ih);
                this.chosenContainerTrueSize = ih.getSlots();
                this.chosenContainerVisibleSize = ih.getSlots() <= 27 ? 27 : 54;
                this.chosenContainerForRename = be;
                this.currentType = "block";
                return;
            }
        });
    }

    private static boolean canOpenShulkerBox(Level level, BlockState blockState, BlockPos pos) {
        AABB aabb = Shulker.m_149793_((Direction)((Direction)blockState.m_61143_((Property)DirectionalBlock.f_52588_)), (float)0.0f, (float)0.5f).m_82338_(pos).m_82406_(1.0E-6);
        return level.m_45772_(aabb);
    }

    public void loadAdjacentInventories(Level level, BlockPos pos, Player player, int inventoryAccessRange) {
        if (this.adjacentInventories == null) {
            this.adjacentInventories = new LinkedList();
        }
        this.adjacentInventories.clear();
        this.loadAdjacentInventoriesCore(level, pos, player, inventoryAccessRange);
        BlockState statePrimary = level.m_8055_(pos);
        BlockPos posSecondary = null;
        if (statePrimary.m_60734_() instanceof AdvancedTableBottomPrimary) {
            posSecondary = pos.m_121945_(((Direction)statePrimary.m_61143_((Property)BlockStateProperties.f_61374_)).m_122428_());
            this.loadAdjacentInventoriesCore(level, posSecondary, player, inventoryAccessRange);
        }
        this.loadNonBlockInventories(level, player);
        this.sort(pos, posSecondary);
        while (this.adjacentInventories.size() > 8) {
            this.adjacentInventories.removeLast();
        }
    }

    private void loadNonBlockInventories(Level level, Player player) {
        TravelersBackpack backpack;
        InventoryAccessRecord record;
        int size;
        Object beltSearch = TetraBeltSupport.findToolbelt(player);
        if (TetraBeltSupport.hasToolbelt(beltSearch) && (size = TetraBeltSupport.getToolbeltStorage(beltSearch).m_6643_()) > 0) {
            record = new InventoryAccessRecord();
            record.ItemChest = TetraBeltSupport.getToolbeltIcon(beltSearch);
            record.Nameable = true;
            record.Name = record.ItemChest.m_41786_();
            record.Type = "belt";
            record.VisibleSlotCount = size / 8 * 9 <= 27 ? 27 : 54;
            record.ItemFirst = TetraBeltSupport.getToolbeltStorageFirst(beltSearch);
            record.Index = this.adjacentInventories.size();
            this.adjacentInventories.add(record);
        }
        for (int slot = 0; slot < RecordTypes.NAMED_SLOTS.length; ++slot) {
            String slotName = RecordTypes.NAMED_SLOTS[slot];
            ItemStack maybeStorageItem = InventoryAccessHelper.getItemFromNamedSlot(player, slotName);
            LazyOptional pockets = maybeStorageItem.getCapability(ForgeCapabilities.ITEM_HANDLER);
            pockets.ifPresent(inventory -> {
                InventoryAccessRecord record = new InventoryAccessRecord();
                record.ItemChest = maybeStorageItem.m_41777_();
                record.Nameable = true;
                record.Name = record.ItemChest.m_41786_();
                record.Type = slotName;
                record.VisibleSlotCount = inventory.getSlots() <= 27 ? 27 : 54;
                record.ItemFirst = ItemStack.f_41583_;
                record.Index = this.adjacentInventories.size();
                this.adjacentInventories.add(record);
            });
        }
        if (ModList.get().isLoaded("travelersbackpack") && (backpack = TravelersBackpack.getInstance(player)).isPresent() && backpack.slotCount() <= 54 && !backpack.getTabIcon().m_41619_()) {
            record = new InventoryAccessRecord();
            record.ItemChest = backpack.getTabIcon();
            record.Nameable = true;
            record.Name = record.ItemChest.m_41786_();
            record.Type = "floating";
            record.VisibleSlotCount = backpack.slotCount() <= 27 ? 27 : 54;
            record.ItemFirst = backpack.getFirst();
            record.Index = this.adjacentInventories.size();
            this.adjacentInventories.add(record);
        }
    }

    private void loadAdjacentInventoriesCore(Level level, BlockPos pos, Player player, int range) {
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int dy = 1; dy >= 0; --dy) {
            if (pos.m_123342_() + dy > level.m_151558_()) continue;
            for (int dx = -range; dx <= range; ++dx) {
                for (int dz = -range; dz <= range; ++dz) {
                    BaseContainerBlockEntity bcbe;
                    if (!this.isInRange(dx, dz, range)) continue;
                    pos2.m_122178_(pos.m_123341_() + dx, pos.m_123342_() + dy, pos.m_123343_() + dz);
                    BlockEntity be = level.m_7702_((BlockPos)pos2);
                    this.resolveBlockContainer(be, player, (BlockPos)pos2, level);
                    if (this.chosenContainer == null || be instanceof BaseContainerBlockEntity && !(bcbe = (BaseContainerBlockEntity)be).m_7525_(player)) continue;
                    InventoryAccessRecord record = new InventoryAccessRecord();
                    record.ItemChest = be.m_58900_().m_60734_().m_5456_().m_7968_();
                    if (record.ItemChest.m_41619_()) {
                        record.ItemChest = be.m_58900_().getCloneItemStack((HitResult)new BlockHitResult(pos2.m_252807_(), Direction.UP, (BlockPos)pos2, false), (BlockGetter)level, (BlockPos)pos2, player);
                        record.Name = record.ItemChest.m_41786_();
                        if (record.ItemChest.m_41619_()) {
                            record.ItemChest = Items.f_42768_.m_7968_();
                            record.Name = be.m_58900_().m_60734_().m_49954_();
                        }
                    }
                    if (record.Name == null) {
                        BlockEntity blockEntity = this.chosenContainerForRename;
                        if (blockEntity instanceof BaseContainerBlockEntity) {
                            BaseContainerBlockEntity bcbe2 = (BaseContainerBlockEntity)blockEntity;
                            record.Name = bcbe2.m_7755_();
                            record.Nameable = true;
                        } else {
                            record.Name = record.ItemChest.m_41786_();
                            record.Nameable = false;
                        }
                    }
                    record.x = pos2.m_123341_();
                    record.y = pos2.m_123342_();
                    record.z = pos2.m_123343_();
                    record.Type = "block";
                    record.VisibleSlotCount = this.chosenContainerVisibleSize;
                    if (this.chestPrimaryPos != null) {
                        record.x = this.chestPrimaryPos.m_123341_();
                        record.y = this.chestPrimaryPos.m_123342_();
                        record.z = this.chestPrimaryPos.m_123343_();
                    }
                    record.ItemFirst = this.chosenContainer.m_8020_(0);
                    record.Index = this.adjacentInventories.size();
                    this.adjacentInventories.add(record);
                }
            }
        }
    }

    private boolean isInRange(int dx, int dz, int range) {
        if (dx == 0 && dz == 0) {
            return false;
        }
        return Math.abs(dx) + Math.abs(dz) <= range;
    }

    public void putInventoriesIntoAContainerForTransferToClient(Container tabElements, int max) {
        int i;
        if (this.adjacentInventories == null || this.adjacentInventories.size() == 0) {
            return;
        }
        max = Math.min(this.adjacentInventories.size(), max);
        for (i = 0; i < max; ++i) {
            InventoryAccessRecord current = this.adjacentInventories.get(i);
            ItemStack chest = current.ItemChest.m_41777_();
            chest.m_41714_(current.Name);
            if (current.VisibleSlotCount > 27) {
                chest.m_41764_(2);
            }
            if (!current.Nameable) {
                chest.m_41764_(chest.m_41613_() | 4);
            }
            ItemStack suff = current.ItemFirst.m_41777_();
            tabElements.m_6836_(i * 2, chest);
            tabElements.m_6836_(i * 2 + 1, suff);
        }
        for (i = max * 2; i < tabElements.m_6643_(); ++i) {
            if (tabElements.m_8020_(i).m_41619_()) continue;
            tabElements.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public boolean tryInitializeInventoryAccess(Level level, Player player, int index) {
        this.chosenContainerTrueSize = 0;
        this.chosenContainer = null;
        if (this.adjacentInventories == null || this.adjacentInventories.size() <= index) {
            return false;
        }
        InventoryAccessRecord record = this.adjacentInventories.get(index);
        if (record.Type.equals("block")) {
            BlockPos pos = new BlockPos(record.x, record.y, record.z);
            BlockEntity be = level.m_7702_(pos);
            this.resolveBlockContainer(be, player, pos, level);
            return this.chosenContainer != null;
        }
        if (record.Type.equals("belt")) {
            Container belt = TetraBeltSupport.getToolbeltStorage(player);
            if (belt == null) {
                return false;
            }
            this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)new TetraBeltTranslator(belt));
            this.chosenContainerTrueSize = belt.m_6643_() / TetraBeltTranslator.GetRowWidth(belt) * 9;
            this.currentType = "belt";
            return true;
        }
        if (record.Type.equals("leggings_item") || record.Type.equals("chest_item") || record.Type.equals("back_item")) {
            ItemStack item = InventoryAccessHelper.getItemFromNamedSlot(player, record.Type);
            LazyOptional pockets = item.getCapability(ForgeCapabilities.ITEM_HANDLER);
            pockets.ifPresent(inventory -> {
                this.chosenContainer = new SimpleTableMenu.VariableSizeItemStackHandlerWrapper((IItemHandler)inventory);
                this.chosenContainerTrueSize = inventory.getSlots();
                this.currentType = record.Type;
            });
            return this.chosenContainerTrueSize > 0;
        }
        if (record.Type.equals("floating")) {
            TravelersBackpack backpack;
            if (ModList.get().isLoaded("travelersbackpack") && (backpack = TravelersBackpack.getInstance(player)).isPresent() && backpack.slotCount() <= 54 && !backpack.getTabIcon().m_41619_()) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeItemStackHandlerWrapper(backpack.getItems());
                this.chosenContainerTrueSize = backpack.slotCount();
                this.currentType = "floating";
                return true;
            }
            return false;
        }
        return false;
    }

    public static ItemStack getItemFromNamedSlot(Player player, String slot) {
        if (slot.equals("leggings_item")) {
            return player.m_150109_().m_36052_(1);
        }
        if (slot.equals("chest_item")) {
            return player.m_150109_().m_36052_(2);
        }
        if (slot.equals("back_item") && ModList.get().isLoaded("curios")) {
            return CuriosAccessor.getFirstItem(player, "back");
        }
        return ItemStack.f_41583_;
    }

    private void sort(BlockPos pos, BlockPos posSecondary) {
        InventoryAccessRecord right;
        InventoryAccessRecord left;
        int k;
        int i;
        for (i = 0; i < this.adjacentInventories.size() - 1; ++i) {
            for (k = i + 1; k < this.adjacentInventories.size(); ++k) {
                left = this.adjacentInventories.get(i);
                right = this.adjacentInventories.get(k);
                if (!left.Type.equals("block") || !right.Type.equals("block") || left.x != right.x || left.y != right.y || left.z != right.z) continue;
                this.adjacentInventories.remove(k);
                --k;
            }
        }
        for (i = 0; i < this.adjacentInventories.size() - 1; ++i) {
            for (k = i + 1; k < this.adjacentInventories.size(); ++k) {
                left = this.adjacentInventories.get(i);
                right = this.adjacentInventories.get(k);
                if (right.Type.equals("block") || left.Type.equals("block")) {
                    if (!right.Type.equals("block") || left.Type.equals("block")) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (left.y < right.y) {
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (posSecondary == null || left.y != right.y) continue;
                if (pos.m_123341_() == posSecondary.m_123341_() && pos.m_123343_() < posSecondary.m_123343_()) {
                    if (left.z <= right.z) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (pos.m_123341_() == posSecondary.m_123341_() && pos.m_123343_() > posSecondary.m_123343_()) {
                    if (left.z >= right.z) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (pos.m_123343_() == posSecondary.m_123343_() && pos.m_123341_() < posSecondary.m_123341_()) {
                    if (left.x <= right.x) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (pos.m_123343_() != posSecondary.m_123343_() || pos.m_123341_() <= posSecondary.m_123341_() || left.x >= right.x) continue;
                this.adjacentInventories.set(i, right);
                this.adjacentInventories.set(k, left);
            }
        }
    }

    static class RecordTypes {
        public static final String BLOCK = "block";
        public static final String TOOLBELT = "belt";
        public static final String LEGGINGS = "leggings_item";
        public static final String CHESTSLOT = "chest_item";
        public static final String BACKSLOT = "back_item";
        public static final String FLOATING = "floating";
        public static final String[] NAMED_SLOTS = new String[]{"leggings_item", "chest_item", "back_item"};

        RecordTypes() {
        }
    }

    static class InventoryAccessRecord {
        public Component Name = null;
        public ItemStack ItemChest = ItemStack.f_41583_;
        public ItemStack ItemFirst = ItemStack.f_41583_;
        public int Index;
        public int x;
        public int y;
        public int z;
        public boolean Nameable = false;
        public String Type = "";
        public int VisibleSlotCount = 3;

        InventoryAccessRecord() {
        }
    }
}

