/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer;

import com.mojang.logging.LogUtils;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.DynamicAssetConfig;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.FinderEvents;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.SecondCreativeTab;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.initialization.CommonSetup;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.TOPRegistration;
import moonfather.workshop_for_handsome_adventurer.other.CreativeTab;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="workshop_for_handsome_adventurer")
public class ModWorkshop {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ModWorkshop() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)OptionsHolder.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)OptionsHolder.CLIENT_SPEC);
        Registration.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CommonSetup::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CreativeTab::OnCreativeTabPopulation);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FinderEvents::addServerPack);
        MinecraftForge.EVENT_BUS.addListener(PotionShelf::onRightClickBlock);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOWEST, this::registerDynamicItems);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        for (String woodType : Registration.woodTypes) {
            ModWorkshop.blacklistForCarryOn(woodType);
        }
        if (DynamicAssetConfig.masterLeverOn()) {
            for (String woodType : WoodTypeLister.getWoodIds(true)) {
                ModWorkshop.blacklistForCarryOn(woodType);
            }
        }
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPRegistration::instance);
        }
    }

    private static void blacklistForCarryOn(String woodType) {
        InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "workshop_for_handsome_adventurer:tool_rack_double_" + woodType);
        InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "workshop_for_handsome_adventurer:tool_rack_framed_" + woodType);
        InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "workshop_for_handsome_adventurer:tool_rack_pframed_" + woodType);
        InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "workshop_for_handsome_adventurer:dual_table_bottom_left_" + woodType);
        InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "workshop_for_handsome_adventurer:dual_table_bottom_right_" + woodType);
        InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "workshop_for_handsome_adventurer:dual_table_top_left_" + woodType);
        InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> "workshop_for_handsome_adventurer:dual_table_top_right_" + woodType);
    }

    private void registerDynamicItems(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256913_) && DynamicAssetConfig.masterLeverOn()) {
            Registration.registerBlocksForThirdPartyWood(event);
        }
        if (event.getRegistryKey().equals((Object)Registries.f_279569_) && DynamicAssetConfig.masterLeverOn() && DynamicAssetConfig.separateCreativeTab()) {
            event.register(Registries.f_279569_, new ResourceLocation("workshop_for_handsome_adventurer", "tab2"), SecondCreativeTab::getTab);
        }
    }
}

