/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import steve_gall.minecolonies_tweaks.core.common.network.AbstractMessage;

public abstract class BuildingModuleMessage
extends AbstractMessage {
    private final ResourceKey<Level> dimensionId;
    private final int coloyId;
    private final BlockPos buildingId;
    private final int moduleId;

    public BuildingModuleMessage(IBuildingModule module) {
        IBuilding building = module.getBuilding();
        this.dimensionId = building.getColony().getDimension();
        this.coloyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.moduleId = module.getProducer().getRuntimeID();
    }

    public BuildingModuleMessage(IBuildingModuleView module) {
        IBuildingView building = module.getBuildingView();
        this.dimensionId = building.getColony().getDimension();
        this.coloyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.moduleId = module.getProducer().getRuntimeID();
    }

    public BuildingModuleMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.dimensionId = buffer.m_236801_(Registries.f_256858_);
        this.coloyId = buffer.readInt();
        this.buildingId = buffer.m_130135_();
        this.moduleId = buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_236858_(this.dimensionId);
        buffer.writeInt(this.coloyId);
        buffer.m_130064_(this.buildingId);
        buffer.writeInt(this.moduleId);
    }

    public IBuildingModule getModule() {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(this.coloyId, this.dimensionId);
        if (colony == null) {
            return null;
        }
        IBuilding building = colony.getBuildingManager().getBuilding(this.buildingId);
        if (building == null) {
            return null;
        }
        return building.getModule(this.moduleId);
    }

    public IBuildingModuleView getModuleView() {
        IBuildingView building = IColonyManager.getInstance().getBuildingView(this.dimensionId, this.buildingId);
        if (building == null) {
            return null;
        }
        return building.getModuleView(this.moduleId);
    }

    public ResourceKey<Level> getDimensionId() {
        return this.dimensionId;
    }

    public int getColoyId() {
        return this.coloyId;
    }

    public BlockPos getBuildingId() {
        return this.buildingId;
    }

    public int getModuleId() {
        return this.moduleId;
    }
}

