/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.core.common.network.FrameMessage;
import steve_gall.minecolonies_tweaks.core.common.network.MessageEntry;
import steve_gall.minecolonies_tweaks.core.common.network.message.AssignFilterableItemsMessage;
import steve_gall.minecolonies_tweaks.core.common.network.message.AssignIdListUpdateMessage;

public class NetworkChannel {
    private final SimpleChannel rawChannel;
    private final AtomicInteger rawMessageId;
    private final AtomicInteger transactionId;
    private final Cache<Integer, Map<Integer, byte[]>> messageCache;
    private final Map<Integer, MessageEntry<?>> idToEntryMap;
    private final Map<Class<?>, MessageEntry<?>> classToIdMap;
    private final AtomicInteger messageId;

    public NetworkChannel(String channelName) {
        String modVersion = ((ModContainer)ModList.get().getModContainerById("minecolonies_tweaks").get()).getModInfo().getVersion().toString();
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)MineColoniesTweaks.rl(channelName), () -> modVersion, modVersion::equals, modVersion::equals);
        this.rawMessageId = new AtomicInteger();
        this.rawChannel.registerMessage(this.rawMessageId.incrementAndGet(), FrameMessage.class, FrameMessage::encode, FrameMessage::new, (msg, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            context.setPacketHandled(true);
            msg.handle(context);
        });
        this.messageId = new AtomicInteger();
        this.messageCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).concurrencyLevel(8).build();
        this.idToEntryMap = new HashMap();
        this.classToIdMap = new HashMap();
        this.transactionId = new AtomicInteger();
        this.registerMessage(AssignFilterableItemsMessage.class, AssignFilterableItemsMessage::new);
        this.registerMessage(AssignIdListUpdateMessage.class, AssignIdListUpdateMessage::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSplit(AbstractMessage message, Consumer<FrameMessage> consumer) {
        int splitLength;
        byte[] messageBytes;
        MessageEntry<?> entry = this.getClassToIdMap().get(message.getClass());
        if (entry == null) {
            throw new IllegalArgumentException("Not registered message type: " + message.getClass());
        }
        ByteBuf buffer = Unpooled.buffer();
        try {
            message.encode(new FriendlyByteBuf(buffer));
            messageBytes = buffer.array();
        }
        finally {
            buffer.release();
        }
        int max_packet_size = 943718;
        int packetIndex = 0;
        int transactionId = this.transactionId.getAndIncrement();
        for (int currentIndex = 0; currentIndex < messageBytes.length; currentIndex += splitLength) {
            splitLength = Math.min(max_packet_size, messageBytes.length - currentIndex);
            byte[] splitBytes = Arrays.copyOfRange(messageBytes, currentIndex, currentIndex + splitLength);
            FrameMessage splitMessage = new FrameMessage(transactionId, packetIndex++, currentIndex + splitLength >= messageBytes.length, entry.getMessageId(), splitBytes);
            consumer.accept(splitMessage);
        }
    }

    public void sendToServer(AbstractMessage message) {
        this.handleSplit(message, arg_0 -> ((SimpleChannel)this.rawChannel).sendToServer(arg_0));
    }

    public void sendToPlayer(AbstractMessage message, ServerPlayer player) {
        this.handleSplit(message, split -> this.rawChannel.sendTo(split, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }

    public <MSG extends AbstractMessage> void registerMessage(Class<MSG> messageClass, Function<FriendlyByteBuf, MSG> decoder) {
        int id = this.messageId.incrementAndGet();
        MessageEntry<MSG> entry = new MessageEntry<MSG>(id, messageClass, decoder);
        this.getIdToEntryMap().put(id, entry);
        this.getClassToIdMap().put(messageClass, entry);
    }

    public Cache<Integer, Map<Integer, byte[]>> getMessageCache() {
        return this.messageCache;
    }

    public Map<Integer, MessageEntry<?>> getIdToEntryMap() {
        return this.idToEntryMap;
    }

    public Map<Class<?>, MessageEntry<?>> getClassToIdMap() {
        return this.classToIdMap;
    }
}

