/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network;

import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.core.common.network.MessageEntry;

public final class FrameMessage {
    public static final Comparator<Map.Entry<Integer, byte[]>> COMPARING_BY_KEY = Map.Entry.comparingByKey();
    public static final byte[] REDUCE_SEED = new byte[0];
    private int transactionId;
    private int splitIndex;
    private boolean isLast;
    private int messageId;
    private byte[] payload;

    public FrameMessage(int transactionId, int splitIndex, boolean isLast, int messageId, byte[] payload) {
        this.transactionId = transactionId;
        this.splitIndex = splitIndex;
        this.isLast = isLast;
        this.messageId = messageId;
        this.payload = payload;
    }

    public FrameMessage(FriendlyByteBuf buffer) {
        this.transactionId = buffer.m_130242_();
        this.splitIndex = buffer.m_130242_();
        this.isLast = buffer.readBoolean();
        this.messageId = buffer.m_130242_();
        this.payload = buffer.m_130052_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.transactionId);
        buffer.m_130130_(this.splitIndex);
        buffer.writeBoolean(this.isLast);
        buffer.m_130130_(this.messageId);
        buffer.m_130087_(this.payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(NetworkEvent.Context context) {
        try {
            AbstractMessage message;
            Map map;
            Cache<Integer, Map<Integer, byte[]>> cache;
            Cache<Integer, Map<Integer, byte[]>> cache2 = cache = MineColoniesTweaks.network().getMessageCache();
            synchronized (cache2) {
                map = (Map)cache.get((Object)this.transactionId, Maps::newConcurrentMap);
                map.put(this.splitIndex, this.payload);
            }
            if (!this.isLast) {
                return;
            }
            byte[] messageData = map.entrySet().stream().sorted(COMPARING_BY_KEY).map(Map.Entry::getValue).reduce(REDUCE_SEED, (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
            MessageEntry<?> messageEntry = MineColoniesTweaks.network().getIdToEntryMap().get(this.messageId);
            if (messageEntry == null) {
                MineColoniesTweaks.LOGGER.error("Not registered message id: " + this.messageId);
                return;
            }
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])messageData);
            try {
                message = (AbstractMessage)messageEntry.getDecoder().apply(new FriendlyByteBuf(buffer));
            }
            finally {
                buffer.release();
            }
            context.enqueueWork(() -> {
                try {
                    message.handle(context);
                }
                catch (Exception e) {
                    MineColoniesTweaks.LOGGER.error((Object)e);
                }
            });
        }
        catch (ExecutionException e) {
            MineColoniesTweaks.LOGGER.error((Object)e);
        }
    }
}

