/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.config;

import net.minecraftforge.common.ForgeConfigSpec;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.AbstractEntityAICraftingAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.AbstractEntityAIStructureAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.EntityAIStructureBuilderAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.EntityAIWorkFarmerAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.EntityAIWorkSifterAccessor;

public class JobConfig {
    public final ForgeConfigSpec.IntValue blockMiningDelay;
    public final ForgeConfigSpec.IntValue blockBuildingDelay;
    public final ForgeConfigSpec.DoubleValue builderBlockMiningDelayBuff;
    public final ForgeConfigSpec.IntValue craftingProgressMultiplier;
    public final ForgeConfigSpec.IntValue craftingHittingTime;
    public final ForgeConfigSpec.IntValue craftingDecideDelay;
    public final ForgeConfigSpec.IntValue sifterProgressMultiplier;
    public final ForgeConfigSpec.IntValue farmerWorkDelay;
    public final ForgeConfigSpec.DoubleValue farmerSkillDivider;
    public final ForgeConfigSpec.IntValue farmerActionsDoneUntilDumping;
    public final ForgeConfigSpec.BooleanValue farmerPlantAfterHoe;
    public final ForgeConfigSpec.BooleanValue farmerPlantAfterHarvest;

    public JobConfig(ForgeConfigSpec.Builder builder) {
        this.blockMiningDelay = builder.defineInRange("blockMiningDelay", 500, 0, Integer.MAX_VALUE);
        this.blockBuildingDelay = builder.defineInRange("blockBuildingDelay", AbstractEntityAIStructureAccessor.getBuildBlockDelay(), 0, Integer.MAX_VALUE);
        builder.push("builder");
        builder.comment("builder's blockMiningDelay = commonBlockingMiningDelay * buff");
        this.builderBlockMiningDelayBuff = builder.defineInRange("blockMiningDelayBuff", EntityAIStructureBuilderAccessor.getSpeedBuff0(), 0.0, 1.0);
        builder.pop();
        builder.push("crafing");
        builder.comment("craftingTicks = progressMultiplier / craftSkillLevel * hittingTime");
        this.craftingProgressMultiplier = builder.defineInRange("progressMultiplier", AbstractEntityAICraftingAccessor.getProgressMultiplier(), 0, Integer.MAX_VALUE);
        this.craftingHittingTime = builder.defineInRange("hittingTime", AbstractEntityAICraftingAccessor.getHittingTime(), 0, Integer.MAX_VALUE);
        builder.comment(new String[]{"The delay ticks for go to work again after Citizen returned at hut", "This was 0 when 1.19.2"});
        this.craftingDecideDelay = builder.defineInRange("decideDelay", 400, 0, 400);
        builder.pop();
        builder.push("sifter");
        builder.comment("siftingTicks = progressMultiplier - strengthLevel");
        this.sifterProgressMultiplier = builder.defineInRange("progressMultiplier", EntityAIWorkSifterAccessor.getMaxLevel(), 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("farmer");
        builder.comment("finalDelay = workDelay - (skillDivider * staminaLevel)");
        this.farmerWorkDelay = builder.defineInRange("workDelay", EntityAIWorkFarmerAccessor.getStandardDelay(), 0, Integer.MAX_VALUE);
        this.farmerSkillDivider = builder.defineInRange("skillDivider", 2.0, 1.0, 2.147483647E9);
        builder.comment("if harvested count reached to this, farmer will go to dump");
        this.farmerActionsDoneUntilDumping = builder.defineInRange("actionsDoneUntilDumping", 256, EntityAIWorkFarmerAccessor.getMaxBlocksMined(), Integer.MAX_VALUE);
        builder.comment("whether plant seed after hoeing dirt");
        this.farmerPlantAfterHoe = builder.define("plantAfterHoe", true);
        builder.comment("whether plant seed after harvest crop");
        this.farmerPlantAfterHarvest = builder.define("plantAfterHarvest", true);
        builder.pop();
    }
}

