/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.manager.RequestMappingHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableDeliverable;
import steve_gall.minecolonies_tweaks.apiimpl.common.crafting.CustomizableRecipeStorageFactory;
import steve_gall.minecolonies_tweaks.apiimpl.common.requestsystem.CustomizableDeliverableRequest;
import steve_gall.minecolonies_tweaks.apiimpl.common.requestsystem.CustomizableDeliverableRequestFactory;
import steve_gall.minecolonies_tweaks.core.client.MineColoniesTweaksClient;
import steve_gall.minecolonies_tweaks.core.common.config.MineColoniesTweaksConfigClient;
import steve_gall.minecolonies_tweaks.core.common.config.MineColoniesTweaksConfigCommon;
import steve_gall.minecolonies_tweaks.core.common.config.MineColoniesTweaksConfigServer;
import steve_gall.minecolonies_tweaks.core.common.network.NetworkChannel;

@Mod(value="minecolonies_tweaks")
public class MineColoniesTweaks {
    public static final String MOD_ID = "minecolonies_tweaks";
    public static final Logger LOGGER = LogManager.getLogger();
    private static NetworkChannel NETWORK;

    public MineColoniesTweaks() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MineColoniesTweaksConfigClient.SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MineColoniesTweaksConfigCommon.SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MineColoniesTweaksConfigServer.SPEC);
        IEventBus fml_bus = FMLJavaModLoadingContext.get().getModEventBus();
        fml_bus.addListener(this::onFMLCommonSetup);
        fml_bus.addListener(this::onFMLLoadComplete);
        IEventBus forge_bus = MinecraftForge.EVENT_BUS;
        NETWORK = new NetworkChannel("main");
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> MineColoniesTweaksClient::new);
    }

    private void onFMLCommonSetup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            StandardFactoryController.getInstance().registerNewFactory((IFactory)new CustomizableRecipeStorageFactory());
            StandardFactoryController.getInstance().registerNewFactory((IFactory)new CustomizableDeliverableRequestFactory());
        });
    }

    private void onFMLLoadComplete(FMLLoadCompleteEvent e) {
        RequestMappingHandler.registerRequestableTypeMapping(CustomizableDeliverable.class, CustomizableDeliverableRequest.class);
    }

    public static NetworkChannel network() {
        return NETWORK;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

