/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.RotationMirror;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.IJobView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.network.messages.server.colony.building.BuildRequestMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class BatchRepairBuildingsWindow
extends AbstractWindowSkeleton {
    public static final Component O = Component.m_237113_((String)"O");
    public static final Component X = Component.m_237113_((String)"X");
    public static final String LIST_BUILDINGS = "buildings";
    public static final String LIST_BUILDERS = "builders";
    public static final String LIST_REPAIR_RESOURCES = "repairResources";
    public static final String ICON_BUILDING = "buildingIcon";
    public static final String TEXT_BUILDING_NAME = "buildingName";
    public static final String TEXT_BUILDER_NAME = "builderName";
    public static final String TEXT_ASSIGNED_COUNT = "assignedCount";
    public static final String BUTTON_EXCEPT_OPENABLES_ONLY_CHANGED = "exceptOpenablesOnlyChanged";
    public static final String BUTTON_ASSIGN_AUTO = "assignAllAutomatically";
    public static final String BUTTON_ASSGIN_CLEAR = "clearAssignments";
    public static final String BUTTON_MARK_ALL = "markAllDontRepair";
    public static final String BUTTON_MARK_CLAR = "clearDontRepair";
    public static final String TEXT_SELECTION = "selectionText";
    private final IColonyView colony;
    private final BOWindow parent;
    private final TextField nameField;
    private final Button exceptButton;
    private final ScrollingList buildingList;
    private final ScrollingList builderList;
    private final ScrollingList repairResourceList;
    private final Text selectionText;
    private final List<BuildingInfo> buildings;
    private final List<BuildingInfo> filteredBuildings;
    private final List<BuilderInfo> builders;
    private final List<BuilderInfo> filteredBuilders;
    private final List<ItemStack> repairResources;
    private final Map<BuildingInfo, BuilderInfo> assignments;
    private boolean requested = false;
    private boolean updating = false;
    private int updateProgress = 0;
    private int updateCount = 0;
    private boolean exceptOpenablesOnlyChanged = false;
    private int selectedBuildingIndex = -1;
    private int selectedBuilderIndex = -1;
    private int lastBuildersBuildingIndex = -1;
    private int lastResourcesBuildingIndex = -1;
    private int nameFilterRequested = 0;

    public BatchRepairBuildingsWindow(IColonyView colony, @Nullable BOWindow parent) {
        super(MineColoniesTweaks.rl("gui/batch_repair_buildings_window.xml").toString(), null);
        this.colony = colony;
        this.parent = parent;
        this.nameField = (TextField)this.window.findPaneOfTypeByID("input", TextField.class);
        this.exceptButton = (Button)this.window.findPaneOfTypeByID(BUTTON_EXCEPT_OPENABLES_ONLY_CHANGED, Button.class);
        this.buildingList = (ScrollingList)this.window.findPaneOfTypeByID(LIST_BUILDINGS, ScrollingList.class);
        this.builderList = (ScrollingList)this.window.findPaneOfTypeByID(LIST_BUILDERS, ScrollingList.class);
        this.repairResourceList = (ScrollingList)this.window.findPaneOfTypeByID(LIST_REPAIR_RESOURCES, ScrollingList.class);
        this.selectionText = (Text)this.window.findPaneOfTypeByID(TEXT_SELECTION, Text.class);
        this.buildings = new ArrayList<BuildingInfo>();
        this.filteredBuildings = new ArrayList<BuildingInfo>();
        this.builders = new ArrayList<BuilderInfo>();
        this.filteredBuilders = new ArrayList<BuilderInfo>();
        this.repairResources = new ArrayList<ItemStack>();
        this.assignments = new HashMap<BuildingInfo, BuilderInfo>();
        this.nameField.setHandler(this::onFieldInput);
        this.buildingList.setDataProvider(this.filteredBuildings::size, this::updateBuildingRow);
        this.builderList.setDataProvider(this.filteredBuilders::size, this::updateBuilderRow);
        this.repairResourceList.setDataProvider(this.repairResources::size, this::updateRepairResourceRow);
    }

    public void close() {
        if (this.parent != null) {
            this.parent.open();
            return;
        }
        super.close();
    }

    protected void onFieldInput(TextField input) {
        if (input == this.nameField) {
            this.nameFilterRequested = 10;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.requested = true;
        this.nameField.setFocus();
        this.onExceptOpenablesOnlyChangedChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate() {
        super.onUpdate();
        if (this.updating) {
            List<BuildingInfo> list = this.buildings;
            synchronized (list) {
                if (this.updateProgress >= this.updateCount) {
                    this.updating = false;
                }
                this.nameFilterRequested = 0;
                this.updateBuildingList();
            }
            this.onBuildingCountsChanged();
        }
        if (this.requested && !this.updating) {
            this.requested = false;
            this.updating = true;
            this.updateProgress = 0;
            this.updateCount = 0;
            this.buildings.clear();
            this.builders.clear();
            for (ICitizenDataView citizen : this.colony.getCitizens().values()) {
                IJobView jobView = citizen.getJobView();
                if (jobView == null || jobView.getEntry() != ModJobs.builder.get()) continue;
                this.builders.add(new BuilderInfo(this.colony, citizen));
            }
            ClientLevel level = this.mc.f_91073_;
            for (IBuildingView building : this.colony.getBuildings()) {
                if (building.isRepairing()) continue;
                String buildingStyle = building.getStructurePack();
                Object buildingName = building.getStructurePath().replace(".blueprint", "");
                ++this.updateCount;
                if (((String)buildingName).isEmpty()) {
                    return;
                }
                buildingName = ((String)buildingName).substring(0, ((String)buildingName).length() - 1) + building.getBuildingLevel() + ".blueprint";
                ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)buildingStyle, (String)buildingName), blueprint -> {
                    HashMap<ItemStorage, AtomicInteger> repairResources = new HashMap<ItemStorage, AtomicInteger>();
                    if (blueprint != null) {
                        StructurePhasePlacementResult result;
                        Rotation buildingRotation = BlockPosUtil.getRotationFromRotations((int)building.getRotation());
                        Mirror buldingMirror = building.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE;
                        blueprint.setRotationMirrorRelative(RotationMirror.of((Rotation)buildingRotation, (Mirror)buldingMirror), (Level)level);
                        StructurePlacer placer = new StructurePlacer((IStructureHandler)new LoadOnlyStructureHandler((Level)level, building.getPosition(), blueprint, new PlacementSettings(), true));
                        BlockPos progressPos = AbstractBlueprintIterator.NULL_POS;
                        do {
                            result = placer.executeStructureStep((Level)level, null, progressPos, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment((info, pos, handler) -> false), true);
                            progressPos = result.getIteratorPos();
                            for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                                AtomicInteger existing = repairResources.computeIfAbsent(new ItemStorage(stack), s -> new AtomicInteger());
                                existing.addAndGet(stack.m_41613_());
                            }
                        } while (result != null && result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED);
                    }
                    BuildingInfo buildingInfo = new BuildingInfo(building, repairResources);
                    List<BuildingInfo> list = this.buildings;
                    synchronized (list) {
                        ++this.updateProgress;
                        if (repairResources.size() > 0) {
                            this.buildings.add(buildingInfo);
                        }
                    }
                }));
            }
        }
        if (this.nameFilterRequested > 0 && --this.nameFilterRequested == 0) {
            this.updateBuildingList();
        }
        this.updateBuilderList();
        this.updateRepairResources();
    }

    public boolean click(double mx, double my) {
        boolean b = super.click(mx, my);
        if (b) {
            return b;
        }
        int buildingIndex = this.getHoveredRow(this.buildingList);
        if (buildingIndex > -1) {
            this.selectedBuildingIndex = buildingIndex;
            this.updateBuilderList();
            this.selectCurrentAssignedBuilder();
            return true;
        }
        int builderIndex = this.getHoveredRow(this.builderList);
        if (builderIndex > -1) {
            BuildingInfo building = this.filteredBuildings.get(this.selectedBuildingIndex);
            if (this.selectedBuilderIndex == builderIndex) {
                this.selectedBuilderIndex = -1;
                this.unassign(building);
            } else {
                this.selectedBuilderIndex = builderIndex;
                this.assign(building, this.filteredBuilders.get(builderIndex));
            }
            this.onBuildingCountsChanged();
            return true;
        }
        return false;
    }

    protected void selectCurrentAssignedBuilder() {
        if (this.selectedBuildingIndex == -1) {
            this.selectedBuilderIndex = -1;
            return;
        }
        BuildingInfo building = this.filteredBuildings.get(this.selectedBuildingIndex);
        BuilderInfo builder = this.assignments.get(building);
        this.selectedBuilderIndex = this.filteredBuilders.indexOf(builder);
    }

    protected int getHoveredRow(ScrollingList list) {
        List children = list.getContainer().getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (!((Pane)children.get(i)).wasCursorInPane()) continue;
            return i;
        }
        return -1;
    }

    public boolean rightClick(double mx, double my) {
        boolean b = super.rightClick(mx, my);
        if (b) {
            return b;
        }
        int buildingIndex = this.getHoveredRow(this.buildingList);
        if (buildingIndex > -1) {
            BuildingInfo building = this.filteredBuildings.get(buildingIndex);
            if (building.dontRepair) {
                this.unmarkAsDontRepair(building);
            } else {
                this.markAsDontRepair(building);
            }
            this.selectedBuildingIndex = buildingIndex;
            this.onBuildingDontRepairChanged();
            return true;
        }
        return false;
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (Objects.equals(button.getID(), BUTTON_EXCEPT_OPENABLES_ONLY_CHANGED)) {
            this.exceptOpenablesOnlyChanged ^= true;
            this.onExceptOpenablesOnlyChangedChanged();
        } else if (Objects.equals(button.getID(), BUTTON_ASSIGN_AUTO)) {
            this.filteredBuildings.forEach(this::unassign);
            Map<Integer, List<BuildingInfo>> groupsMap = this.filteredBuildings.stream().filter(building -> !building.dontRepair).collect(Collectors.groupingBy(building -> building.building.getBuildingLevel()));
            for (int buildingLevel = 5; buildingLevel > -1; --buildingLevel) {
                List builders;
                List<BuildingInfo> buildings = groupsMap.get(buildingLevel);
                if (buildings == null || (builders = this.streamWorkableBuilders(buildingLevel).collect(Collectors.toList())).size() == 0) continue;
                for (BuildingInfo building2 : buildings) {
                    builders.sort((o1, o2) -> Integer.compare(o1.cachedAssignedCount, o2.cachedAssignedCount));
                    BuilderInfo builder = (BuilderInfo)builders.get(0);
                    this.assign(building2, builder);
                }
            }
            this.onBuildingCountsChanged();
            this.selectCurrentAssignedBuilder();
        } else if (Objects.equals(button.getID(), BUTTON_ASSGIN_CLEAR)) {
            this.filteredBuildings.forEach(this::unassign);
            this.onBuildingCountsChanged();
            this.selectCurrentAssignedBuilder();
        } else if (Objects.equals(button.getID(), BUTTON_MARK_ALL)) {
            this.filteredBuildings.forEach(this::markAsDontRepair);
            this.onBuildingDontRepairChanged();
        } else if (Objects.equals(button.getID(), BUTTON_MARK_CLAR)) {
            this.filteredBuildings.forEach(this::unmarkAsDontRepair);
            this.onBuildingDontRepairChanged();
        } else if (Objects.equals(button.getID(), "repair")) {
            for (Map.Entry<BuildingInfo, BuilderInfo> entry : this.assignments.entrySet()) {
                Network.getNetwork().sendToServer((IMessage)new BuildRequestMessage(entry.getKey().building, BuildRequestMessage.Mode.REPAIR, entry.getValue().building.getPosition()));
            }
            this.close();
        } else if (Objects.equals(button.getID(), "cancel")) {
            this.close();
        }
    }

    protected void onExceptOpenablesOnlyChangedChanged() {
        boolean excpet = this.exceptOpenablesOnlyChanged;
        this.exceptButton.setText(excpet ? O : X);
        this.exceptButton.setColors((excpet ? ChatFormatting.BLACK : ChatFormatting.RED).m_126665_().intValue());
        this.buildings.stream().filter(building -> !this.testBuildingForList((BuildingInfo)building)).forEach(this::unassign);
        this.updateBuildingList();
        this.onBuildingCountsChanged();
    }

    protected void onBuildingDontRepairChanged() {
        this.updateBuilderList();
        this.selectCurrentAssignedBuilder();
        this.onBuildingCountsChanged();
    }

    protected Stream<BuilderInfo> streamWorkableBuilders(int buildingLevel) {
        return this.builders.stream().filter(builder -> this.testWorkable(buildingLevel, (BuilderInfo)builder));
    }

    protected boolean testWorkable(int buildingLevel, BuilderInfo builder) {
        return builder.building.getBuildingLevel() >= buildingLevel;
    }

    protected void onBuildingCountsChanged() {
        if (this.updating) {
            this.selectionText.setText(Component.m_237115_((String)"minecolonies_tweaks.gui.updating"));
        } else {
            this.selectionText.setText(Component.m_237110_((String)"minecolonies_tweaks.gui.assigned_counts", (Object[])new Object[]{this.assignments.size(), this.buildings.stream().filter(this::testBuildingForCount).count()}));
        }
    }

    protected boolean testBuildingForCount(BuildingInfo info) {
        if (this.exceptOpenablesOnlyChanged && info.openableOnlyChanged) {
            return false;
        }
        return !info.dontRepair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuildingList() {
        this.selectedBuildingIndex = -1;
        this.selectedBuilderIndex = -1;
        this.filteredBuildings.clear();
        List<BuildingInfo> list = this.buildings;
        synchronized (list) {
            String field = this.nameField.getText().toLowerCase(Locale.ENGLISH);
            this.buildings.stream().filter(this::testBuildingForList).filter(i -> this.filterBuilding(field, (BuildingInfo)i)).forEach(this.filteredBuildings::add);
            this.filteredBuildings.sort(this::compareBuilding);
        }
        this.buildingList.refreshElementPanes();
        this.updateBuilderList();
        this.updateRepairResources();
    }

    protected int compareBuilding(BuildingInfo building1, BuildingInfo building2) {
        boolean assigned2;
        boolean dontRepair1 = building1.dontRepair;
        boolean dontRepair2 = building2.dontRepair;
        if (dontRepair1 != dontRepair2) {
            return Boolean.compare(dontRepair1, dontRepair2);
        }
        BuilderInfo builder1 = this.assignments.get(building1);
        BuilderInfo builder2 = this.assignments.get(building2);
        boolean assigned1 = builder1 != null;
        boolean bl = assigned2 = builder2 != null;
        if (assigned1 != assigned2) {
            return Boolean.compare(assigned2, assigned1);
        }
        if (assigned1) {
            return builder1.nameLowerCase.compareTo(builder2.nameLowerCase);
        }
        return Integer.compare(building1.itemId, building2.itemId);
    }

    protected void updateBuildingRow(int index, Pane row) {
        BuildingInfo building = this.filteredBuildings.get(index);
        BuilderInfo builder = this.assignments.get(building);
        ItemIcon buildingIcon = (ItemIcon)row.findPaneOfTypeByID(ICON_BUILDING, ItemIcon.class);
        buildingIcon.setItem(building.icon);
        Text buildingLabel = (Text)row.findPaneOfTypeByID(TEXT_BUILDING_NAME, Text.class);
        buildingLabel.setText(building.name);
        buildingLabel.setColors(this.getBuildingLabelColor(building, index).m_126665_().intValue());
        Text builderLabel = (Text)row.findPaneOfTypeByID(TEXT_BUILDER_NAME, Text.class);
        if (building.dontRepair) {
            builderLabel.setText(Component.m_237115_((String)"minecolonies_tweaks.gui.dont_repair").m_130940_(ChatFormatting.GRAY));
        } else {
            builderLabel.setText(Component.m_237110_((String)"minecolonies_tweaks.gui.assigned_builder_name", (Object[])new Object[]{builder != null ? Component.m_237110_((String)"minecolonies_tweaks.gui.builder_name_with_level", (Object[])new Object[]{builder.name, builder.building.getBuildingLevel()}) : Component.m_237115_((String)"minecolonies_tweaks.gui.builder_no_assigned").m_130940_(ChatFormatting.RED)}));
        }
    }

    protected ChatFormatting getBuildingLabelColor(BuildingInfo building, int index) {
        if (this.selectedBuildingIndex == index) {
            return ChatFormatting.GOLD;
        }
        if (building.dontRepair) {
            return ChatFormatting.GRAY;
        }
        return ChatFormatting.WHITE;
    }

    protected boolean testBuildingForList(BuildingInfo building) {
        return !this.exceptOpenablesOnlyChanged || !building.openableOnlyChanged;
    }

    protected boolean filterBuilding(String filter, BuildingInfo building) {
        if (filter.isEmpty()) {
            return true;
        }
        if (building.idLowerCase.contains(filter)) {
            return true;
        }
        if (building.nameLowerCase.contains(filter)) {
            return true;
        }
        BuilderInfo builder = this.assignments.get(building);
        return builder != null && builder.nameLowerCase.contains(filter);
    }

    protected void updateBuilderList() {
        int buildingIndex = this.selectedBuildingIndex;
        if (this.lastBuildersBuildingIndex == buildingIndex) {
            return;
        }
        this.lastBuildersBuildingIndex = buildingIndex;
        this.filteredBuilders.clear();
        if (buildingIndex > -1) {
            BuildingInfo building = this.filteredBuildings.get(buildingIndex);
            int buildingLevel = building.building.getBuildingLevel();
            this.builders.stream().filter(builder -> this.testWorkable(buildingLevel, (BuilderInfo)builder)).forEach(this.filteredBuilders::add);
            this.filteredBuilders.sort(this::compareBuilder);
        }
        this.builderList.refreshElementPanes();
    }

    protected int compareBuilder(BuilderInfo builder1, BuilderInfo builder2) {
        int level2;
        int level1;
        if (this.selectedBuildingIndex > -1) {
            BuildingInfo building = this.filteredBuildings.get(this.selectedBuildingIndex);
            BuilderInfo assigned = this.assignments.get(building);
            if (assigned == builder1) {
                return -1;
            }
            if (assigned == builder2) {
                return 1;
            }
        }
        if ((level1 = builder1.building.getBuildingLevel()) != (level2 = builder2.building.getBuildingLevel())) {
            return Integer.compare(level2, level1);
        }
        return builder1.nameLowerCase.compareTo(builder2.nameLowerCase);
    }

    protected void updateBuilderRow(int index, Pane row) {
        BuilderInfo builder = this.filteredBuilders.get(index);
        Text builderLabel = (Text)row.findPaneOfTypeByID(TEXT_BUILDER_NAME, Text.class);
        builderLabel.setText(Component.m_237110_((String)"minecolonies_tweaks.gui.builder_name_with_level", (Object[])new Object[]{builder.name, builder.building.getBuildingLevel()}));
        builderLabel.setColors(this.getBuilderLabelColor(index).m_126665_().intValue());
        Text assignedCountLabel = (Text)row.findPaneOfTypeByID(TEXT_ASSIGNED_COUNT, Text.class);
        assignedCountLabel.setText(Component.m_237110_((String)"minecolonies_tweaks.gui.assigned_count_with_value", (Object[])new Object[]{builder.cachedAssignedCount}));
    }

    protected void updateRepairResources() {
        int buildingIndex = this.selectedBuildingIndex;
        if (this.lastResourcesBuildingIndex == buildingIndex) {
            return;
        }
        this.lastResourcesBuildingIndex = buildingIndex;
        this.repairResources.clear();
        if (buildingIndex > -1) {
            this.repairResources.addAll(this.filteredBuildings.get((int)buildingIndex).repairResources);
            this.repairResources.sort(this::compareResource);
        }
        this.repairResourceList.refreshElementPanes();
        for (Pane pane : this.window.getChildren()) {
            if (!(pane instanceof Tooltip.AutomaticTooltip)) continue;
            Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
            tooltip.setTextOld(Arrays.asList(new Component[0]));
        }
    }

    protected int compareResource(ItemStack stack1, ItemStack stack2) {
        int id1 = Item.m_41393_((Item)stack1.m_41720_());
        int id2 = Item.m_41393_((Item)stack2.m_41720_());
        return Integer.compare(id1, id2);
    }

    protected void updateRepairResourceRow(int index, Pane row) {
        ItemStack stack = this.repairResources.get(index);
        ItemIcon icon = (ItemIcon)row.findPaneOfTypeByID("resourceIcon", ItemIcon.class);
        icon.setItem(stack);
        Text label = (Text)row.findPaneOfTypeByID("resourceName", Text.class);
        label.setText(stack.m_41786_());
    }

    protected ChatFormatting getBuilderLabelColor(int index) {
        if (this.selectedBuilderIndex == index) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.WHITE;
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (key == 256) {
            this.selectedBuildingIndex = -1;
        }
        return super.onUnhandledKeyTyped(ch, key);
    }

    protected void assign(BuildingInfo building, BuilderInfo builder) {
        building.dontRepair = false;
        BuilderInfo prevBuilder = this.assignments.put(building, builder);
        if (prevBuilder != builder) {
            ++builder.cachedAssignedCount;
            if (prevBuilder != null) {
                --prevBuilder.cachedAssignedCount;
            }
        }
    }

    protected void unassign(BuildingInfo building) {
        BuilderInfo builder = this.assignments.remove(building);
        if (builder != null) {
            --builder.cachedAssignedCount;
        }
    }

    protected void markAsDontRepair(BuildingInfo building) {
        building.dontRepair = true;
        this.unassign(building);
    }

    protected void unmarkAsDontRepair(BuildingInfo building) {
        building.dontRepair = false;
    }

    public IColonyView getColony() {
        return this.colony;
    }

    public Map<BuildingInfo, BuilderInfo> getAssignments() {
        return new HashMap<BuildingInfo, BuilderInfo>(this.assignments);
    }

    public static class BuilderInfo {
        public final ICitizenDataView citizen;
        public final Component name;
        public final String nameLowerCase;
        public final IBuildingView building;
        public int cachedAssignedCount = 0;

        public BuilderInfo(IColonyView colony, ICitizenDataView builder) {
            this.citizen = builder;
            this.name = Component.m_237113_((String)builder.getName());
            this.nameLowerCase = builder.getName().toLowerCase(Locale.ENGLISH);
            this.building = colony.getBuilding(builder.getWorkBuilding());
        }
    }

    public static class BuildingInfo {
        public final IBuildingView building;
        public final Component name;
        public final String idLowerCase;
        public final String nameLowerCase;
        public final ItemStack icon;
        public final int itemId;
        public final List<ItemStack> repairResources;
        public final boolean openableOnlyChanged;
        public boolean dontRepair = false;

        public BuildingInfo(IBuildingView building, Map<ItemStorage, AtomicInteger> repairResources) {
            this.building = building;
            BuildingEntry buildingEntry = building.getBuildingType();
            ResourceLocation buildingId = buildingEntry.getRegistryName();
            String customName = building.getCustomName();
            MutableComponent nameBase = customName.isEmpty() ? Component.m_237115_((String)("com." + buildingId.m_135827_() + ".building." + buildingId.m_135815_())) : Component.m_237113_((String)customName);
            this.name = nameBase.m_130946_(" ").m_130946_(String.valueOf(building.getBuildingLevel()));
            this.idLowerCase = buildingId.toString().toLowerCase(Locale.ENGLISH);
            this.nameLowerCase = this.name.getString().toLowerCase(Locale.ENGLISH);
            this.icon = new ItemStack((ItemLike)buildingEntry.getBuildingBlock());
            this.itemId = Item.m_41393_((Item)this.icon.m_41720_());
            this.repairResources = repairResources.entrySet().stream().map(this::toItemStack).toList();
            this.openableOnlyChanged = repairResources.keySet().stream().map(ItemStorage::getItem).allMatch(this::testExceptable);
        }

        private ItemStack toItemStack(Map.Entry<ItemStorage, AtomicInteger> entry) {
            ItemStack stack = entry.getKey().getItemStack().m_41777_();
            stack.m_41764_(entry.getValue().get());
            return stack;
        }

        private boolean testExceptable(Item item) {
            BlockItem blockItem;
            Block block;
            return item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).m_40614_()) instanceof DoorBlock || block instanceof TrapDoorBlock);
        }
    }
}

