/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.apiimpl.common.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizableRecipeStorage;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizedRecipeStorageRegistry;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class CustomizableRecipeStorageFactory
implements IFactory<IToken<?>, CustomizableRecipeStorage> {
    public static final TypeToken<CustomizableRecipeStorage> OUTPUT_TYPE = TypeToken.of(CustomizableRecipeStorage.class);
    public static final TypeToken<IToken<?>> INPUT_TYPE = TypeConstants.ITOKEN;
    public static final String TAG_IMPL = "impl";
    public static final String TAG_TOKEN = "token";

    @NotNull
    public TypeToken<CustomizableRecipeStorage> getFactoryOutputType() {
        return OUTPUT_TYPE;
    }

    @NotNull
    public TypeToken<? extends IToken<?>> getFactoryInputType() {
        return INPUT_TYPE;
    }

    @NotNull
    public CustomizableRecipeStorage getNewInstance(@NotNull IFactoryController factoryController, @NotNull IToken<?> input, Object ... context) throws IllegalArgumentException {
        ICustomizedRecipeStorage impl = (ICustomizedRecipeStorage)context[0];
        return new CustomizableRecipeStorage(input, impl);
    }

    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull CustomizableRecipeStorage output) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(TAG_IMPL, (Tag)CustomizedRecipeStorageRegistry.INSTANCE.serialize(output.getImpl()));
        tag.m_128365_(TAG_TOKEN, (Tag)StandardFactoryController.getInstance().serialize(output.getToken()));
        return tag;
    }

    @NotNull
    public CustomizableRecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag tag) throws Throwable {
        ICustomizedRecipeStorage impl = (ICustomizedRecipeStorage)CustomizedRecipeStorageRegistry.INSTANCE.deserialize(tag.m_128469_(TAG_IMPL));
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(tag.m_128469_(TAG_TOKEN));
        return new CustomizableRecipeStorage(token, impl);
    }

    public void serialize(@NotNull IFactoryController controller, @NotNull CustomizableRecipeStorage output, FriendlyByteBuf buffer) {
        buffer.m_130079_(CustomizedRecipeStorageRegistry.INSTANCE.serialize(output.getImpl()));
        controller.serialize(buffer, output.getToken());
    }

    @NotNull
    public CustomizableRecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer) throws Throwable {
        ICustomizedRecipeStorage impl = (ICustomizedRecipeStorage)CustomizedRecipeStorageRegistry.INSTANCE.deserialize(buffer.m_130260_());
        IToken token = (IToken)controller.deserialize(buffer);
        return new CustomizableRecipeStorage(token, impl);
    }

    public short getSerializationId() {
        return 10704;
    }
}

