/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.minecolonies.api.util.constant.IToolType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class ToolTypeExtension {
    private static Map<IToolType, ToolTypeExtension> MAP = new HashMap<IToolType, ToolTypeExtension>();
    @NotNull
    private final IToolType toolType;
    @Nullable
    private final CustomToolType customToolType;
    private TagKey<Item> itemTag;
    private final Int2ObjectOpenHashMap<TagKey<Item>> levelTags;

    @NotNull
    public static ToolTypeExtension from(@NotNull IToolType toolType) {
        return MAP.computeIfAbsent(toolType, ToolTypeExtension::new);
    }

    @NotNull
    public static TagKey<Item> getItemCustomTag(@NotNull String name) {
        String path = "custom_tools/" + name.toLowerCase();
        return ItemTags.create((ResourceLocation)MineColoniesTweaks.rl(path));
    }

    @NotNull
    public static TagKey<Item> getItemCustomLevelTag(@NotNull String name, int level) {
        String path = "custom_tools/" + name.toLowerCase() + "/" + level;
        return ItemTags.create((ResourceLocation)MineColoniesTweaks.rl(path));
    }

    private ToolTypeExtension(@NotNull IToolType toolType) {
        this.toolType = toolType;
        this.customToolType = CustomToolType.find(toolType.getName());
        this.levelTags = new Int2ObjectOpenHashMap();
    }

    public int getCustomLevel(@NotNull ItemStack item) {
        int level;
        CustomToolType custom = this.getCustomToolType();
        if (custom != null && (level = custom.getToolLevel(item)) > -1) {
            return level;
        }
        for (int i = 0; i <= 5; ++i) {
            if (!item.m_204117_(this.getItemCustomLevelTag(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean isCustomTool(@NotNull ItemStack itemStack) {
        CustomToolType custom = this.getCustomToolType();
        if (custom != null && custom.isTool(itemStack)) {
            return true;
        }
        int level = this.getCustomLevel(itemStack);
        if (level == -1) {
            return itemStack.m_204117_(this.getItemCustomTag());
        }
        return true;
    }

    @NotNull
    public IToolType getToolType() {
        return this.toolType;
    }

    @Nullable
    public CustomToolType getCustomToolType() {
        return this.customToolType;
    }

    @NotNull
    public TagKey<Item> getItemCustomTag() {
        if (this.itemTag == null) {
            this.itemTag = ToolTypeExtension.getItemCustomTag(this.getToolType().getName());
        }
        return this.itemTag;
    }

    @NotNull
    public TagKey<Item> getItemCustomLevelTag(int level) {
        return (TagKey)this.levelTags.computeIfAbsent(level, l -> ToolTypeExtension.getItemCustomLevelTag(this.getToolType().getName(), l));
    }
}

