/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;

public class OrToolType
extends CustomToolType {
    private final List<Supplier<IToolType>> toolTypes;

    public OrToolType(ResourceLocation name, Collection<Supplier<IToolType>> toolTypes) {
        super(name);
        this.toolTypes = toolTypes.stream().toList();
    }

    public List<Supplier<IToolType>> getToolTypes() {
        return this.toolTypes;
    }

    @Override
    protected int getToolLevel(@NotNull ItemStack stack) {
        for (Supplier<IToolType> supplier : this.getToolTypes()) {
            IToolType toolType = supplier.get();
            int level = ItemStackUtils.getMiningLevel((ItemStack)stack, (IToolType)toolType);
            if (level <= -1) continue;
            return level;
        }
        return super.getToolLevel(stack);
    }

    @Override
    protected boolean isTool(@NotNull ItemStack stack) {
        for (Supplier<IToolType> supplier : this.getToolTypes()) {
            IToolType toolType = supplier.get();
            if (!ItemStackUtils.isTool((ItemStack)stack, (IToolType)toolType)) continue;
            return true;
        }
        return super.isTool(stack);
    }
}

