/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.tool.ConfigToolType;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolTypeRegisterEvent;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.config.MineColoniesTweaksConfigCommon;

public class CustomToolType {
    private static final Map<String, CustomToolType> MAP = new HashMap<String, CustomToolType>();
    private static final List<CustomToolType> LIST = new ArrayList<CustomToolType>();
    @NotNull
    private final ResourceLocation name;
    @Nullable
    private Component displayName;
    @Nullable
    private ToolType toolType;

    public static void init() {
        Gson gson = new Gson();
        for (String raw : (List)MineColoniesTweaksConfigCommon.INSTANCE.tools.customTypes.get()) {
            JsonObject json = (JsonObject)gson.fromJson(raw, JsonObject.class);
            ConfigToolType.Builder builder = new ConfigToolType.Builder(json);
            CustomToolType.register(new ConfigToolType(builder, "minecolonies_tweaks"));
        }
        MinecraftForge.EVENT_BUS.post((Event)new CustomToolTypeRegisterEvent(CustomToolType::register));
    }

    private static void register(CustomToolType data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        ResourceLocation name = data.getName();
        String path = name.m_135815_();
        CustomToolType prev = MAP.get(path);
        if (prev != null) {
            throw new IllegalArgumentException("Name '" + path + "' is already registered from: " + prev.getName().m_135827_());
        }
        MAP.put(path, data);
        LIST.add(data);
        MineColoniesTweaks.LOGGER.info("CustomToolTypeData Added: " + name);
    }

    @NotNull
    public static Map<String, CustomToolType> map() {
        return Collections.unmodifiableMap(MAP);
    }

    @NotNull
    public static List<CustomToolType> list() {
        return Collections.unmodifiableList(LIST);
    }

    @Nullable
    public static CustomToolType find(@Nullable IToolType toolType) {
        return toolType != null ? CustomToolType.find(toolType.getName()) : null;
    }

    @Nullable
    public static CustomToolType find(@NotNull String name) {
        return MAP.get(name);
    }

    public CustomToolType(@NotNull ResourceLocation name) {
        this.name = name;
    }

    @NotNull
    public static String getFallbackTranslationKey(@NotNull String name) {
        return "minecolonies_tweaks.custom_tooltype." + name;
    }

    @NotNull
    public final ResourceLocation getName() {
        return this.name;
    }

    public boolean hasVariableMaterials() {
        return false;
    }

    protected Component createDisplayName() {
        return Component.m_237115_((String)CustomToolType.getFallbackTranslationKey(this.getName().m_135815_()));
    }

    @NotNull
    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.createDisplayName();
        }
        return this.displayName;
    }

    @NotNull
    public Optional<Integer> getDefaultLevel() {
        return Optional.empty();
    }

    public final void pair(@NotNull ToolType toolType) {
        if (this.toolType != null) {
            throw new IllegalCallerException("Already paired");
        }
        if (toolType == null) {
            throw new NullPointerException("toolType");
        }
        this.toolType = toolType;
    }

    @NotNull
    public final ToolType getToolType() {
        if (this.toolType == null) {
            throw new IllegalCallerException("Not paired");
        }
        return this.toolType;
    }

    protected int getToolLevel(@NotNull ItemStack stack) {
        return -1;
    }

    protected boolean isTool(@NotNull ItemStack stack) {
        return false;
    }
}

