/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;
import steve_gall.minecolonies_tweaks.core.common.util.GsonHelper2;

public class ConfigToolType
extends CustomToolType {
    private final boolean hasVariableMaterials;
    @NotNull
    private final String translationKey;
    @NotNull
    private final Optional<Integer> defaultLevel;

    public ConfigToolType(Builder builder, String namespace) {
        super(new ResourceLocation(namespace, builder.name));
        this.hasVariableMaterials = builder.hasVariableMaterials;
        this.translationKey = builder.translationKey.orElseGet(() -> ConfigToolType.getFallbackTranslationKey(this.getName().m_135815_()));
        this.defaultLevel = builder.defaultLevel;
    }

    @Override
    public boolean hasVariableMaterials() {
        return this.hasVariableMaterials;
    }

    @Override
    protected Component createDisplayName() {
        return Component.m_237115_((String)this.translationKey);
    }

    @Override
    @NotNull
    public Optional<Integer> getDefaultLevel() {
        return this.defaultLevel;
    }

    public static class Builder {
        @NotNull
        private final String name;
        private boolean hasVariableMaterials = false;
        @NotNull
        private Optional<String> translationKey = Optional.empty();
        private Optional<Integer> defaultLevel = Optional.empty();

        public Builder(@NotNull String name) {
            this.name = name;
        }

        public Builder(@NotNull ConfigToolType data) {
            this.name = data.getName().m_135815_();
            this.hasVariableMaterials = data.hasVariableMaterials;
            this.translationKey = Optional.of(data.translationKey);
            this.defaultLevel = data.defaultLevel;
        }

        public Builder(@NotNull JsonObject json) {
            this.name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            this.hasVariableMaterials = GsonHelper.m_13855_((JsonObject)json, (String)"hasVariableMaterials", (boolean)false);
            this.translationKey = GsonHelper2.of(json, "translationKey", GsonHelper::m_13906_);
            this.defaultLevel = GsonHelper2.of(json, "defaultLevel", GsonHelper::m_13927_);
        }

        @NotNull
        public JsonObject toObject() {
            JsonObject json = new JsonObject();
            json.addProperty("name", this.name());
            json.addProperty("hasVariableMaterials", Boolean.valueOf(this.hasVariableMaterials()));
            GsonHelper2.ifPresent("translationKey", this.translationKey(), (arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            GsonHelper2.ifPresent("defaultLevel", this.defaultLevel(), (arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            return json;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        public boolean hasVariableMaterials() {
            return this.hasVariableMaterials;
        }

        @NotNull
        public Builder hasVariableMaterials(boolean hasVariableMaterials) {
            this.hasVariableMaterials = hasVariableMaterials;
            return this;
        }

        @NotNull
        public Optional<String> translationKey() {
            return this.translationKey;
        }

        @NotNull
        public Builder translationKey(@NotNull Optional<String> translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        @NotNull
        public Optional<Integer> defaultLevel() {
            return this.defaultLevel;
        }

        @NotNull
        public Builder defaultLevel(@NotNull Optional<Integer> defaultLevel) {
            this.defaultLevel = defaultLevel;
            return this;
        }
    }
}

