/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.pathfinding;

import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimplePathJob<RESULT extends PathResult>
extends AbstractPathJob {
    @NotNull
    private final BlockPos home;
    @Nullable
    private final BoundingBox restrictionBox;

    public SimplePathJob(@NotNull Level level, @NotNull BlockPos start, @NotNull BlockPos home, int range, @Nullable Mob entity, @NotNull RESULT result) {
        super(level, start, range, result, entity);
        this.restrictionBox = null;
        this.home = home;
    }

    public SimplePathJob(@NotNull Level level, @NotNull BlockPos start, @NotNull BoundingBox restrictionBox, @Nullable Mob entity, RESULT result) {
        super(level, start, (int)SimplePathJob.getRange(start, restrictionBox), result, entity);
        this.restrictionBox = restrictionBox;
        this.home = restrictionBox.m_162394_();
    }

    private static double getRange(@NotNull BlockPos home, @NotNull BoundingBox restrictionBox) {
        int minX = restrictionBox.m_162395_();
        int minY = restrictionBox.m_162396_();
        int minZ = restrictionBox.m_162398_();
        int maxX = restrictionBox.m_162399_();
        int maxY = restrictionBox.m_162400_();
        int maxZ = restrictionBox.m_162401_();
        return Math.max(SimplePathJob.distManhattan(home, minX, minY, minZ), SimplePathJob.distManhattan(home, maxX, maxY, maxZ)) + SimplePathJob.distManhattan(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static int distManhattan(BlockPos pos, BlockPos pos2) {
        return SimplePathJob.distManhattan(pos, pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_());
    }

    public static int distManhattan(BlockPos pos, int x2, int y2, int z2) {
        return SimplePathJob.distManhattan(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), x2, y2, z2);
    }

    public static int distManhattan(int x1, int y1, int z1, int x2, int y2, int z2) {
        int xDist = Math.abs(x1 - x2);
        int yDist = Math.abs(y1 - y2);
        int zDist = Math.abs(z1 - z2);
        return xDist + yDist + zDist;
    }

    @NotNull
    public RESULT getResult() {
        return (RESULT)super.getResult();
    }

    protected double computeHeuristic(int x, int y, int z) {
        return SimplePathJob.distManhattan(this.home, x, y, z);
    }

    protected boolean isAtDestination(@NotNull MNode n) {
        return n.parent != null && this.isNearTarget(n) && SurfaceType.getSurfaceType((BlockGetter)this.world, (BlockState)this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), (PathingOptions)this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    private boolean isNearTarget(@NotNull MNode n) {
        if (n.parent == null) {
            return false;
        }
        if (n.x == n.parent.x) {
            int dz = n.z > n.parent.z ? 1 : -1;
            return this.test(n.x, n.y, n.z + dz) || this.test(n.x - 1, n.y, n.z) || this.test(n.x + 1, n.y, n.z);
        }
        int dx = n.x > n.parent.x ? 1 : -1;
        return this.test(n.x + dx, n.y, n.z) || this.test(n.x, n.y, n.z - 1) || this.test(n.x, n.y, n.z + 1);
    }

    protected boolean test(int x, int y, int z) {
        return this.testRestrictionBox(x, y, z) && this.testTarget(x, y, z);
    }

    protected boolean testRestrictionBox(int x, int y, int z) {
        if (this.restrictionBox == null) {
            return true;
        }
        return this.restrictionBox.m_162395_() <= x && x <= this.restrictionBox.m_162399_() && this.restrictionBox.m_162396_() <= y && y <= this.restrictionBox.m_162400_() && this.restrictionBox.m_162398_() <= z && z <= this.restrictionBox.m_162401_();
    }

    protected double getEndNodeScore(@NotNull MNode n) {
        return 0.0;
    }

    protected abstract boolean testTarget(int var1, int var2, int var3);
}

