/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.building.module;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModuleView;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.network.message.AssignIdListUpdateMessage;

public abstract class AbstractIdListModuleView
extends AbstractBuildingModuleView
implements IIdListModuleView {
    private String listId = "";
    private final Set<ResourceLocation> ids = new HashSet<ResourceLocation>();

    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.listId = buf.m_130277_();
        this.ids.clear();
        this.ids.addAll(buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130281_));
    }

    @Override
    public void addIds(@NotNull Collection<ResourceLocation> ids) {
        MineColoniesTweaks.network().sendToServer(new AssignIdListUpdateMessage(this, AssignIdListUpdateMessage.Function.ADD, ids));
        this.ids.addAll(ids);
    }

    @Override
    public boolean containsId(@NotNull ResourceLocation id) {
        return this.ids.contains(id);
    }

    @Override
    public boolean removeIds(@NotNull Collection<ResourceLocation> ids) {
        MineColoniesTweaks.network().sendToServer(new AssignIdListUpdateMessage(this, AssignIdListUpdateMessage.Function.REMOVE, ids));
        return this.ids.removeAll(ids);
    }

    @Override
    public void clearIds() {
        MineColoniesTweaks.network().sendToServer(new AssignIdListUpdateMessage(this, AssignIdListUpdateMessage.Function.CLEAR, Collections.emptyList()));
        this.ids.clear();
    }

    @Override
    @NotNull
    public String getListId() {
        return this.listId;
    }
}

