/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.building.module;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModule;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public abstract class AbstractIdListModule
extends AbstractBuildingModule
implements IPersistentModule,
IIdListModule {
    public static final String TAG_IDS = MineColoniesTweaks.rl("ids").toString();
    @NotNull
    private final String listId;
    @NotNull
    private final Set<ResourceLocation> ids;

    public AbstractIdListModule(@NotNull String listId) {
        this.listId = listId;
        this.ids = new HashSet<ResourceLocation>();
    }

    public void deserializeNBT(@NotNull CompoundTag compound) {
        this.ids.clear();
        ListTag idsTag = compound.m_128437_(TAG_IDS, 8);
        for (int i = 0; i < idsTag.size(); ++i) {
            this.ids.add(new ResourceLocation(idsTag.m_128778_(i)));
        }
    }

    public void serializeNBT(@NotNull CompoundTag compound) {
        ListTag idsTag = new ListTag();
        compound.m_128365_(TAG_IDS, (Tag)idsTag);
        for (ResourceLocation id : this.ids) {
            idsTag.add((Object)StringTag.m_129297_((String)id.toString()));
        }
    }

    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.m_130070_(this.listId);
        buf.m_236828_(this.ids, FriendlyByteBuf::m_130085_);
    }

    @Override
    public void addId(@NotNull ResourceLocation id) {
        boolean added = this.ids.add(id);
        if (added) {
            this.markDirty();
        }
    }

    @Override
    public boolean containsId(@NotNull ResourceLocation id) {
        return this.ids.contains(id);
    }

    @Override
    public boolean removeId(@NotNull ResourceLocation id) {
        boolean removed = this.ids.remove(id);
        if (removed) {
            this.markDirty();
        }
        return removed;
    }

    @Override
    public void clearIds() {
        this.ids.clear();
        this.markDirty();
    }

    @NotNull
    public Set<ResourceLocation> getIds() {
        return new HashSet<ResourceLocation>(this.ids);
    }

    @Override
    @NotNull
    public String getListId() {
        return this.listId;
    }
}

