/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public abstract class CustomizableObjectRegistry<OBJECT> {
    public static final String TAG_ID = "ID";
    public static final String TAG_OBJECT = "Object";
    public static final ResourceLocation EMPTY_ID = MineColoniesTweaks.rl("empty");
    public static final String EMPTY_ID_STRING = EMPTY_ID.toString();
    private final Map<ResourceLocation, Entry<?>> map = new HashMap();

    public <TYPED_OBJECT extends OBJECT> void register(@NotNull ResourceLocation id, @NotNull BiConsumer<CompoundTag, TYPED_OBJECT> serializer, @NotNull Function<CompoundTag, TYPED_OBJECT> desrializer) {
        if (this.map.containsKey(id)) {
            throw new IllegalArgumentException("ID " + id + " is already registered");
        }
        this.map.put(id, new Entry<TYPED_OBJECT>(id, serializer, desrializer));
    }

    protected abstract ResourceLocation getId(OBJECT var1);

    @NotNull
    public CompoundTag serialize(@Nullable OBJECT object) {
        CompoundTag tag = new CompoundTag();
        this.serialize(object, tag);
        return tag;
    }

    public void serialize(@Nullable OBJECT object, @NotNull CompoundTag tag) {
        if (object == null) {
            return;
        }
        ResourceLocation id = this.getId(object);
        Entry<?> supplier = this.map.get(id);
        if (supplier == null) {
            throw new IllegalArgumentException("ID " + id + " is not registered");
        }
        tag.m_128359_(TAG_ID, id.toString());
        tag.m_128365_(TAG_OBJECT, (Tag)this.serializeWithoutId(object));
    }

    public CompoundTag serializeWithoutId(@Nullable OBJECT object) {
        CompoundTag tag = new CompoundTag();
        this.serializeWithoutId(object, tag);
        return tag;
    }

    public void serializeWithoutId(@Nullable OBJECT object, @NotNull CompoundTag tag) {
        if (object == null) {
            return;
        }
        ResourceLocation id = this.getId(object);
        Entry<?> supplier = this.map.get(id);
        if (supplier == null) {
            throw new IllegalArgumentException("ID " + id + " is not registered");
        }
        BiConsumer serializer = supplier.serializer;
        serializer.accept(tag, object);
    }

    @Nullable
    public OBJECT deserialize(@NotNull CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.m_128461_(TAG_ID));
        return this.deserializeWithoutId(tag.m_128469_(TAG_OBJECT), id);
    }

    public OBJECT deserializeWithoutId(@NotNull CompoundTag tag, ResourceLocation id) {
        Entry<?> supplier = this.map.get(id);
        if (supplier == null) {
            return null;
        }
        return supplier.deserializer.apply(tag);
    }

    private static class Entry<OBJECT> {
        @NotNull
        private ResourceLocation id;
        @NotNull
        private BiConsumer<CompoundTag, OBJECT> serializer;
        @NotNull
        private Function<CompoundTag, OBJECT> deserializer;

        public Entry(@NotNull ResourceLocation id, @NotNull BiConsumer<CompoundTag, OBJECT> serializer, @NotNull Function<CompoundTag, OBJECT> deserializer) {
            this.id = id;
            this.serializer = serializer;
            this.deserializer = deserializer;
        }
    }
}

