/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.generation;

import io.github.mortuusars.wares.data.generation.provider.Advancements;
import io.github.mortuusars.wares.data.generation.provider.BlockStatesAndModels;
import io.github.mortuusars.wares.data.generation.provider.BlockTags;
import io.github.mortuusars.wares.data.generation.provider.ItemModels;
import io.github.mortuusars.wares.data.generation.provider.ItemTags;
import io.github.mortuusars.wares.data.generation.provider.LootTables;
import io.github.mortuusars.wares.data.generation.provider.Recipes;
import io.github.mortuusars.wares.data.generation.provider.Sounds;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wares", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new Advancements(generator, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LootTables.BlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(LootTables.ChestLoot::new, LootContextParamSets.f_81411_))));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(generator));
        BlockTags blockTags = new BlockTags(generator, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(generator, lookupProvider, blockTags, helper));
        BlockStatesAndModels blockStates = new BlockStatesAndModels(generator, helper);
        generator.addProvider(event.includeClient(), (DataProvider)blockStates);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(generator, blockStates.models().existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new Sounds(generator, helper));
    }
}

