/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.mpfui.component;

public record Rectangle(int x, int y, int width, int height) {
    public int left() {
        return this.x;
    }

    public int top() {
        return this.y;
    }

    public int right() {
        return this.x + this.width;
    }

    public int bottom() {
        return this.y + this.height;
    }

    public int centerX() {
        return this.left() + this.width / 2;
    }

    public int centerY() {
        return this.top() + this.height / 2;
    }

    public Rectangle intersect(Rectangle other) {
        int right = this.right();
        int bottom = this.bottom();
        int otherRight = other.right();
        int otherBottom = other.bottom();
        int x = Math.max(this.x, other.x);
        int y = Math.max(this.y, other.y);
        int width = Math.max(0, Math.min(right, otherRight) - x);
        int height = Math.max(0, Math.min(bottom, otherBottom) - y);
        return new Rectangle(x, y, width, height);
    }

    public Rectangle shrink(int left, int top, int right, int bottom) {
        return new Rectangle(this.left() + left, this.top() + top, Math.max(0, this.width - left - right), Math.max(0, this.height - top - bottom));
    }

    public Rectangle shift(int x, int y) {
        return new Rectangle(this.left() + x, this.top() + y, this.width, this.height);
    }

    public boolean contains(int x, int y) {
        return x >= this.left() && x <= this.right() && y >= this.top() && y <= this.bottom();
    }

    @Override
    public String toString() {
        return "Rectangle{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "}";
    }
}

