/*
 * Decompiled with CFR 0.152.
 */
package com.ichphilipp.logicchips.utils;

import com.ichphilipp.logicchips.LogicChips;
import com.ichphilipp.logicchips.blocks.LogicChipsBlock;
import com.ichphilipp.logicchips.items.LogicChipsItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class RegistryMgr {
    public static final Map<String, LogicChipsItem> ITEMS = new HashMap<String, LogicChipsItem>();
    public static final Map<String, LogicChipsBlock> BLOCKS = new HashMap<String, LogicChipsBlock>();
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"logicchips", (ResourceKey)Registries.f_279569_);
    public static final DeferredRegister<Item> ITEM_REG = DeferredRegister.create((String)"logicchips", (ResourceKey)Registries.f_256913_);
    public static final DeferredRegister<Block> BLOCK_REG = DeferredRegister.create((String)"logicchips", (ResourceKey)Registries.f_256747_);

    public static <T extends Item> RegistrySupplier<T> registerItem(String name, Supplier<T> item) {
        return ITEM_REG.register(name, item);
    }

    public static RegistrySupplier<Item> registerItem(String name) {
        return RegistryMgr.registerItem(name, () -> new Item(LogicChips.DEFAULT_ITEM_PROP));
    }

    public static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        return BLOCK_REG.register(name, block);
    }

    public static <T extends Block> RegistrySupplier<BlockItem> registerBlockItem(String name, RegistrySupplier<T> block) {
        return ITEM_REG.register(name, () -> new BlockItem((Block)block.get(), LogicChips.DEFAULT_ITEM_PROP));
    }

    public static void init() {
        TABS.register();
        ITEM_REG.register();
        BLOCK_REG.register();
    }
}

