/*
 * Decompiled with CFR 0.152.
 */
package com.ichphilipp.logicchips.items;

import com.ichphilipp.logicchips.LogicChips;
import com.ichphilipp.logicchips.api.TriBoolLogic;
import com.ichphilipp.logicchips.items.Chip;
import com.ichphilipp.logicchips.utils.ChipType;
import com.ichphilipp.logicchips.utils.RegistryMgr;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public enum LogicChipsItem implements Supplier<Item>
{
    CHIP,
    NOT_GATE(ChipType.not),
    AND_GATE(ChipType.and),
    NAND_GATE(ChipType.nand),
    OR_GATE(ChipType.or),
    NOR_GATE(ChipType.nor),
    XOR_GATE(ChipType.xor),
    XNOR_GATE(ChipType.xnor),
    AND_GATE_3(ChipType.and_3),
    NAND_GATE_3(ChipType.nand_3),
    OR_GATE_3(ChipType.or_3),
    NOR_GATE_3(ChipType.nor_3),
    XOR_GATE_3(ChipType.xor_3),
    XNOR_GATE_3(ChipType.xnor_3);

    private final String key = this.name().toLowerCase();
    private final TriBoolLogic logic;
    private final RegistrySupplier<Item> item;

    @Override
    public Item get() {
        return (Item)this.item.get();
    }

    @Nullable
    public TriBoolLogic logic() {
        return this.logic;
    }

    private LogicChipsItem(ChipType type) {
        this.logic = type.logic();
        this.item = RegistryMgr.registerItem(this.key, () -> new Chip(LogicChips.DEFAULT_CHIP_PROP, type));
    }

    private LogicChipsItem() {
        this.logic = null;
        this.item = RegistryMgr.registerItem(this.key);
    }

    public static void init() {
        for (LogicChipsItem item : LogicChipsItem.values()) {
            RegistryMgr.ITEMS.put(item.key, item);
        }
    }
}

