/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.cristelknight.doapi.DoApi;
import de.cristelknight.doapi.common.block.StandardBlock;
import de.cristelknight.doapi.common.block.StandardWallBlock;
import de.cristelknight.doapi.common.block.entity.StandardBlockEntity;
import de.cristelknight.doapi.common.item.StandardItem;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StandardBlockEntityRenderer
implements BlockEntityRenderer<StandardBlockEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("doapi", "standard"), "main");
    public static final String FLAG = "flag";
    private static final String POLE = "pole";
    private static final String BAR = "bar";
    private final ModelPart flag;
    private final ModelPart pole;
    private final ModelPart bar;

    public StandardBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(LAYER_LOCATION);
        this.flag = modelPart.m_171324_(FLAG);
        this.pole = modelPart.m_171324_(POLE);
        this.bar = modelPart.m_171324_(BAR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(FLAG, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, 0.0f, -1.0f, 20.0f, 40.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-44.0f, (float)0.0f, (float)-0.0349f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_(POLE, CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-1.0f, -30.0f, -1.0f, 2.0f, 42.0f, 2.0f), PartPose.f_171404_);
        partDefinition.m_171599_(BAR, CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-10.0f, -32.0f, -0.0f, 20.0f, 2.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(StandardBlockEntity standard, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        long time;
        float scale = 0.66f;
        boolean inInventory = standard.m_58904_() == null;
        poseStack.m_85836_();
        if (inInventory) {
            time = 0L;
            poseStack.m_85837_(0.5, 0.5, 0.5);
            this.pole.f_104207_ = true;
        } else {
            time = standard.m_58904_().m_46467_();
            BlockState blockState = standard.m_58900_();
            if (!(blockState.m_60734_() instanceof StandardWallBlock)) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                rotation = (float)(-((Integer)blockState.m_61143_((Property)StandardBlock.ROTATION)).intValue() * 360) / 16.0f;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                this.pole.f_104207_ = true;
            } else {
                poseStack.m_85837_(0.5, -0.1666666716337204, 0.5);
                rotation = -((Direction)blockState.m_61143_((Property)StandardWallBlock.FACING)).m_122435_();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                poseStack.m_85837_(0.0, -0.3125, -0.4375);
                this.pole.f_104207_ = false;
            }
        }
        poseStack.m_85836_();
        poseStack.m_85841_(scale, -scale, -scale);
        VertexConsumer vertexConsumer = ModelBakery.f_119224_.m_119194_(multiBufferSource, RenderType::m_110446_);
        this.pole.m_104301_(poseStack, vertexConsumer, i, j);
        this.bar.m_104301_(poseStack, vertexConsumer, i, j);
        BlockPos blockPos = standard.m_58899_();
        float k = ((float)Math.floorMod((long)blockPos.m_123341_() * 7L + (long)blockPos.m_123342_() * 9L + (long)blockPos.m_123343_() * 13L + time, 100L) + f) / 100.0f;
        this.flag.f_104203_ = (-0.0125f + 0.01f * Mth.m_14089_((float)((float)Math.PI * 2 * k))) * (float)Math.PI;
        this.flag.f_104201_ = -32.0f;
        StandardBlockEntityRenderer.renderStandard(poseStack, multiBufferSource, i, j, this.flag, standard);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public static void renderStandard(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, ModelPart modelPart, StandardBlockEntity standard) {
        ResourceLocation location = StandardItem.getLocationOrNull(standard.getItem());
        if (location == null) {
            DoApi.LOGGER.error("ResourceLocation for StandardBlock texture is null! At: " + standard.m_58899_());
            return;
        }
        VertexConsumer vc = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)location));
        modelPart.m_104301_(poseStack, vc, i, j);
    }
}

