/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cristelknight.doapi.config.builtin.RBConfig;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PrivateRecipeAlternativesWidget
implements Renderable,
GuiEventListener {
    static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/gui/recipe_book.png");
    private final List<CustomAlternativeButtonWidget> alternativeButtons = Lists.newArrayList();
    private boolean visible;
    private int buttonX;
    private int buttonY;
    private Recipe<?> recipe;
    @Nullable
    private Recipe<?> lastClickedRecipe;
    float time;

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Recipe<?> getResults() {
        return this.recipe;
    }

    @Nullable
    public Recipe<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    public void showAlternativesForResult(Recipe<?> recipe, int buttonX, int buttonY, int areaCenterX, int areaCenterY, float delta) {
        float p;
        float o;
        float n;
        float h;
        this.recipe = recipe;
        boolean bl = ((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle();
        int k = 4;
        int l = (int)Math.ceil(1.0f / (float)k);
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        float f = this.buttonX + 25;
        float g = areaCenterX + 50;
        if (f > g) {
            this.buttonX = (int)((float)this.buttonX - delta * (float)((int)((f - g) / delta)));
        }
        if ((h = (float)(this.buttonY + l * 25)) > (n = (float)(areaCenterY + 50))) {
            this.buttonY = (int)((float)this.buttonY - delta * (float)Mth.m_14167_((float)((h - n) / delta)));
        }
        if ((o = (float)this.buttonY) < (p = (float)(areaCenterY - 100))) {
            this.buttonY = (int)((float)this.buttonY - delta * (float)Mth.m_14167_((float)((o - p) / delta)));
        }
        this.visible = true;
        this.alternativeButtons.clear();
        this.alternativeButtons.add(new CustomAlternativeButtonWidget(this.buttonX + 6, this.buttonY + 6, this.recipe, bl));
        this.lastClickedRecipe = null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        CustomAlternativeButtonWidget alternativeButtonWidget;
        if (button != 0) {
            return false;
        }
        Iterator<CustomAlternativeButtonWidget> var6 = this.alternativeButtons.iterator();
        do {
            if (var6.hasNext()) continue;
            return false;
        } while (!(alternativeButtonWidget = var6.next()).m_6375_(mouseX, mouseY, button));
        this.lastClickedRecipe = alternativeButtonWidget.recipe;
        return true;
    }

    public void m_93692_(boolean focused) {
    }

    public boolean m_93696_() {
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            this.time += delta;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 170.0);
            int i = this.alternativeButtons.size() <= 16 ? 4 : 5;
            int j = Math.min(this.alternativeButtons.size(), i);
            int k = Mth.m_14167_((float)((float)this.alternativeButtons.size() / (float)i));
            this.renderGrid(guiGraphics, j, k, 24, 4, 82, 208);
            RenderSystem.disableBlend();
            for (CustomAlternativeButtonWidget alternativeButtonWidget : this.alternativeButtons) {
                alternativeButtonWidget.m_88315_(guiGraphics, mouseX, mouseY, delta);
            }
            poseStack.m_85849_();
        }
    }

    private void renderGrid(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n) {
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX, this.buttonY, m, n, l, l);
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY, m + k + l, n, l, l);
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX, this.buttonY + l * 2 + j * k, m, n + k + l, l, l);
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY + l * 2 + j * k, m + k + l, n + k + l, l, l);
        for (int o = 0; o < i; ++o) {
            guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY, m + l, n, k, l);
            guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k, this.buttonY, m + l, n, l, l);
            for (int p = 0; p < j; ++p) {
                if (o == 0) {
                    guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX, this.buttonY + l + p * k, m, n + l, l, k);
                    guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX, this.buttonY + l + (p + 1) * k, m, n + l, l, l);
                }
                guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY + l + p * k, m + l, n + l, k, k);
                guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k, this.buttonY + l + p * k, m + l, n + l, l, k);
                guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY + l + (p + 1) * k, m + l, n + l, k, l);
                guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k - 1, this.buttonY + l + (p + 1) * k - 1, m + l, n + l, l + 1, l + 1);
                if (o != i - 1) continue;
                guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY + l + p * k, m + k + l, n + l, l, k);
                guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l * 2 + i * k, this.buttonY + l + (p + 1) * k, m + k + l, n + l, l, l);
            }
            guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + o * k, this.buttonY + l * 2 + j * k, m + l, n + k + l, k, l);
            guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.buttonX + l + (o + 1) * k, this.buttonY + l * 2 + j * k, m + l, n + k + l, l, l);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class CustomAlternativeButtonWidget
    extends AbstractWidget
    implements PlaceRecipe<Ingredient> {
        final Recipe<?> recipe;
        private final boolean craftable;
        protected final List<InputSlot> slots;

        public CustomAlternativeButtonWidget(int x, int y, Recipe<?> recipe, boolean craftable) {
            super(x, y, 200, 20, CommonComponents.f_237098_);
            this.slots = Lists.newArrayList();
            this.f_93618_ = 24;
            this.f_93619_ = 24;
            this.recipe = recipe;
            this.craftable = craftable;
            this.alignRecipe(recipe);
        }

        protected void alignRecipe(Recipe<?> recipe) {
            this.m_135408_(3, 3, -1, recipe, recipe.m_7527_().iterator(), 0);
        }

        protected void m_168797_(NarrationElementOutput builder) {
            this.m_168802_(builder);
        }

        public void m_5817_(Iterator<Ingredient> inputs, int slot, int amount, int gridX, int gridY) {
            ItemStack[] itemStacks = inputs.next().m_43908_();
            if (itemStacks.length != 0) {
                this.slots.add(new InputSlot(3 + gridY * 7, 3 + gridX * 7, itemStacks));
            }
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            int i = 152;
            if (!this.craftable) {
                i += 26;
            }
            int j = 78;
            if (this.m_274382_()) {
                j += 26;
            }
            guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), i, j, this.f_93618_, this.f_93619_);
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.m_85836_();
            poseStack.m_85837_((double)(this.m_252754_() + 2), (double)(this.m_252907_() + 2), 125.0);
            for (InputSlot inputSlot : this.slots) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)inputSlot.y, (double)inputSlot.x, 0.0);
                poseStack.m_85841_(0.375f, 0.375f, 1.0f);
                poseStack.m_85837_(-8.0, -8.0, 0.0);
                RenderSystem.applyModelViewMatrix();
                guiGraphics.m_280480_(inputSlot.stacks[Mth.m_14143_((float)(PrivateRecipeAlternativesWidget.this.time / 30.0f)) % inputSlot.stacks.length], 0, 0);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }

        @OnlyIn(value=Dist.CLIENT)
        protected class InputSlot {
            public final ItemStack[] stacks;
            public final int y;
            public final int x;

            public InputSlot(int y, int x, ItemStack[] stacks) {
                this.y = y;
                this.x = x;
                this.stacks = stacks;
            }
        }
    }
}

