/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.client.util.RatRecordSoundInstance;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record UpdateRatMusicPacket(int id, RecordItem record) {
    public static UpdateRatMusicPacket decode(FriendlyByteBuf buf) {
        return new UpdateRatMusicPacket(buf.readInt(), (RecordItem)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS));
    }

    public static void encode(UpdateRatMusicPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.id());
        buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)packet.record());
    }

    public static class Handler {
        public static void handle(final UpdateRatMusicPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity;
                    if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.id())) instanceof TamedRat) {
                        TamedRat rat = (TamedRat)entity;
                        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)new RatRecordSoundInstance(rat, packet.record()));
                        Minecraft.m_91087_().f_91065_.m_93055_((Component)packet.record().m_43050_());
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

