/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.items.upgrades.MobFilterUpgradeItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record UpdateMobFilterPacket(ItemStack stack, boolean whitelist, List<String> mobs) {
    public static UpdateMobFilterPacket decode(FriendlyByteBuf buf) {
        return new UpdateMobFilterPacket(buf.m_130267_(), buf.readBoolean(), buf.m_236845_(FriendlyByteBuf::m_130277_));
    }

    public static void encode(UpdateMobFilterPacket packet, FriendlyByteBuf buf) {
        buf.m_130055_(packet.stack());
        buf.writeBoolean(packet.whitelist());
        buf.m_236828_(packet.mobs(), FriendlyByteBuf::m_130070_);
    }

    public static class Handler {
        public static void handle(UpdateMobFilterPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null) {
                    MobFilterUpgradeItem.setWhitelist(packet.stack(), packet.whitelist());
                    MobFilterUpgradeItem.setMobs(packet.stack(), packet.mobs());
                }
            });
        }
    }
}

