/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.client.render.entity.layer.RatHeldItemLayer;
import com.github.alexthe666.rats.registry.RatsLootRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import com.github.alexthe666.rats.server.misc.RatsDateFetcher;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class ChristmasRatUpgradeItem
extends BaseRatUpgradeItem
implements TickRatUpgrade,
HoldsItemUpgrade {
    public ChristmasRatUpgradeItem(Item.Properties properties) {
        super(properties, 2, 3);
    }

    @Override
    public boolean isRatHoldingFood(TamedRat rat) {
        return false;
    }

    @Override
    public void tick(TamedRat rat) {
        if (!rat.m_9236_().m_5776_() && RatsDateFetcher.isStartOfHour() && rat.randomEffectCooldown == 0) {
            rat.randomEffectCooldown = 2000;
            this.tryGiftgiving(rat);
            rat.m_9236_().m_7605_((Entity)rat, (byte)126);
        }
    }

    private void tryGiftgiving(TamedRat rat) {
        ItemStack heldItem = rat.m_21205_();
        if (!rat.m_9236_().m_5776_()) {
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)rat.m_9236_());
            builder.m_287239_(1.0f);
            LootContextParamSet.Builder lootparameterset$builder = new LootContextParamSet.Builder();
            ObjectArrayList result = rat.m_9236_().m_7654_().m_278653_().m_278676_(RatsLootRegistry.CHRISTMAS_GIFTS).m_287195_(builder.m_287235_(lootparameterset$builder.m_81405_()));
            if (RatsDateFetcher.isChristmasDay()) {
                for (int i = 0; i < 5; ++i) {
                    result.addAll(rat.m_9236_().m_7654_().m_278653_().m_278676_(RatsLootRegistry.CHRISTMAS_GIFTS).m_287195_(builder.m_287235_(lootparameterset$builder.m_81405_())));
                }
            }
            if (!result.isEmpty()) {
                for (ItemStack stack : result) {
                    if (heldItem.m_41619_()) {
                        rat.m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_());
                        continue;
                    }
                    if (rat.tryDepositItemInContainers(stack.m_41777_()) || rat.m_9236_().m_5776_()) continue;
                    rat.m_5552_(stack.m_41777_(), 0.25f);
                }
            }
        }
    }

    @Override
    public void renderHeldItem(TamedRat rat, RatModel<?> model, PoseStack stack, MultiBufferSource buffer, int light, float ageInTicks) {
        stack.m_85836_();
        this.translateToHand(model, false, stack);
        stack.m_252781_(Axis.f_252403_.m_252977_(-10.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(1.0f));
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        stack.m_85836_();
        stack.m_252880_(-0.025f, -0.2f, -0.05f);
        stack.m_85841_(0.35f, 0.35f, 0.35f);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)new ResourceLocation("textures/entity/chest/christmas.png")));
        RatHeldItemLayer.CHRISTMAS_CHEST_MODEL.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        stack.m_85849_();
    }
}

