/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.client.render.entity.layer.PiratBoatSailLayer;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.projectile.CheeseCannonball;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;

public class BuccaneerRatUpgradeItem
extends BaseRatUpgradeItem
implements HoldsItemUpgrade,
TickRatUpgrade {
    public BuccaneerRatUpgradeItem(Item.Properties properties) {
        super(properties, 1, 2);
    }

    @Override
    public void renderHeldItem(TamedRat rat, RatModel<?> model, PoseStack stack, MultiBufferSource buffer, int light, float ageInTicks) {
        stack.m_85836_();
        model.body1.translateRotate(stack);
        stack.m_85836_();
        stack.m_252880_(0.0f, -0.925f, 0.2f);
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)PiratBoatSailLayer.TEXTURE_PIRATE_CANNON));
        VertexConsumer fireConsumer = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)PiratBoatSailLayer.TEXTURE_PIRATE_CANNON_FIRE));
        PiratBoatSailLayer.MODEL_PIRAT_CANNON.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (rat.getVisualFlag()) {
            PiratBoatSailLayer.MODEL_PIRAT_CANNON.m_7695_(stack, fireConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        stack.m_85849_();
        stack.m_85849_();
    }

    @Override
    public boolean isFakeHandRender() {
        return true;
    }

    @Override
    public void tick(TamedRat rat) {
        if (rat.getVisualFlag() && rat.visualCooldown == 0) {
            rat.setVisualFlag(false);
        }
        if (rat.rangedAttackCooldown == 0 && rat.m_5448_() != null) {
            rat.rangedAttackCooldown = 60;
            CheeseCannonball cannonball = new CheeseCannonball((EntityType<? extends ThrowableProjectile>)((EntityType)RatlantisEntityRegistry.CHEESE_CANNONBALL.get()), rat.m_9236_(), (LivingEntity)rat);
            double extraY = 0.6 + rat.m_20186_();
            double d0 = rat.m_5448_().m_20186_() + (double)rat.m_5448_().m_20192_() - 1.1;
            double d1 = rat.m_5448_().m_20185_() - rat.m_20185_();
            double d3 = rat.m_5448_().m_20189_() - rat.m_20189_();
            double d2 = d0 - extraY;
            float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            cannonball.m_6034_(rat.m_20185_(), extraY, rat.m_20189_());
            cannonball.m_6686_(d1, d2 + (double)f, d3, 0.75f, 0.4f);
            rat.setVisualFlag(true);
            rat.visualCooldown = 4;
            rat.m_5496_((SoundEvent)RatsSoundRegistry.PIRAT_SHOOT.get(), 3.0f, 2.3f / (rat.m_217043_().m_188501_() * 0.4f + 0.8f));
            if (!rat.m_9236_().m_5776_()) {
                rat.m_9236_().m_7967_((Entity)cannonball);
            }
        }
    }
}

