/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.registry.RatsToolMaterialRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RatlantisToolItem {

    public static class Hoe
    extends HoeItem {
        public Hoe(Item.Properties properties) {
            super(RatsToolMaterialRegistry.RATLANTIS, -7, 0.0f, properties);
        }

        public InteractionResult m_6225_(UseOnContext context) {
            boolean tilledAny = false;
            Level level = context.m_43725_();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Pair pair;
                    BlockPos pos = context.m_8083_().m_7918_(x, 0, z);
                    BlockState toolModifiedState = level.m_8055_(pos).getToolModifiedState(context, ToolActions.HOE_TILL, false);
                    Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)Hoe.m_150858_((BlockState)toolModifiedState));
                    if (pair == null) continue;
                    Predicate predicate = (Predicate)pair.getFirst();
                    Consumer consumer = (Consumer)pair.getSecond();
                    if (!predicate.test(context)) continue;
                    Player player = context.m_43723_();
                    level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (level.m_5776_()) continue;
                    BlockHitResult result = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), context.m_43719_(), pos, false);
                    consumer.accept(new UseOnContext(context.m_43723_(), context.m_43724_(), result));
                    tilledAny = true;
                }
            }
            if (tilledAny && context.m_43723_() != null) {
                context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), user -> user.m_21190_(context.m_43724_()));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, level, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc0")).m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc1")).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static class Shovel
    extends ShovelItem {
        public Shovel(Item.Properties properties) {
            super(RatsToolMaterialRegistry.RATLANTIS, 1.5f, -3.0f, properties);
        }

        public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
            if (Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_13029_).contains((Object)state.m_60734_())) {
                if (!level.m_5776_() && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
                    stack.m_41622_(0, living, user -> user.m_21166_(EquipmentSlot.MAINHAND));
                }
                return true;
            }
            return super.m_6813_(stack, level, state, pos, living);
        }

        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc0")).m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc1")).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static class Axe
    extends AxeItem {
        public Axe(Item.Properties properties) {
            super(RatsToolMaterialRegistry.RATLANTIS, 5.0f, -3.0f, properties);
        }

        public float m_8102_(ItemStack stack, BlockState state) {
            if (Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_13035_).contains((Object)state.m_60734_())) {
                return this.f_40980_ * 1.5f;
            }
            return super.m_8102_(stack, state);
        }

        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc0")).m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc1")).m_130940_(ChatFormatting.GRAY));
        }

        public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
            if (Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_13035_).contains((Object)state.m_60734_())) {
                if (!level.m_5776_() && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
                    stack.m_41622_(0, living, user -> user.m_21166_(EquipmentSlot.MAINHAND));
                }
                return true;
            }
            return super.m_6813_(stack, level, state, pos, living);
        }
    }

    public static class Pickaxe
    extends PickaxeItem {
        public Pickaxe(Item.Properties properties) {
            super(RatsToolMaterialRegistry.RATLANTIS, 1, -2.8f, properties);
        }

        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc0")).m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc1")).m_130940_(ChatFormatting.GRAY));
        }

        public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
            if (Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_13061_).contains((Object)state.m_60734_())) {
                if (!level.m_5776_() && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
                    stack.m_41622_(0, living, user -> user.m_21166_(EquipmentSlot.MAINHAND));
                }
                return true;
            }
            return super.m_6813_(stack, level, state, pos, living);
        }
    }
}

