/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RatPapersItem
extends Item {
    public RatPapersItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return RatPapersItem.isEntityBound(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!RatPapersItem.isEntityBound(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_papers.desc0").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_papers.desc1").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_papers.desc2").m_130940_(ChatFormatting.GRAY));
        if (stack.m_41783_() != null) {
            tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_papers.bound_rat").m_130940_(ChatFormatting.GRAY));
            String ratName = I18n.m_118938_((String)"entity.rats.rat", (Object[])new Object[0]);
            String entity = stack.m_41783_().m_128461_("RatName");
            if (stack.m_41783_().m_128403_("RatUUID")) {
                if (entity.isEmpty()) {
                    tooltip.add((Component)Component.m_237113_((String)(ratName + " (" + stack.m_41783_().m_128342_("RatUUID") + ")")).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237113_((String)entity).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    public static boolean isEntityBound(ItemStack stack) {
        return stack.m_41784_().m_128403_("RatUUID");
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        TamedRat rat;
        CompoundTag nbt = stack.m_41784_();
        if (target instanceof Player) {
            Player transferTo = (Player)target;
            try {
                if (nbt.m_128403_("RatUUID")) {
                    TamedRat rat2;
                    Entity entity;
                    UUID ratUUID = nbt.m_128342_("RatUUID");
                    if (!target.m_9236_().m_5776_() && (entity = target.m_9236_().m_7654_().m_129880_(target.m_9236_().m_46472_()).m_8791_(ratUUID)) instanceof TamedRat && (rat2 = (TamedRat)entity).m_21824_() && rat2.m_21830_((LivingEntity)player)) {
                        rat2.m_21828_(transferTo);
                        stack.m_41774_(1);
                        player.m_9236_().m_5594_(player, player.m_20183_(), (SoundEvent)RatsSoundRegistry.RAT_TRANSFER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
                }
            }
            catch (Exception e) {
                player.m_5661_((Component)Component.m_237113_((String)"Couldnt transfer ownership! Check the log and report this!").m_130940_(ChatFormatting.RED), true);
                RatsMod.LOGGER.error("Couldnt transfer rat ownership to {}!", (Object)transferTo.m_20149_(), (Object)e);
            }
            return InteractionResult.PASS;
        }
        if (target instanceof TamedRat && (rat = (TamedRat)target).m_21830_((LivingEntity)player)) {
            if (rat.m_8077_()) {
                nbt.m_128359_("RatName", rat.m_7770_().getString());
            }
            nbt.m_128362_("RatUUID", rat.m_20148_());
            stack.m_41751_(nbt);
            return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
        }
        return InteractionResult.PASS;
    }
}

