/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.rat;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatsDataSerializerRegistry;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.inventory.RatMenu;
import com.github.alexthe666.rats.server.inventory.container.RatContainer;
import com.github.alexthe666.rats.server.items.RatStaffItem;
import com.github.alexthe666.rats.server.message.OpenRatScreenPacket;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryRat
extends DiggingRat
implements ContainerListener {
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(InventoryRat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<GlobalPos>> RADIUS_CENTER = SynchedEntityData.m_135353_(InventoryRat.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POS = SynchedEntityData.m_135353_(InventoryRat.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private static final EntityDataAccessor<Integer> SEARCH_RADIUS = SynchedEntityData.m_135353_(InventoryRat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<List<GlobalPos>> PATROL_NODES = SynchedEntityData.m_135353_(InventoryRat.class, (EntityDataSerializer)((EntityDataSerializer)RatsDataSerializerRegistry.GLOBAL_POS_LIST.get()));
    private static final EntityDataAccessor<Byte> VISIBILITY_FLAGS = SynchedEntityData.m_135353_(InventoryRat.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private RatContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private boolean inventoryOpen;

    protected InventoryRat(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.createInventory();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COMMAND, (Object)0);
        this.m_20088_().m_135372_(RADIUS_CENTER, Optional.empty());
        this.m_20088_().m_135372_(HOME_POS, Optional.empty());
        this.m_20088_().m_135372_(SEARCH_RADIUS, (Object)RatConfig.defaultRatRadius);
        this.m_20088_().m_135372_(PATROL_NODES, new ArrayList());
        this.m_20088_().m_135372_(VISIBILITY_FLAGS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack itemstack = this.getInventory().m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.m_128365_("Items", (Tag)listtag);
        tag.m_128344_("InvisibleSlots", ((Byte)this.m_20088_().m_135370_(VISIBILITY_FLAGS)).byteValue());
        this.getHomePoint().flatMap(pos -> GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, pos).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0))).ifPresent(tag1 -> tag.m_128365_("HomePos", tag1));
        this.getRadiusCenter().flatMap(pos -> GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, pos).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0))).ifPresent(tag1 -> tag.m_128365_("RadiusPos", tag1));
        tag.m_128405_("SearchRadius", this.getRadius());
        if (!this.getPatrolNodes().isEmpty()) {
            ListTag listTag = new ListTag();
            this.getPatrolNodes().forEach(pos -> GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, pos).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0)).ifPresent(arg_0 -> listTag.add(arg_0)));
            tag.m_128365_("PatrolNodesTag", (Tag)listTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        ListTag listtag = tag.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j >= this.getInventory().m_6643_()) continue;
            this.getInventory().m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        this.m_20088_().m_135381_(VISIBILITY_FLAGS, (Object)tag.m_128445_("InvisibleSlots"));
        if (tag.m_128441_("HomePos")) {
            this.setHomePoint(GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("HomePos")).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0)).orElse(null));
        }
        if (tag.m_128441_("RadiusPos")) {
            this.setRadiusCenter(GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("RadiusPos")).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0)).orElse(null));
        }
        this.setRadius(tag.m_128451_("SearchRadius"));
        if (tag.m_128441_("PatrolNodesTag")) {
            ListTag listTag = tag.m_128437_("PatrolNodesTag", 10);
            for (Tag pos : listTag) {
                GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)pos).resultOrPartial(arg_0 -> ((Logger)RatsMod.LOGGER).error(arg_0)).ifPresent(globalPos -> this.getPatrolNodes().add((GlobalPos)globalPos));
            }
        }
    }

    private void createInventory() {
        SimpleContainer simplecontainer = this.getInventory();
        this.inventory = new RatContainer(this, 6);
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.getInventory().m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.getInventory().m_6836_(j, itemstack.m_41777_());
            }
        }
        this.getInventory().m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.getInventory()));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.getCommand().freeMove && !this.inventoryOpen;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (this.getInventory() != null) {
            if (slot == EquipmentSlot.MAINHAND) {
                return this.getInventory().m_8020_(0);
            }
            if (slot == EquipmentSlot.HEAD) {
                return this.getInventory().m_8020_(1);
            }
            if (slot == EquipmentSlot.OFFHAND) {
                return this.getInventory().m_8020_(2);
            }
            if (slot == EquipmentSlot.CHEST) {
                return this.getInventory().m_8020_(3);
            }
            if (slot == EquipmentSlot.LEGS) {
                return this.getInventory().m_8020_(4);
            }
            return slot == EquipmentSlot.FEET ? this.getInventory().m_8020_(5) : super.m_6844_(slot);
        }
        return super.m_6844_(slot);
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        if (this.getInventory() != null) {
            if (slot == EquipmentSlot.MAINHAND) {
                this.getInventory().m_6836_(0, stack);
            } else if (slot == EquipmentSlot.HEAD) {
                this.getInventory().m_6836_(1, stack);
            } else if (slot == EquipmentSlot.OFFHAND) {
                this.getInventory().m_6836_(2, stack);
            } else if (slot == EquipmentSlot.CHEST) {
                this.getInventory().m_6836_(3, stack);
            } else if (slot == EquipmentSlot.LEGS) {
                this.getInventory().m_6836_(4, stack);
            } else if (slot == EquipmentSlot.FEET) {
                this.getInventory().m_6836_(5, stack);
            } else {
                super.m_8061_(slot, stack);
            }
        } else {
            super.m_8061_(slot, stack);
        }
    }

    public void openGUI(Player player) {
        if (!this.m_9236_().m_5776_()) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.f_36096_ != sp.f_36095_) {
                sp.m_6915_();
            }
            sp.m_9217_();
            RatsNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new OpenRatScreenPacket(sp.f_8940_, this.m_19879_()));
            sp.f_36096_ = new RatMenu(sp.f_8940_, (Container)this.getInventory(), sp.m_150109_());
            sp.m_143399_(sp.f_36096_);
            this.inventoryOpen = true;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)sp, sp.f_36096_));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionHand otherHand;
        ItemStack stack = player.m_21120_(hand);
        InteractionHand interactionHand = otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (!player.m_6144_() && this.m_21830_((LivingEntity)player) && !(stack.m_41720_() instanceof RatStaffItem) && !(player.m_21120_(otherHand).m_41720_() instanceof RatStaffItem)) {
            this.openGUI(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void closeInventory() {
        this.inventoryOpen = false;
    }

    public int getCommandInteger() {
        return (Integer)this.m_20088_().m_135370_(COMMAND);
    }

    public void setCommandInteger(int command) {
        if (!this.m_9236_().m_5776_() && command != this.getCommandInteger()) {
            this.m_21573_().m_26573_();
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            InventoryRat inventoryRat = this;
            if (inventoryRat instanceof TamedRat) {
                TamedRat rat = (TamedRat)inventoryRat;
                rat.crafting = false;
            }
        }
        this.m_20088_().m_135381_(COMMAND, (Object)command);
        this.m_21839_(command == RatCommand.SIT.ordinal());
    }

    public RatCommand getCommand() {
        return RatCommand.values()[Mth.m_14045_((int)this.getCommandInteger(), (int)0, (int)(RatCommand.values().length - 1))];
    }

    public void setCommand(RatCommand command) {
        this.setCommandInteger(command.ordinal());
    }

    public boolean isFollowing() {
        return this.getCommandInteger() == 2;
    }

    public boolean isTargetCommand() {
        return this.getCommandInteger() == 4 || this.getCommandInteger() == 5;
    }

    public boolean shouldHunt() {
        return this.getCommandInteger() == 3 || this.isPatrolCommand();
    }

    public boolean shouldWander() {
        return this.getCommand().allowsWandering;
    }

    public boolean isAttackCommand() {
        return this.getCommand().allowsAttacking;
    }

    public boolean isPatrolCommand() {
        return this.getCommandInteger() == 8;
    }

    public Optional<GlobalPos> getHomePoint() {
        return (Optional)this.m_20088_().m_135370_(HOME_POS);
    }

    public void setHomePoint(@Nullable GlobalPos home) {
        this.m_20088_().m_135381_(HOME_POS, Optional.ofNullable(home));
    }

    public int getRadius() {
        return this.getRadiusCenter().isPresent() ? (Integer)this.m_20088_().m_135370_(SEARCH_RADIUS) : RatConfig.defaultRatRadius;
    }

    public void setRadius(int radius) {
        this.m_20088_().m_135381_(SEARCH_RADIUS, (Object)radius);
    }

    public Optional<GlobalPos> getRadiusCenter() {
        return (Optional)this.m_20088_().m_135370_(RADIUS_CENTER);
    }

    public void setRadiusCenter(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(RADIUS_CENTER, Optional.ofNullable(pos));
    }

    public BlockPos getSearchCenter() {
        if (this.getRadiusCenter().isEmpty()) {
            return this.m_20183_();
        }
        return this.getRadiusCenter().get().m_122646_();
    }

    public List<GlobalPos> getPatrolNodes() {
        return (List)this.m_20088_().m_135370_(PATROL_NODES);
    }

    public void m_5757_(Container container) {
    }

    public boolean isSlotVisible(EquipmentSlot slot) {
        return ((Byte)this.m_20088_().m_135370_(VISIBILITY_FLAGS) & this.getByteValueForSlot(slot)) == 0;
    }

    public void setSlotVisibility(EquipmentSlot slot, boolean visible) {
        if (visible) {
            this.m_20088_().m_135381_(VISIBILITY_FLAGS, (Object)((byte)((Byte)this.m_20088_().m_135370_(VISIBILITY_FLAGS) & ~this.getByteValueForSlot(slot))));
        } else {
            this.m_20088_().m_135381_(VISIBILITY_FLAGS, (Object)((byte)((Byte)this.m_20088_().m_135370_(VISIBILITY_FLAGS) | this.getByteValueForSlot(slot))));
        }
    }

    private int getByteValueForSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.FEET -> 1;
            case EquipmentSlot.LEGS -> 2;
            case EquipmentSlot.CHEST -> 4;
            default -> 0;
        };
    }
}

