/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.rat;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatVariantRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.RatSummoner;
import com.github.alexthe666.rats.server.entity.ai.goal.RatFleePositionGoal;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.RatMoveControl;
import com.github.alexthe666.rats.server.entity.monster.boss.BlackDeath;
import com.github.alexthe666.rats.server.entity.monster.boss.RatKing;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.entity.rat.RatStatus;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatUtils;
import com.github.alexthe666.rats.server.misc.RatVariant;
import com.github.alexthe666.rats.server.misc.RatsDateFetcher;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRat
extends TamableAnimal
implements IAnimatedEntity {
    public static final Animation ANIMATION_EAT = Animation.create((int)10);
    public static final Animation ANIMATION_IDLE_SCRATCH = Animation.create((int)25);
    public static final Animation ANIMATION_IDLE_SNIFF = Animation.create((int)20);
    public static final Animation ANIMATION_DANCE = Animation.create((int)35);
    private static final EntityDataAccessor<Boolean> IS_MALE = SynchedEntityData.m_135353_(AbstractRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(AbstractRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(AbstractRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> COLOR_VARIANT = SynchedEntityData.m_135353_(AbstractRat.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> DEAD_IN_TRAP = SynchedEntityData.m_135353_(AbstractRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> FLEE_POS = SynchedEntityData.m_135353_(AbstractRat.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    public float sitProgress;
    public float deadInTrapProgress;
    public float sleepProgress;
    private int animationTick;
    protected int eatingTicks = 0;
    public int raidCooldown = 1200;
    private Animation currentAnimation;
    private RatStatus status = RatStatus.IDLE;

    protected AbstractRat(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new RatMoveControl(this);
        this.m_21441_(BlockPathTypes.FENCE, RatConfig.ratsClimbOverFences ? 0.0f : -1.0f);
        this.m_21441_(BlockPathTypes.RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    public float m_274421_() {
        return RatConfig.ratsClimbOverFences ? 1.55f : 1.0f;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 10.0f, 0.8, 1.225, entity -> !entity.m_20161_()));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 10.0f, 0.8, 1.225, entity -> !entity.m_20161_()));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Fox.class, 10.0f, 0.8, 1.225));
        this.f_21345_.m_25352_(4, (Goal)new RatFleePositionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.225));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AbstractRat.class, Cat.class, Ocelot.class, Fox.class}));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(4, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public void m_8107_() {
        LivingEntity livingEntity;
        float sitInc;
        super.m_8107_();
        this.setRatStatus(RatStatus.IDLE);
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        if (this.raidCooldown > 0 && !this.hasFleePos()) {
            --this.raidCooldown;
        }
        if (this.isMoving()) {
            this.setRatStatus(RatStatus.MOVING);
        }
        if (!this.m_21525_() && !this.m_9236_().m_5776_() && this.getRatStatus() == RatStatus.IDLE && this.m_21205_().m_41619_() && this.getAnimation() == NO_ANIMATION && this.m_217043_().m_188503_(350) == 0 && this.shouldPlayIdleAnimations()) {
            this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_IDLE_SNIFF : ANIMATION_IDLE_SCRATCH);
        }
        if (this.getAnimation() == ANIMATION_EAT && this.isHoldingFood()) {
            ++this.eatingTicks;
            this.eatItem(this.m_21205_());
            if (this.eatingTicks >= 40) {
                if (!this.m_21205_().m_41619_() && !this.m_9236_().m_5776_()) {
                    this.onItemEaten();
                }
                int healAmount = 1;
                if (this.m_21205_().m_41720_().m_41472_()) {
                    healAmount = Objects.requireNonNull(this.m_21205_().m_41720_().getFoodProperties(this.m_21205_(), (LivingEntity)this)).m_38744_();
                }
                this.m_5634_(healAmount);
                this.eatingTicks = 0;
            }
        }
        if (!this.m_9236_().m_5776_() && this.isEating()) {
            this.setAnimation(ANIMATION_EAT);
            this.setRatStatus(RatStatus.EATING);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        float f = sitInc = this.getAnimation() == ANIMATION_IDLE_SCRATCH || this.getAnimation() == ANIMATION_IDLE_SNIFF ? 5.0f : 1.0f;
        if (this.sleepProgress <= 0.0f) {
            if ((this.isVisuallySitting() || this.isHoldingItemInHands()) && this.sitProgress < 20.0f) {
                this.sitProgress += sitInc;
            } else if (!this.isVisuallySitting() && !this.isHoldingItemInHands() && this.sitProgress > 0.0f) {
                this.sitProgress -= sitInc;
            }
        }
        if (this.isDeadInTrap()) {
            this.sitProgress = 0.0f;
            if (this.deadInTrapProgress < 5.0f) {
                this.deadInTrapProgress += 1.0f;
            }
        }
        if (this.m_9236_().m_8055_(this.m_20183_()).m_204336_(BlockTags.f_13038_) && this.m_21827_()) {
            this.sitProgress = 0.0f;
            this.m_20088_().m_135381_(SLEEPING, (Object)true);
            this.m_6210_();
            if (this.sleepProgress < 20.0f) {
                this.sleepProgress += 1.0f;
            }
        } else {
            this.m_20088_().m_135381_(SLEEPING, (Object)false);
            this.m_6210_();
            if (this.sleepProgress > 0.0f) {
                this.sleepProgress -= 1.0f;
            }
        }
        if (!this.m_9236_().m_5776_() && (livingEntity = this.m_269323_()) instanceof RatSummoner) {
            RatSummoner summoner = (RatSummoner)livingEntity;
            livingEntity = this.m_269323_();
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                if (mob.m_5448_() != null) {
                    this.m_6710_(mob.m_5448_());
                }
                if (summoner.reabsorbRats()) {
                    if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
                        this.m_21573_().m_5624_((Entity)mob, (double)1.225f);
                    }
                    if (this.m_20280_((Entity)mob) < (double)mob.m_20205_()) {
                        this.m_146870_();
                        mob.m_5634_(summoner.reabsorbedRatHealAmount());
                        summoner.setRatsSummoned(summoner.getRatsSummoned() - 1);
                    }
                } else if (summoner.encirclesSummoner() && (this.m_5448_() == null || !this.m_5448_().m_6084_())) {
                    float radius = summoner.getRadius();
                    int maxRatStuff = 360 / Math.max(summoner.getRatsSummoned(), 1);
                    int ratIndex = this.m_19879_() % Math.max(summoner.getRatsSummoned(), 1);
                    float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.f_19797_ * 4.1f);
                    double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + mob.m_20185_();
                    double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + mob.m_20189_();
                    BlockPos runToPos = BlockPos.m_274561_((double)extraX, (double)mob.m_20186_(), (double)extraZ);
                    for (int steps = 0; this.m_9236_().m_8055_(runToPos).m_60804_((BlockGetter)this.m_9236_(), runToPos) && steps < 10; ++steps) {
                        runToPos = runToPos.m_7494_();
                    }
                    this.m_21573_().m_26519_(extraX, (double)runToPos.m_123342_(), extraZ, (double)1.225f);
                }
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_MALE, (Object)false);
        this.m_20088_().m_135372_(SITTING, (Object)false);
        this.m_20088_().m_135372_(SLEEPING, (Object)false);
        this.m_20088_().m_135372_(COLOR_VARIANT, (Object)RatVariantRegistry.RAT_VARIANT_REGISTRY.get().getKey((Object)((RatVariant)RatVariantRegistry.BLUE.get())).toString());
        this.m_20088_().m_135372_(DEAD_IN_TRAP, (Object)false);
        this.m_20088_().m_135372_(FLEE_POS, Optional.empty());
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_EAT, ANIMATION_IDLE_SCRATCH, ANIMATION_IDLE_SNIFF, ANIMATION_DANCE};
    }

    public void m_7822_(byte id) {
        if (id == 82) {
            this.playEffect(0);
        } else if (id == 83) {
            this.playEffect(1);
        } else if (id == 84) {
            this.playEffect(2);
        } else if (id == 101) {
            this.playEffect(3);
        } else if (id == 126) {
            this.playEffect(5);
        } else {
            super.m_7822_(id);
        }
    }

    protected void playEffect(int type) {
        if (type == 3) {
            for (int j = 0; j < 5; ++j) {
                double d6 = (double)j / 5.0;
                float f = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
                float f1 = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
                float f2 = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
                double d3 = this.f_19854_ + (this.m_20185_() - this.f_19854_) * d6 + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d4 = this.f_19855_ + (this.m_20186_() - this.f_19855_) * d6 + this.m_217043_().m_188500_() * (double)this.m_20206_();
                double d5 = this.f_19856_ + (this.m_20189_() - this.f_19856_) * d6 + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, d3, d4, d5, (double)f, (double)f1, (double)f2);
            }
        } else if (type == 2) {
            for (int j = 0; j < 5; ++j) {
                double d6 = (double)j / 5.0;
                float f = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
                float f1 = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
                float f2 = (this.m_217043_().m_188501_() - 0.5f) * 0.2f;
                double d3 = this.f_19854_ + (this.m_20185_() - this.f_19854_) * d6 + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d4 = this.f_19855_ + (this.m_20186_() - this.f_19855_) * d6 + this.m_217043_().m_188500_() * (double)this.m_20206_();
                double d5 = this.f_19856_ + (this.m_20189_() - this.f_19856_) * d6 + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, d3, d4, d5, (double)f, (double)f1, (double)f2);
            }
        } else {
            SimpleParticleType p = ParticleTypes.f_123762_;
            if (type == 1) {
                p = ParticleTypes.f_123750_;
            }
            if (type == 5) {
                p = ParticleTypes.f_123754_;
            }
            for (int i = 0; i < 9; ++i) {
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)p, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
        }
    }

    public boolean isMale() {
        return (Boolean)this.m_20088_().m_135370_(IS_MALE);
    }

    public void setMale(boolean male) {
        this.m_20088_().m_135381_(IS_MALE, (Object)male);
    }

    private RatStatus getRatStatus() {
        return this.status;
    }

    protected void setRatStatus(RatStatus status) {
        if (this.status.canBeOverriden(this)) {
            this.status = status;
        }
    }

    public RatVariant getColorVariant() {
        return RatVariant.getVariant((String)this.m_20088_().m_135370_(COLOR_VARIANT));
    }

    public void setColorVariant(RatVariant variant) {
        this.m_20088_().m_135381_(COLOR_VARIANT, (Object)RatVariant.getVariantId(variant));
    }

    public boolean canMove() {
        return !this.m_6162_() && !this.m_21827_();
    }

    public boolean isEating() {
        return this.isHoldingFood() && (this.m_217043_().m_188503_(20) == 0 || this.eatingTicks > 0) && this.sleepProgress <= 0.0f;
    }

    public void onItemEaten() {
        this.m_21205_().m_41774_(1);
    }

    public boolean isMoving() {
        return Math.abs(this.m_20184_().m_7096_()) >= 0.05 || Math.abs(this.m_20184_().m_7094_()) >= 0.05;
    }

    public boolean isHoldingFood() {
        return !this.m_21205_().m_41619_() && RatUtils.isRatFood(this.m_21205_());
    }

    public boolean shouldPlayIdleAnimations() {
        return !this.m_20159_() && !this.isDeadInTrap() && this.m_6084_() && this.getAnimation() != Rat.ANIMATION_EAT && (Boolean)this.m_20088_().m_135370_(SLEEPING) == false;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean isDeadInTrap() {
        return (Boolean)this.m_20088_().m_135370_(DEAD_IN_TRAP);
    }

    public void setKilledInTrap() {
        this.m_20088_().m_135381_(DEAD_IN_TRAP, (Object)true);
        this.m_6469_(this.m_269291_().m_269318_(), Float.MAX_VALUE);
    }

    public boolean hasFleePos() {
        return ((Optional)this.m_20088_().m_135370_(FLEE_POS)).isPresent();
    }

    @Nullable
    public BlockPos getFleePos() {
        return ((Optional)this.m_20088_().m_135370_(FLEE_POS)).orElse(null);
    }

    public void setFleePos(@Nullable BlockPos pos) {
        this.m_20088_().m_135381_(FLEE_POS, Optional.ofNullable(pos));
    }

    public boolean m_21827_() {
        return (Boolean)this.m_20088_().m_135370_(SITTING);
    }

    public void m_21839_(boolean sit) {
        this.m_20088_().m_135381_(SITTING, (Object)sit);
        this.m_6210_();
    }

    public boolean isVisuallySitting() {
        return this.m_20202_() instanceof Player || this.m_20202_() instanceof RatMountBase || (Boolean)this.m_20088_().m_135370_(SITTING) != false || this.isEating() || this.getAnimation() == ANIMATION_IDLE_SCRATCH || this.getAnimation() == ANIMATION_IDLE_SNIFF;
    }

    public boolean isHoldingItemInHands() {
        return !this.hasFleePos() && this.isEating() && this.sleepProgress <= 0.0f;
    }

    public boolean m_5545_(LevelAccessor accessor, MobSpawnType type) {
        return accessor.m_6106_().m_5470_().m_46207_(RatsMod.SPAWN_RATS) && super.m_5545_(accessor, type);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, type, data, tag);
        this.setColorVariant(RatVariant.getRandomVariant(this.m_217043_(), false));
        this.setMale(this.m_217043_().m_188499_());
        return data;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsMale", this.isMale());
        tag.m_128379_("Sitting", this.m_21827_());
        tag.m_128359_("ColorVariant", RatVariant.getVariantId(this.getColorVariant()));
        tag.m_128405_("RaidCooldown", this.raidCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setMale(tag.m_128471_("IsMale"));
        this.m_21839_(tag.m_128471_("Sitting"));
        if (tag.m_128425_("ColorVariant", 3)) {
            this.setColorVariant(RatUtils.convertOldRatVariant(tag.m_128451_("ColorVariant")));
            RatsMod.LOGGER.debug("Converted Rat variant for Rat {} from {} to {}.", (Object)this.m_20148_(), (Object)tag.m_128451_("ColorVariant"), (Object)RatVariantRegistry.RAT_VARIANT_REGISTRY.get().getKey((Object)RatUtils.convertOldRatVariant(tag.m_128451_("ColorVariant"))).toString());
        } else if (tag.m_128425_("ColorVariant", 8)) {
            this.setColorVariant(RatVariant.getVariant(tag.m_128461_("ColorVariant")));
        }
        this.raidCooldown = tag.m_128451_("RaidCooldown");
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public boolean isDead() {
        return this.f_20890_;
    }

    protected void m_6153_() {
        int maxDeathTime;
        ++this.f_20919_;
        int n = maxDeathTime = this.isDeadInTrap() ? 60 : 20;
        if (this.f_20919_ >= maxDeathTime && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6785_(double dist) {
        return RatConfig.ratsSpawnLikeMonsters;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.sitProgress > 0.0f && this.sleepProgress <= 0.0f ? super.m_6431_(pose, dimensions) : dimensions.f_20378_ * 0.5f;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        LivingEntity livingEntity;
        if (reason.m_146965_() && !this.m_6084_() && (livingEntity = this.m_269323_()) instanceof RatSummoner) {
            RatSummoner summoner = (RatSummoner)livingEntity;
            if (summoner instanceof BlackDeath && !RatConfig.bdConstantRatSpawns) {
                super.m_142687_(reason);
                return;
            }
            if (summoner instanceof RatKing && !RatConfig.ratKingConstantRatSpawns) {
                super.m_142687_(reason);
                return;
            }
            summoner.setRatsSummoned(summoner.getRatsSummoned() - 1);
            this.m_21816_(null);
        }
        super.m_142687_(reason);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if ((double)this.m_21223_() <= (double)this.m_21233_() / 2.0 || this.m_6162_()) {
            return (SoundEvent)RatsSoundRegistry.RAT_IDLE.get();
        }
        if (RatsDateFetcher.isPirateDay() && (this.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatsItemRegistry.PIRAT_HAT.get()) || this.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatlantisItemRegistry.GHOST_PIRAT_HAT.get()))) {
            return (SoundEvent)RatsSoundRegistry.RAT_PIRATE.get();
        }
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.RAT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.RAT_DIE.get();
    }

    protected void eatItem(ItemStack stack) {
        if (!stack.m_41619_()) {
            TamedRat rat;
            AbstractRat abstractRat;
            if (stack.m_41780_() == UseAnim.DRINK) {
                this.m_146850_(GameEvent.f_223704_);
                this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_DRINK.get(), 0.5f, this.m_9236_().m_213780_().m_188501_() * 0.1f + 0.9f);
            }
            if (RatUtils.isRatFood(stack) || (abstractRat = this) instanceof TamedRat && RatUpgradeUtils.hasUpgrade(rat = (TamedRat)abstractRat, (Item)RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING.get())) {
                for (int i = 0; i < 3; ++i) {
                    Vec3 vec3d = new Vec3(((double)this.m_217043_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vec3d = vec3d.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                    vec3d = vec3d.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    double d0 = (double)(-this.m_217043_().m_188501_()) * 0.6 - 0.3;
                    Vec3 vec3d1 = new Vec3(((double)this.m_217043_().m_188501_() - 0.5) * 0.3, d0, 0.1);
                    vec3d1 = vec3d1.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                    vec3d1 = vec3d1.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    vec3d1 = vec3d1.m_82520_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec3d1.m_7096_(), vec3d1.m_7098_(), vec3d1.m_7094_(), vec3d.m_7096_(), vec3d.m_7098_() + 0.05, vec3d.m_7094_());
                }
                this.m_146850_(GameEvent.f_157806_);
                this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_EAT.get(), 0.25f + 0.25f * (float)this.m_217043_().m_188503_(2), (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.3f);
            }
        }
    }

    protected static boolean isValidLightLevel(LevelAccessor accessor, RandomSource random, BlockPos pos) {
        if (accessor.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        int i = accessor.m_6106_().m_6534_() ? accessor.m_46849_(pos, 10) : accessor.m_46803_(pos);
        return i <= random.m_188503_(8);
    }

    protected ListTag makeDoubleList(double ... pNumbers) {
        ListTag listtag = new ListTag();
        for (double d0 : pNumbers) {
            listtag.add((Object)DoubleTag.m_128500_((double)d0));
        }
        return listtag;
    }

    public BlockPos getLightPosition() {
        BlockPos pos = this.m_20183_();
        if (!this.m_9236_().m_8055_(pos).m_60815_()) {
            return pos.m_7494_();
        }
        return pos;
    }

    protected void m_20076_() {
    }
}

