/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.mount;

import com.github.alexthe666.rats.server.entity.AdjustsRatTail;
import com.github.alexthe666.rats.server.entity.RatMount;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class RatMountBase
extends PathfinderMob
implements RatMount,
AdjustsRatTail {
    protected double riderY;
    protected double riderXZ;
    private int checkCooldown;

    protected RatMountBase(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_21573_().m_7008_(true);
        this.riderY = 1.1;
        this.riderXZ = 0.0;
        this.checkCooldown = 20;
    }

    protected boolean m_8091_() {
        return true;
    }

    public boolean m_7301_(MobEffectInstance instance) {
        return this.getRat() != null ? this.getRat().m_7301_(instance) : super.m_7301_(instance);
    }

    public boolean m_142038_() {
        return super.m_142038_() || this.getRat() != null && this.getRat().m_142038_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        TamedRat rat = this.getRat();
        return rat != null ? rat.m_6071_(player, hand) : InteractionResult.PASS;
    }

    public LivingEntity m_6688_() {
        return this.getRat();
    }

    @Nullable
    public TamedRat getRat() {
        Entity entity = this.m_146895_();
        if (entity instanceof TamedRat) {
            TamedRat rat = (TamedRat)entity;
            return rat;
        }
        return null;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        TamedRat rat = this.getRat();
        if (rat != null) {
            return rat.m_6673_(source);
        }
        return super.m_6673_(source);
    }

    public double m_6048_() {
        return this.riderY;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (this.m_20363_(passenger)) {
            float radius = (float)this.riderXZ;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double extraY = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            callback.m_20372_(passenger, this.m_20185_() + extraX, extraY, this.m_20189_() + extraZ);
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.f_20883_ = this.m_146908_();
                living.m_5616_(this.m_146908_());
                living.m_146926_(this.m_146909_());
                living.m_146922_(this.m_146908_());
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        TamedRat rat = this.getRat();
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        } else if (rat != null) {
            this.m_6710_(rat.m_5448_());
            rat.m_21563_().m_24946_(this.m_21563_().m_24969_(), this.m_21563_().m_24970_(), this.m_21563_().m_24971_());
            rat.m_146922_(this.m_146908_());
            rat.f_19859_ = this.m_146908_();
            rat.m_5616_(this.m_146908_());
            rat.f_20886_ = this.m_146908_();
        } else {
            this.m_146870_();
        }
    }

    public boolean m_142066_() {
        if (this.getRat() != null) {
            return this.getRat().m_142066_();
        }
        return super.m_142066_();
    }

    protected void m_6153_() {
        Vec3 vec3d = this.m_20184_();
        TamedRat rat = this.getRat();
        this.m_20256_(vec3d.m_82542_(1.0, 0.6, 1.0));
        this.f_21363_ = 20;
        ++this.f_20919_;
        if (this.f_20919_ >= 5 && !this.m_9236_().m_5776_()) {
            if (rat != null) {
                rat.setMountCooldown(1000);
                rat.m_8127_();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        TamedRat rat = this.getRat();
        if (reason.m_146965_() && !this.m_9236_().m_5776_() && rat != null) {
            rat.m_8127_();
        }
        super.m_142687_(reason);
    }

    public boolean m_7307_(Entity entity) {
        return super.m_7307_(entity) || this.getRat() != null && this.getRat().m_7307_(entity);
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getRat() != null ? this.getRat().getPickedResult(target) : super.getPickedResult(target);
    }
}

