/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.mount;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RatGolemMount
extends RatMountBase {
    private int attackTimer;

    public RatGolemMount(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.riderY = 1.95f;
        this.riderXZ = -0.1f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.m_20184_().m_165924_() > 2.500000277905201E-7 && this.m_217043_().m_188503_(5) == 0) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockState blockstate = this.m_9236_().m_8055_(new BlockPos(i, j, k));
            if (!blockstate.m_60795_()) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), this.m_20185_() + ((double)this.m_217043_().m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20191_().f_82289_ + 0.1, this.m_20189_() + ((double)this.m_217043_().m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.m_217043_().m_188501_() - 0.5), 0.5, ((double)this.m_217043_().m_188501_() - 0.5) * 4.0);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Cracks irongolementity$cracks = this.getCracks();
        boolean flag = super.m_6469_(source, amount);
        if (flag && this.getCracks() != irongolementity$cracks) {
            this.m_5496_(SoundEvents.f_12058_, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_(Items.f_42416_)) {
            return super.m_6071_(player, hand);
        }
        float f = this.m_21223_();
        this.m_5634_(25.0f);
        if (this.m_21223_() == f) {
            return super.m_6071_(player, hand);
        }
        float f1 = 1.0f + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f;
        this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public Cracks getCracks() {
        return Cracks.byFraction(this.m_21223_() / this.m_21233_());
    }

    public boolean m_7327_(Entity entity) {
        this.attackTimer = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(7 + this.m_217043_().m_188503_(15)));
        if (flag) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            this.m_19970_((LivingEntity)this, entity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public Item getUpgradeItem() {
        return (Item)RatsItemRegistry.RAT_UPGRADE_GOLEM_MOUNT.get();
    }

    @Override
    public void adjustRatTailRotation(AbstractRat rat, AdvancedModelBox upperTail, AdvancedModelBox lowerTail) {
        this.progressRotation(upperTail, rat.sitProgress, -0.5f, 0.0f, 0.0f, 20.0f);
    }

    public static enum Cracks {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Cracks> BY_DAMAGE;
        private final float fraction;

        private Cracks(float fraction) {
            this.fraction = fraction;
        }

        public static Cracks byFraction(float fraction) {
            for (Cracks cracks : BY_DAMAGE) {
                if (!(fraction < cracks.fraction)) continue;
                return cracks;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Cracks.values()).sorted(Comparator.comparingDouble(cracks -> cracks.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

