/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster.boss;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.RatSummoner;
import com.github.alexthe666.rats.server.entity.projectile.RatShot;
import com.github.alexthe666.rats.server.misc.RatVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class RatKing
extends Monster
implements RatSummoner {
    public static final int RAT_COUNT = 15;
    public static final float RAT_ANGLE = 24.0f;
    private static final EntityDataAccessor<String> RAT_COLORS = SynchedEntityData.m_135353_(RatKing.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> SUMMONED_RATS = SynchedEntityData.m_135353_(RatKing.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public RatKing(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 40;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(RAT_COLORS, (Object)"000000000000000");
        this.m_20088_().m_135372_(SUMMONED_RATS, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.75);
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().m_5776_() && target != null & this.f_19797_ % 15 == 0 && this.getRatsSummoned() < RatConfig.ratKingMaxRatSpawns) {
            RatShot shot = new RatShot((EntityType<? extends ThrowableProjectile>)((EntityType)RatsEntityRegistry.RAT_SHOT.get()), this.m_9236_(), (LivingEntity)this);
            shot.setColorVariant(RatVariant.getRandomVariant(this.m_217043_(), false));
            double extraX = this.m_20185_();
            double extraZ = this.m_20189_();
            double extraY = 0.2 + this.m_20186_();
            double d0 = target.m_20188_() - (double)1.2f;
            double d1 = target.m_20185_() - extraX;
            double d3 = target.m_20189_() - extraZ;
            double d2 = d0 - extraY;
            float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 1.0f;
            float velocity = Math.min(Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.06f, 1.4f);
            shot.m_6034_(extraX, extraY, extraZ);
            shot.m_6686_(d1, d2 + (double)f, d3, velocity, 0.0f);
            this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_KING_SHOOT.get(), 3.0f, 2.3f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)shot);
            }
        }
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            for (int i = 0; i < 3 + this.m_217043_().m_188503_(3); ++i) {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            }
        }
    }

    public int m_8100_() {
        return 60;
    }

    protected void m_6677_(DamageSource source) {
        SoundEvent soundevent = this.m_7975_(source);
        if (soundevent != null) {
            for (int i = 0; i < 3 + this.m_217043_().m_188503_(3); ++i) {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            }
        }
    }

    public void m_6667_(DamageSource source) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (!this.m_213877_() && !this.f_20890_) {
            Entity entity = source.m_7639_();
            LivingEntity livingentity = this.m_21232_();
            if (this.f_20897_ >= 0 && livingentity != null) {
                livingentity.m_5993_((Entity)this, this.f_20897_, source);
            }
            this.f_20890_ = true;
            this.m_21231_().m_19296_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (entity == null || entity.m_214076_(server, (LivingEntity)this)) {
                    this.m_146850_(GameEvent.f_223707_);
                    this.m_21268_(livingentity);
                }
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
            this.m_20124_(Pose.DYING);
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 100 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (this.m_21225_() != null) {
                this.m_6668_(this.m_21225_());
            } else {
                this.m_6668_(this.m_269291_().m_269264_());
            }
        }
    }

    @Nullable
    public DamageSource m_21225_() {
        if (!this.m_21224_() && this.m_9236_().m_46467_() - this.f_20930_ > 40L) {
            this.f_20958_ = null;
        }
        return this.f_20958_;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.RAT_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.RAT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.RAT_DIE.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        for (int i = 0; i < 15; ++i) {
            int color = this.m_217043_().m_188503_(4);
            this.setRatColors(i, color);
        }
        return spawnData;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("RatColors", this.getRatColorsString());
        compound.m_128405_("RatsSummoned", this.getRatsSummoned());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRatsSummoned(compound.m_128451_("RatsSummoned"));
        this.setRatColorsString(compound.m_128461_("RatColors"));
    }

    private void setRatColorsString(String str) {
        this.m_20088_().m_135381_(RAT_COLORS, (Object)str);
    }

    private String getRatColorsString() {
        return (String)this.m_20088_().m_135370_(RAT_COLORS);
    }

    public void setRatColors(int index, int color) {
        String ratColors = this.getRatColorsString();
        if (ratColors.length() < 14) {
            ratColors = "000000000000000";
        }
        String before = ratColors.substring(0, index);
        String after = ratColors.substring(index, 14);
        String newStr = before + color + after;
        this.setRatColorsString(newStr);
    }

    public int getRatColors(int index) {
        String ratColors = this.getRatColorsString();
        if (ratColors.length() < 14) {
            ratColors = "000000000000000";
        }
        char c = ratColors.charAt(index);
        return Integer.parseInt(String.valueOf(c));
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    @Override
    public boolean encirclesSummoner() {
        return true;
    }

    @Override
    public boolean reabsorbRats() {
        return RatConfig.ratKingReabsorbsRats && this.getRatsSummoned() > 5;
    }

    @Override
    public float reabsorbedRatHealAmount() {
        return (float)RatConfig.ratKingReabsorbHealRate;
    }

    @Override
    public int getRatsSummoned() {
        return (Integer)this.m_20088_().m_135370_(SUMMONED_RATS);
    }

    @Override
    public void setRatsSummoned(int count) {
        this.m_20088_().m_135381_(SUMMONED_RATS, (Object)count);
    }

    @Override
    public float getRadius() {
        return 3.0f;
    }

    public BlockPos getLightPosition() {
        BlockPos pos = this.m_20183_();
        if (!this.m_9236_().m_8055_(pos).m_60815_()) {
            return pos.m_7494_();
        }
        return pos;
    }
}

