/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster.boss;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisEntityTags;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.misc.LaserPortal;
import com.github.alexthe666.rats.server.entity.projectile.ThrownBlock;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.SyncThrownBlockPacket;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class NeoRatlantean
extends Monster {
    private static final Predicate<LivingEntity> NOT_RATLANTEAN = entity -> entity.m_6084_() && !entity.m_6095_().m_204039_(RatlantisEntityTags.RATLANTEAN);
    private static final EntityDataAccessor<Integer> COLOR_VARIANT = SynchedEntityData.m_135353_(NeoRatlantean.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private int attackSelection = 0;
    private int summonCooldown = 0;
    private int humTicks = 0;

    public NeoRatlantean(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.m_21153_(this.m_21233_());
        this.m_21573_().m_7008_(true);
        this.f_21364_ = 80;
        this.f_21342_ = new RatlanteanMoveControl(this);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19797_ % 100 == 0) {
            this.m_5634_(1.0f);
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_20236_(Pose pose) {
        return 0.9f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR_VARIANT, (Object)0);
    }

    public int getColorVariant() {
        return (Integer)this.m_20088_().m_135370_(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.m_20088_().m_135381_(COLOR_VARIANT, (Object)color);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ColorVariant", this.getColorVariant());
        compound.m_128405_("AttackSelection", this.attackSelection);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColorVariant(compound.m_128451_("ColorVariant"));
        this.attackSelection = compound.m_128451_("AttackSelection");
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, type, data, tag);
        this.setColorVariant(this.m_217043_().m_188503_(4));
        return data;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.LIGHTNING.get(), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_()) - (double)this.m_20205_() / 2.0, this.m_20186_() + (double)this.m_20192_() + (double)(this.m_217043_().m_188501_() * 0.35f), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_()) - (double)this.m_20205_() / 2.0, 0.0, 0.0, 0.0);
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.humTicks % 80 == 0) {
            this.m_5496_((SoundEvent)RatsSoundRegistry.NEORATLANTEAN_LOOP.get(), 1.0f, 1.0f);
        }
        ++this.humTicks;
        if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
            int bounds;
            LivingEntity entity = this.m_5448_();
            if (RatConfig.neoratlanteanSummonLaserPortals && this.attackSelection == 0 && this.summonCooldown == 0) {
                this.summonCooldown = RatConfig.neoratlanteanLaserAttackCooldown;
                bounds = 5;
                for (int i = 0; i < this.m_217043_().m_188503_(2) + 2; ++i) {
                    LaserPortal laserPortal = new LaserPortal((EntityType<? extends Entity>)((EntityType)RatlantisEntityRegistry.LASER_PORTAL.get()), this.m_9236_(), entity.m_20185_() + (double)this.m_217043_().m_188503_(bounds * 2) - (double)bounds, this.m_20186_() + 2.0, entity.m_20189_() + (double)this.m_217043_().m_188503_(bounds * 2) - (double)bounds, (LivingEntity)this);
                    this.m_9236_().m_7967_((Entity)laserPortal);
                }
                this.resetAttacks();
            }
            if (RatConfig.neoratlanteanSummonFakeLightning && this.attackSelection == 1 && this.summonCooldown == 0) {
                bounds = 20;
                if (!this.m_9236_().m_5776_()) {
                    LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                    bolt.m_20219_(entity.m_20182_());
                    bolt.m_20874_(true);
                    this.m_9236_().m_7967_((Entity)bolt);
                    for (int i = 0; i < this.m_217043_().m_188503_(3) + 2; ++i) {
                        LightningBolt boltAgain = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                        boltAgain.m_20219_(new Vec3(entity.m_20185_() + (double)this.m_217043_().m_188503_(bounds * 2) - (double)bounds, entity.m_20186_(), entity.m_20189_() + (double)this.m_217043_().m_188503_(bounds * 2) - (double)bounds));
                        boltAgain.m_20874_(true);
                        this.m_9236_().m_7967_((Entity)boltAgain);
                    }
                }
                this.summonCooldown = RatConfig.neoratlanteanLightningAttackCooldown;
                this.resetAttacks();
            }
            if (RatConfig.neoratlanteanThrowBlocks && this.attackSelection == 2 && this.summonCooldown == 0) {
                int searchRange = 10;
                BlockPos ourPos = this.m_20183_();
                ArrayList<BlockPos> listOfAll = new ArrayList<BlockPos>();
                for (BlockPos pos : BlockPos.m_121990_((BlockPos)ourPos.m_7918_(-searchRange, -searchRange, -searchRange), (BlockPos)ourPos.m_7918_(searchRange, searchRange, searchRange)).map(BlockPos::m_7949_).toList()) {
                    BlockState state = this.m_9236_().m_8055_(pos);
                    if (this.m_9236_().m_46859_(pos) || !this.canPickupBlock(this.m_9236_(), state, pos) || !this.m_9236_().m_46859_(pos.m_7494_())) continue;
                    listOfAll.add(pos);
                }
                if (listOfAll.size() > 0) {
                    BlockPos pos = (BlockPos)listOfAll.get(this.m_217043_().m_188503_(listOfAll.size()));
                    ThrownBlock thrownBlock = new ThrownBlock((EntityType<? extends Entity>)((EntityType)RatsEntityRegistry.THROWN_BLOCK.get()), this.m_9236_(), this.m_9236_().m_8055_(pos), (LivingEntity)this);
                    thrownBlock.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                    if (!this.m_9236_().m_5776_()) {
                        this.m_9236_().m_7967_((Entity)thrownBlock);
                    }
                    RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncThrownBlockPacket(thrownBlock.m_19879_(), pos.m_121878_()));
                    this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                    this.summonCooldown = RatConfig.neoratlanteanBlockAttackCooldown;
                }
                this.resetAttacks();
            }
            if (RatConfig.neoratlanteanAddHarmfulEffects && this.attackSelection == 3 && this.summonCooldown == 0) {
                this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200));
                this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200));
                this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200));
                this.summonCooldown = RatConfig.neoratlanteanEffectAttackCooldown;
                this.resetAttacks();
            }
        }
    }

    public void resetAttacks() {
        this.attackSelection = this.m_217043_().m_188503_(4);
    }

    public boolean canPickupBlock(Level level, BlockState state, BlockPos pos) {
        return !state.m_204336_(BlockTags.f_13070_) && state.m_60804_((BlockGetter)level, pos) && state.m_60800_((BlockGetter)level, pos) >= 0.0f && state.m_60800_((BlockGetter)level, pos) < 100.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowTargetGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomlyMoveGoal());
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, false, false, NOT_RATLANTEAN));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.NEORATLANTEAN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)RatsSoundRegistry.NEORATLANTEAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.NEORATLANTEAN_DIE.get();
    }

    public int m_8100_() {
        return 10;
    }

    class RatlanteanMoveControl
    extends MoveControl {
        public RatlanteanMoveControl(NeoRatlantean ratlantean) {
            super((Mob)ratlantean);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.m_25000_() - NeoRatlantean.this.m_20185_(), this.m_25001_() - NeoRatlantean.this.m_20186_(), this.m_25002_() - NeoRatlantean.this.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < NeoRatlantean.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    NeoRatlantean.this.m_20256_(NeoRatlantean.this.m_20184_().m_82490_(0.5));
                } else {
                    NeoRatlantean.this.m_20256_(NeoRatlantean.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (NeoRatlantean.this.m_5448_() == null) {
                        Vec3 vec31 = NeoRatlantean.this.m_20184_();
                        NeoRatlantean.this.m_146922_(-((float)Mth.m_14136_((double)vec31.m_7096_(), (double)vec31.m_7094_())) * 57.295776f);
                    } else {
                        double d2 = NeoRatlantean.this.m_5448_().m_20185_() - NeoRatlantean.this.m_20185_();
                        double d1 = NeoRatlantean.this.m_5448_().m_20189_() - NeoRatlantean.this.m_20189_();
                        NeoRatlantean.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                    }
                    NeoRatlantean.this.f_20883_ = NeoRatlantean.this.m_146908_();
                }
            }
        }
    }

    public class FollowTargetGoal
    extends Goal {
        private final NeoRatlantean parentEntity;
        private double followDist;

        public FollowTargetGoal(NeoRatlantean ratlantean) {
            this.parentEntity = ratlantean;
        }

        public boolean m_8036_() {
            this.followDist = NeoRatlantean.this.m_20191_().m_82309_();
            LivingEntity living = this.parentEntity.m_5448_();
            double maxFollow = this.followDist * 5.0;
            return living != null && ((double)living.m_20270_((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.m_142582_((Entity)living));
        }

        public void m_8037_() {
            LivingEntity living = this.parentEntity.m_5448_();
            double maxFollow = this.followDist * 5.0;
            if (living != null && ((double)living.m_20270_((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.m_142582_((Entity)living))) {
                NeoRatlantean.this.m_21566_().m_6849_(living.m_20185_() + (double)NeoRatlantean.this.m_217043_().m_188503_(3) - 6.0, living.m_20186_() + 3.0, living.m_20189_() + (double)NeoRatlantean.this.m_217043_().m_188503_(3) - 6.0, 1.0);
            }
        }
    }

    public class RandomlyMoveGoal
    extends Goal {
        public RandomlyMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !NeoRatlantean.this.m_21566_().m_24995_() && NeoRatlantean.this.m_217043_().m_188503_(RandomlyMoveGoal.m_186073_((int)5)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = NeoRatlantean.this.m_20183_();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(NeoRatlantean.this.m_217043_().m_188503_(5) - 8, NeoRatlantean.this.m_217043_().m_188503_(4) - 6, NeoRatlantean.this.m_217043_().m_188503_(5) - 8);
                if (!NeoRatlantean.this.m_9236_().m_46859_(blockpos1)) continue;
                NeoRatlantean.this.m_21566_().m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 1.0);
                if (NeoRatlantean.this.m_5448_() != null) break;
                NeoRatlantean.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

