/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisBlockTags;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.RatbotStrifeGoal;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.LaserBeam;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class RatlanteanRatbot
extends Monster
implements IAnimatedEntity {
    public static final Animation ANIMATION_SHOOT = Animation.create((int)15);
    private int animationTick;
    private Animation currentAnimation;
    public int walkTick;
    public int prevWalkTick;
    private int rangedAttackCooldownLaser = 0;

    public RatlanteanRatbot(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RatbotStrifeGoal(this, 1.0, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{RatlanteanRatbot.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22284_, 7.0);
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SHOOT);
        }
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevWalkTick = this.walkTick;
        if (this.rangedAttackCooldownLaser == 0 && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
            this.rangedAttackCooldownLaser = 40;
            float radius = 1.1f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + this.m_20185_();
            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + this.m_20189_();
            double extraY = 0.4 + this.m_20186_();
            double targetRelativeX = this.m_5448_().m_20185_() - extraX;
            double targetRelativeY = this.m_5448_().m_20186_() + (double)(this.m_5448_().m_20206_() / 2.0f) - extraY;
            double targetRelativeZ = this.m_5448_().m_20189_() - extraZ;
            this.m_5496_((SoundEvent)RatsSoundRegistry.LASER.get(), 1.0f, 0.75f + this.f_19796_.m_188501_() * 0.5f);
            LaserBeam beam = new LaserBeam((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.LASER_BEAM.get()), this.m_9236_(), (LivingEntity)this);
            beam.setRGB(1.0f, 0.0f, 0.0f);
            beam.setBaseDamage(2.0);
            beam.m_6034_(extraX, extraY, extraZ);
            beam.m_6686_(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.4f);
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)beam);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.f_267362_.m_267731_() > 0.1f) {
            ++this.walkTick;
        }
        if (this.rangedAttackCooldownLaser > 0) {
            --this.rangedAttackCooldownLaser;
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SHOOT};
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.RATLANTEAN_RATBOT_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)RatsSoundRegistry.RATBOT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.RATBOT_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    public static boolean checkBotSpawnRule(EntityType<? extends Mob> entityType, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return rand.m_188503_(8) == 0 && RatlanteanRatbot.canSpawnAtPos(world, pos) && Mob.m_217057_(entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand);
    }

    private static boolean canSpawnAtPos(LevelAccessor world, BlockPos pos) {
        return !world.m_8055_(pos.m_7495_()).m_204336_(RatlantisBlockTags.PIRAT_ONLY_BLOCKS);
    }
}

