/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.data.tags.RatsEntityTags;
import com.github.alexthe666.rats.server.entity.monster.FeralRatlantean;
import com.github.alexthe666.rats.server.entity.monster.boss.BlackDeath;
import com.github.alexthe666.rats.server.events.ForgeEvents;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlagueBeast
extends FeralRatlantean {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(PlagueBeast.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public PlagueBeast(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        double d0 = 0.0;
        double d1 = this.m_217043_().m_188583_() * 0.05 + 0.5;
        double d2 = 0.0;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        if (this.getOwnerId() != null && this.getOwner() != null && (livingEntity = this.getOwner()) instanceof BlackDeath) {
            BlackDeath death = (BlackDeath)livingEntity;
            if (death.m_5448_() != null && death.m_5448_().m_6084_()) {
                this.m_6710_(death.m_5448_());
            } else {
                float radius = 8.0f - (float)Math.sin((double)death.f_19797_ * 0.4) * 0.5f;
                int maxRatStuff = 360 / Math.max(death.getBeastsSummoned(), 1);
                int ratIndex = this.m_19879_() % Math.max(death.getBeastsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.f_19797_ * 4.1f);
                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + death.m_20185_();
                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + death.m_20189_();
                BlockPos runToPos = BlockPos.m_274561_((double)extraX, (double)death.m_20186_(), (double)extraZ);
                for (int steps = 0; this.m_9236_().m_8055_(runToPos).m_60804_((BlockGetter)this.m_9236_(), runToPos) && steps < 10; ++steps) {
                    runToPos = runToPos.m_7494_();
                }
                this.m_21573_().m_26519_(extraX, (double)runToPos.m_123342_(), extraZ, 1.0);
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        LivingEntity livingEntity;
        if (reason.m_146965_() && this.m_6084_() && this.getOwnerId() != null && this.getOwner() != null && (livingEntity = this.getOwner()) instanceof BlackDeath) {
            BlackDeath death = (BlackDeath)livingEntity;
            if (RatConfig.bdConstantBeastSpawns) {
                death.setBeastsSummoned(death.getBeastsSummoned() - 1);
            }
        }
        super.m_142687_(reason);
    }

    @Override
    public void doExtraEffect(LivingEntity target) {
        ForgeEvents.maybeAddAndSyncPlague(null, target, 1200, 0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Override
    public boolean hasToga() {
        return false;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() == null) {
            compound.m_128359_("OwnerUUID", "");
        } else {
            compound.m_128359_("OwnerUUID", this.getOwnerId().toString());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.m_20088_().m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.m_20088_().m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            Entity entity;
            Player player;
            UUID uuid = this.getOwnerId();
            Player player2 = player = uuid == null ? null : this.m_9236_().m_46003_(uuid);
            if (player != null) {
                return player;
            }
            if (!this.m_9236_().m_5776_() && (entity = this.m_9236_().m_7654_().m_129880_(this.m_9236_().m_46472_()).m_8791_(uuid)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public boolean m_7307_(Entity entity) {
        return super.m_7307_(entity) || entity.m_6095_().m_204039_(RatsEntityTags.PLAGUE_LEGION);
    }
}

