/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.RatSummoner;
import com.github.alexthe666.rats.server.entity.ai.goal.PiperStrifeGoal;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class PiedPiper
extends Raider
implements RatSummoner {
    private static final EntityDataAccessor<Integer> RAT_COUNT = SynchedEntityData.m_135353_(PiedPiper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int ratCooldown = 0;
    private int fluteTicks = 0;

    public PiedPiper(EntityType<? extends Raider> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(RAT_COUNT, (Object)0);
    }

    public void m_7895_(int wave, boolean alwaysFalseIdk) {
    }

    public boolean m_7490_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new PiperStrifeGoal(this, 1.0, 15.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Rat.class, Raider.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean m_5545_(LevelAccessor accessor, MobSpawnType type) {
        if (!accessor.m_6106_().m_5470_().m_46207_(RatsMod.SPAWN_PIPERS)) {
            return false;
        }
        if (type == MobSpawnType.EVENT || type == MobSpawnType.SPAWNER) {
            return super.m_5545_(accessor, type);
        }
        int spawnRoll = RatConfig.piperSpawnDecrease;
        if (spawnRoll == 0 || accessor.m_213780_().m_188503_(spawnRoll) == 0) {
            return super.m_5545_(accessor, type);
        }
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        double dist = 20.0;
        if (reason.m_146965_()) {
            for (Rat rat : this.m_9236_().m_45976_(Rat.class, new AABB(this.m_20185_() - dist, this.m_20186_() - dist, this.m_20189_() - dist, this.m_20185_() + dist, this.m_20186_() + dist, this.m_20189_() + dist))) {
                if (!rat.m_21830_((LivingEntity)this)) continue;
                rat.m_7105_(false);
                rat.m_21816_(null);
                rat.setFleePos(rat.m_20183_());
                rat.m_6710_(null);
                rat.m_6703_(null);
            }
        }
        super.m_142687_(reason);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("RatsSummoned", this.getRatsSummoned());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRatsSummoned(compound.m_128451_("RatsSummoned"));
    }

    @Override
    public boolean encirclesSummoner() {
        return false;
    }

    @Override
    public boolean reabsorbRats() {
        return false;
    }

    @Override
    public float reabsorbedRatHealAmount() {
        return 0.0f;
    }

    @Override
    public int getRatsSummoned() {
        return (Integer)this.m_20088_().m_135370_(RAT_COUNT);
    }

    @Override
    public void setRatsSummoned(int count) {
        this.m_20088_().m_135381_(RAT_COUNT, (Object)count);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.m_213945_(level.m_213780_(), difficulty);
        this.m_213946_(level.m_213780_(), difficulty);
        return spawnData;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)RatsItemRegistry.RAT_FLUTE.get()));
    }

    public void summonRat() {
        if (!this.m_9236_().m_5776_() && this.getRatsSummoned() < 6 && this.ratCooldown == 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)82);
            Rat rat = new Rat((EntityType<? extends Rat>)((EntityType)RatsEntityRegistry.RAT.get()), this.m_9236_());
            ForgeEventFactory.onFinalizeSpawn((Mob)rat, (ServerLevelAccessor)((ServerLevel)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
            rat.m_20359_((Entity)this);
            this.m_9236_().m_7967_((Entity)rat);
            rat.setPlagued(false);
            rat.m_7105_(false);
            rat.m_21816_(this.m_20148_());
            if (this.m_5448_() != null) {
                rat.m_6710_(this.m_5448_());
            }
            this.setRatsSummoned(this.getRatsSummoned() + 1);
            this.m_5496_(RatsSoundRegistry.getFluteSound(), 0.5f, 1.0f);
            this.ratCooldown = 150;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21525_() && this.m_21055_((Item)RatsItemRegistry.RAT_FLUTE.get())) {
            if (this.ratCooldown > 0) {
                --this.ratCooldown;
            }
            if (this.fluteTicks % 157 == 0) {
                this.m_5496_((SoundEvent)RatsSoundRegistry.PIPER_LOOP.get(), 0.5f, 1.0f);
            }
            ++this.fluteTicks;
            if (this.fluteTicks % 10 == 0) {
                this.m_9236_().m_7605_((Entity)this, (byte)83);
            }
            if (this.getRatsSummoned() < 6 && this.ratCooldown == 0 && this.f_19797_ > 20) {
                this.summonRat();
            }
        }
    }

    public static boolean canPiperSpawnInLight(LevelAccessor level, BlockPos pos, RandomSource randomIn) {
        return level.m_46791_() != Difficulty.PEACEFUL && PiedPiper.m_219009_((ServerLevelAccessor)((ServerLevelAccessor)level), (BlockPos)pos, (RandomSource)randomIn);
    }

    public static boolean checkPiperSpawnRules(EntityType<? extends Mob> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.m_7495_();
        boolean light = PiedPiper.canPiperSpawnInLight((LevelAccessor)level, pos, random);
        return reason == MobSpawnType.SPAWNER || light && level.m_8055_(blockpos).m_60643_((BlockGetter)level, blockpos, type) && random.m_188501_() < 0.25f;
    }

    public void m_7822_(byte id) {
        if (id == 82) {
            this.playEffect(0);
        } else if (id == 83) {
            this.playEffect(1);
        } else {
            super.m_7822_(id);
        }
    }

    protected void playEffect(int type) {
        SimpleParticleType p = ParticleTypes.f_123758_;
        if (type == 1) {
            double d0 = 0.0;
            this.m_9236_().m_7106_((ParticleOptions)p, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, 0.0, 0.0);
        } else {
            double d0 = 0.65;
            for (int i = 0; i < 9; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)p, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, 0.0, 0.0);
            }
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean playerKill) {
        super.m_7472_(source, looting, playerKill);
        if (source.m_7639_() instanceof AbstractRat) {
            if (this.m_217043_().m_188499_()) {
                this.m_20000_((ItemLike)RatsItemRegistry.MUSIC_DISC_MICE_ON_VENUS.get(), 1);
            } else {
                this.m_20000_((ItemLike)RatsItemRegistry.MUSIC_DISC_LIVING_MICE.get(), 1);
            }
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.PIED_PIPER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.PIED_PIPER_HURT.get();
    }
}

