/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisBlockTags;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class FeralRatlantean
extends Monster
implements IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final Animation ANIMATION_SNIFF = Animation.create((int)20);
    private static final EntityDataAccessor<Boolean> TOGA = SynchedEntityData.m_135353_(FeralRatlantean.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR_VARIANT = SynchedEntityData.m_135353_(FeralRatlantean.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int animationTick;
    private Animation currentAnimation;

    public FeralRatlantean(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_SLASH : ANIMATION_BITE);
        }
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TOGA, (Object)true);
        this.m_20088_().m_135372_(COLOR_VARIANT, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 3.0 && this.m_142582_((Entity)this.m_5448_()) && this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_))) {
                if (this.getAnimation() == NO_ANIMATION) {
                    this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_BITE : ANIMATION_SLASH);
                }
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 80.0f);
                this.doExtraEffect(this.m_5448_());
                this.m_5448_().m_147240_(0.25, this.m_20185_() - this.m_5448_().m_20185_(), this.m_20189_() - this.m_5448_().m_20189_());
            }
            if (!this.m_21525_() && this.m_5448_() == null && this.m_217043_().m_188503_(150) == 0 && this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SNIFF);
            }
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.getAnimation() == ANIMATION_SLASH || this.getAnimation() == ANIMATION_SNIFF) {
            return EntityDimensions.m_20398_((float)1.85f, (float)2.25f);
        }
        return super.m_6972_(pose);
    }

    public void doExtraEffect(LivingEntity target) {
    }

    public int getColorVariant() {
        return (Integer)this.m_20088_().m_135370_(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.m_20088_().m_135381_(COLOR_VARIANT, (Object)color);
    }

    public void setToga(boolean plague) {
        this.m_20088_().m_135381_(TOGA, (Object)plague);
    }

    public boolean hasToga() {
        return (Boolean)this.m_20088_().m_135370_(TOGA);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ColorVariant", this.getColorVariant());
        compound.m_128379_("Toga", this.hasToga());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setToga(compound.m_128471_("Toga"));
        this.setColorVariant(compound.m_128451_("ColorVariant"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, type, data, tag);
        this.setColorVariant(this.m_217043_().m_188503_(4));
        this.setToga(true);
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        this.m_6210_();
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_SLASH, ANIMATION_SNIFF};
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.RAT_BEAST_GROWL.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.RAT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.RAT_DIE.get();
    }

    public float m_6100_() {
        return super.m_6100_() * 0.4f;
    }

    public static boolean checkRatlanteanSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return rand.m_188503_(8) == 0 && FeralRatlantean.canSpawnAtPos(world, pos) && Mob.m_217057_(entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand);
    }

    private static boolean canSpawnAtPos(LevelAccessor world, BlockPos pos) {
        return !world.m_8055_(pos.m_7495_()).m_204336_(RatlantisBlockTags.PIRAT_ONLY_BLOCKS);
    }
}

