/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatTreeUtils;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RatHarvestTreesGoal
extends BaseRatHarvestGoal {
    private final TamedRat rat;
    private int breakingTime;
    private int previousBreakProgress;
    private int treeSize;
    private List<BlockPos> stumpBlocks;
    @Nullable
    private Block sapling;

    public RatHarvestTreesGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || !this.checkTheBasics(this.rat.getDepositPos().isPresent(), this.rat.getDepositPos().isPresent())) {
            return false;
        }
        this.resetTarget();
        return this.getTargetBlock() != null;
    }

    private void resetTarget() {
        Level level = this.rat.m_9236_();
        int RADIUS = this.rat.getRadius();
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.rat.getSearchCenter().m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.rat.getSearchCenter().m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
            Path path;
            if (!RatTreeUtils.isTreeLog(level.m_8055_(pos)) || !level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || (this.treeSize = RatTreeUtils.calculateLogAmount(level, pos)) <= 0 || (path = this.rat.m_21573_().m_7864_(this.getOffsetToAirPos(pos), 1)) == null || !RatUtils.canRatBreakBlock(this.rat.m_9236_(), pos, this.rat)) continue;
            this.setTargetBlock(pos);
            break;
        }
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.stumpBlocks = RatTreeUtils.getAllStumpBlocks(this.rat.m_9236_(), this.getTargetBlock(), this.rat.m_9236_().m_8055_(this.getTargetBlock()));
    }

    public boolean m_8045_() {
        return this.checkTheBasics(false, true) && this.getTargetBlock() != null;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.rat.crafting = false;
        this.sapling = null;
    }

    @Nullable
    public BlockPos getOffsetToAirPos(@Nullable BlockPos pos) {
        if (pos != null) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.m_121945_(direction);
                if (!this.rat.m_9236_().m_46859_(offsetPos) && this.rat.m_9236_().m_8055_(offsetPos).m_60815_()) continue;
                return offsetPos;
            }
        }
        return pos;
    }

    public void m_8037_() {
        BlockPos offsetToAirPos = this.getOffsetToAirPos(this.getTargetBlock());
        this.rat.m_21563_().m_24964_(this.getTargetBlock().m_252807_());
        this.rat.m_21573_().m_26519_((double)offsetToAirPos.m_123341_() + 0.5, (double)offsetToAirPos.m_123342_(), (double)offsetToAirPos.m_123343_() + 0.5, 1.25);
        if (RatTreeUtils.isTreeLog(this.rat.m_9236_().m_8055_(this.getTargetBlock()))) {
            double distance = this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_());
            if (distance < this.rat.getRatHarvestDistance(0.0)) {
                this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)85);
                this.rat.crafting = true;
                if (distance < this.rat.getRatHarvestDistance(-1.0)) {
                    this.rat.m_20256_(Vec3.f_82478_);
                    this.rat.m_21573_().m_26573_();
                }
                ++this.breakingTime;
                int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
                if (this.breakingTime % 10 == 0) {
                    this.rat.m_5496_(SoundEvents.f_12634_, 1.0f, 1.0f);
                    this.rat.m_5496_(SoundEvents.f_12317_, 1.0f, 0.5f);
                }
                if (i != this.previousBreakProgress) {
                    this.rat.m_9236_().m_6801_(this.rat.m_19879_(), this.getTargetBlock(), i);
                    this.previousBreakProgress = i;
                }
                if (this.breakingTime >= 160) {
                    this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)86);
                    this.rat.m_5496_(SoundEvents.f_12630_, 1.0f, 1.0f);
                    this.breakingTime = 0;
                    this.previousBreakProgress = -1;
                    this.fellTree();
                    if (!this.stumpBlocks.isEmpty() && this.sapling != null && RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_REPLANTER.get())) {
                        this.stumpBlocks.forEach(pos -> {
                            if (RatUtils.canRatPlaceBlock(this.rat.m_9236_(), pos, this.rat)) {
                                this.rat.m_9236_().m_46597_(pos, this.sapling.m_49966_());
                            }
                        });
                    }
                    this.m_8041_();
                }
            }
        } else {
            this.m_8041_();
        }
    }

    private void fellTree() {
        Level level = this.rat.m_9236_();
        BlockPos base = this.getTargetBlock();
        BlockState baseBlock = level.m_8055_(base);
        List<BlockPos> logsToKill = RatTreeUtils.getLogsToBreak(level, base, new ArrayList<BlockPos>(), level.m_8055_(base));
        for (BlockPos logpos : logsToKill) {
            if (!RatUtils.canRatBreakBlock(this.rat.m_9236_(), logpos, this.rat)) continue;
            level.m_46961_(logpos, true);
        }
        this.handleLeafRemoval(level, base, baseBlock, logsToKill, this.treeSize);
    }

    private void handleLeafRemoval(Level level, BlockPos base, BlockState baseBlock, List<BlockPos> logstobreak, int logCount) {
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        BlockPos highestlog = base.m_7949_();
        block0: for (BlockPos logpos : logstobreak) {
            if (logpos.m_123342_() > highestlog.m_123342_()) {
                highestlog = logpos.m_7949_();
            }
            for (BlockPos next : BlockPos.m_121976_((int)(base.m_123341_() - 8), (int)base.m_123342_(), (int)(base.m_123343_() - 8), (int)(base.m_123341_() + 8), (int)RatTreeUtils.highestleaf.get(base), (int)(base.m_123343_() + 8))) {
                BlockState nextblock = level.m_8055_(next);
                if (!RatTreeUtils.isTreeLog(nextblock) || !nextblock.m_60713_(baseBlock.m_60734_()) && !RatTreeUtils.areEqualLogTypes(baseBlock, nextblock)) continue;
                logs.add(next.m_7949_());
            }
            Pair<Integer, Integer> hv = RatTreeUtils.getHorizontalAndVerticalValue(logCount);
            int h = (Integer)hv.getFirst();
            CopyOnWriteArrayList<BlockPos> leftoverleaves = new CopyOnWriteArrayList<BlockPos>();
            BlockState leafblock = level.m_8055_(highestlog.m_7494_());
            for (BlockPos next : BlockPos.m_121976_((int)(base.m_123341_() - h), (int)base.m_123342_(), (int)(base.m_123343_() - h), (int)(base.m_123341_() + h), (int)RatTreeUtils.highestleaf.get(base), (int)(base.m_123343_() + h))) {
                BlockState nextblock = level.m_8055_(next);
                if (!leafblock.m_60713_(nextblock.m_60734_()) || !RatTreeUtils.isTreeLeaf(nextblock)) continue;
                boolean logclose = false;
                for (BlockPos log : logs) {
                    if (!log.m_123314_((Vec3i)next, 3.0)) continue;
                    logclose = true;
                    break;
                }
                if (!logclose) {
                    leaves.add(next.m_7949_());
                    continue;
                }
                leftoverleaves.add(next.m_7949_());
            }
            for (BlockPos leftoverleaf : leftoverleaves) {
                if (leftoverleaves.isEmpty()) continue block0;
                Pair<Boolean, List<BlockPos>> connectedpair = RatTreeUtils.isConnectedToLogs(level, leftoverleaf);
                if (((Boolean)connectedpair.getFirst()).booleanValue()) {
                    for (BlockPos connectedpos : (List)connectedpair.getSecond()) {
                        leftoverleaves.remove(connectedpos);
                    }
                    continue;
                }
                for (BlockPos connectedpos : (List)connectedpair.getSecond()) {
                    if (!leaves.contains(connectedpos)) {
                        leaves.add(connectedpos.m_7949_());
                    }
                    leftoverleaves.remove(connectedpos);
                }
            }
        }
        for (BlockPos leafPos : leaves) {
            if (this.sapling == null && this.rat.m_9236_().m_8055_(leafPos).m_204336_(BlockTags.f_13035_)) {
                this.sapling = RatTreeUtils.getSaplingFromLeaves((ServerLevel)this.rat.m_9236_(), this.rat.m_9236_().m_8055_(leafPos).m_60734_());
            }
            if (!RatUtils.canRatBreakBlock(this.rat.m_9236_(), leafPos, this.rat)) continue;
            level.m_46961_(leafPos, true);
        }
        RatTreeUtils.highestleaf.remove(base);
    }
}

