/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;

public class RatFishermanGoal
extends BaseRatHarvestGoal {
    private final TamedRat rat;
    private boolean hasReachedWater = false;
    private boolean playedThrownSound = false;
    private int fishingCooldown = 700;

    public RatFishermanGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || !this.checkTheBasics(false, this.rat.getDepositPos().isPresent())) {
            return false;
        }
        this.resetTarget();
        return this.getTargetBlock() != null;
    }

    public boolean m_8045_() {
        return this.checkTheBasics(false, false) && this.getTargetBlock() != null;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.rat.crafting = false;
        this.hasReachedWater = false;
        this.fishingCooldown = 750 + this.rat.m_217043_().m_188503_(250);
    }

    public void m_8037_() {
        if (this.getTargetBlock() != null && this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            if (this.hasReachedWater) {
                this.rat.m_21573_().m_26573_();
                if (!this.playedThrownSound) {
                    this.rat.m_5496_(SoundEvents.f_11941_, 1.0f, 0.5f);
                    this.rat.m_146850_(GameEvent.f_223698_);
                    this.playedThrownSound = true;
                }
            }
            if (!this.hasReachedWater) {
                this.rat.m_21573_().m_26519_((double)this.getTargetBlock().m_123341_() + 0.5, (double)this.getTargetBlock().m_123342_(), (double)this.getTargetBlock().m_123343_() + 0.5, 1.25);
            }
            if (this.isShore(this.getTargetBlock(), this.rat.m_9236_())) {
                double distance = this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_());
                this.hasReachedWater = distance < this.rat.getRatHarvestDistance(-2.0);
            } else {
                this.m_8041_();
            }
        }
        if (this.hasReachedWater) {
            this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)85);
            this.rat.crafting = true;
            if (this.fishingCooldown > 0) {
                --this.fishingCooldown;
            }
            if (this.fishingCooldown == 0) {
                this.spawnFishingLoot();
                this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)101);
                this.rat.m_5496_(SoundEvents.f_11940_, 1.0f, 1.0f);
                this.rat.m_146850_(GameEvent.f_223697_);
                this.m_8041_();
            }
        }
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.rat.getRadius();
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.rat.getSearchCenter().m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.rat.getSearchCenter().m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
            if (!this.isShore(pos, this.rat.m_9236_())) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.getTargetSorter());
            this.setTargetBlock((BlockPos)allBlocks.get(0));
        }
    }

    private boolean isShore(BlockPos pos, Level world) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!world.m_8055_(pos.m_121945_(facing)).m_60713_(Blocks.f_49990_) || !world.m_8055_(pos).m_60804_((BlockGetter)this.rat.m_9236_(), pos) || !world.m_46859_(pos.m_7494_())) continue;
            return true;
        }
        return false;
    }

    public void spawnFishingLoot() {
        this.fishingCooldown = 750 + this.rat.m_217043_().m_188503_(250);
        double luck = 0.1;
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.rat.m_9236_()).m_287239_((float)luck);
        LootContextParamSet.Builder paramBuilder = new LootContextParamSet.Builder();
        ObjectArrayList result = this.rat.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_).m_287195_(builder.m_287235_(paramBuilder.m_81405_()));
        FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.rat.m_9236_()));
        player.m_146884_(this.rat.m_20182_());
        FishingHook hook = new FishingHook((Player)player, this.rat.m_9236_(), this.rat.m_217043_().m_188503_(4), 0);
        hook.m_146884_(this.rat.m_20182_());
        ItemFishedEvent event = new ItemFishedEvent((List)result, 1, hook);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.holdItemHarvestedIfPossible(this.rat, (List<ItemStack>)result);
        }
    }
}

