/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.RatWorkGoal;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.UpdateRatFluidPacket;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class RatPickupGoal
extends Goal
implements RatWorkGoal {
    private final TamedRat rat;
    private final PickupType type;
    private BlockPos targetBlock = null;

    public RatPickupGoal(TamedRat rat, PickupType type) {
        this.rat = rat;
        this.type = type;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.rat.canMove()) {
            return false;
        }
        if (!this.canPickUp()) {
            return false;
        }
        if (this.rat.m_5448_() != null) {
            return false;
        }
        if (this.rat.getPickupPos().isEmpty() || !this.rat.getPickupPos().get().m_122640_().equals(this.rat.m_9236_().m_46472_()) || RatUtils.isBlockProtected(this.rat.m_9236_(), this.rat.getPickupPos().get().m_122646_(), this.rat)) {
            return false;
        }
        if (this.type == PickupType.INVENTORY ? !this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() : (this.type == PickupType.ENERGY ? this.rat.getHeldRF() >= this.rat.getRFTransferRate() : this.type == PickupType.FLUID && !this.rat.transportingFluid.isEmpty() && this.rat.transportingFluid.getAmount() >= this.rat.getMBTransferRate())) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private boolean canPickUp() {
        return this.rat.getCommand() == RatCommand.TRANSPORT || this.rat.getCommand() == RatCommand.HARVEST && (RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_FARMER.get()) || RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLACER.get()) || RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_BREEDER.get()));
    }

    private void resetTarget() {
        this.targetBlock = this.rat.getPickupPos().get().m_122646_();
    }

    public boolean m_8045_() {
        return this.targetBlock != null && this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8056_() {
        this.rat.isCurrentlyWorking = true;
    }

    public void m_8041_() {
        this.rat.isCurrentlyWorking = false;
    }

    public void m_8037_() {
        BlockEntity te = this.rat.m_9236_().m_7702_(this.targetBlock);
        if (this.targetBlock != null && te != null) {
            Container container;
            this.rat.m_21573_().m_26519_((double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 0.5, (double)this.targetBlock.m_123343_() + 0.5, 1.25);
            double distance = Math.sqrt(this.rat.getRatDistanceSq((double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 0.5, (double)this.targetBlock.m_123343_() + 0.5));
            if (distance < 3.5 * this.rat.getRatDistanceModifier() && distance > 2.5 * this.rat.getRatDistanceModifier() && te instanceof Container) {
                container = (Container)te;
                this.toggleChest(container, true);
            }
            if (distance <= 2.5 * this.rat.getRatDistanceModifier()) {
                if (te instanceof Container) {
                    container = (Container)te;
                    this.toggleChest(container, false);
                }
                this.executeTask(te);
                this.targetBlock = null;
                this.m_8041_();
            }
        }
    }

    public void toggleChest(Container te, boolean open) {
        if (te instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)te;
            if (open) {
                this.rat.m_9236_().m_7696_(this.targetBlock, chest.m_58900_().m_60734_(), 1, 1);
            } else {
                this.rat.m_9236_().m_7696_(this.targetBlock, chest.m_58900_().m_60734_(), 1, 0);
            }
            this.rat.m_9236_().m_142346_((Entity)this.rat, open ? GameEvent.f_157796_ : GameEvent.f_157793_, chest.m_58899_());
        }
    }

    private void executeTask(BlockEntity entity) {
        LazyOptional handler;
        if (this.type == PickupType.INVENTORY) {
            LazyOptional handler2 = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
            if (handler2.resolve().isPresent()) {
                int slot = RatUtils.getItemSlotFromItemHandler(this.rat, (IItemHandler)handler2.resolve().get(), this.rat.m_9236_().m_213780_());
                int extractSize = RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get()) ? 64 : 1;
                ItemStack stack = ItemStack.f_41583_;
                try {
                    if (((IItemHandler)handler2.resolve().get()).getSlots() > 0 && ((IItemHandler)handler2.resolve().get()).extractItem(slot, extractSize, true) != ItemStack.f_41583_) {
                        stack = ((IItemHandler)handler2.resolve().get()).extractItem(slot, extractSize, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (slot != -1 && stack != ItemStack.f_41583_) {
                    ItemStack duplicate = stack.m_41777_();
                    if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.rat.m_9236_().m_5776_()) {
                        this.rat.m_5552_(this.rat.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                    }
                    this.rat.m_21008_(InteractionHand.MAIN_HAND, duplicate);
                }
            }
        } else if (this.type == PickupType.ENERGY) {
            LazyOptional handler3 = entity.getCapability(ForgeCapabilities.ENERGY, Direction.DOWN);
            if (handler3.resolve().isPresent()) {
                IEnergyStorage storage = (IEnergyStorage)handler3.resolve().get();
                int howMuchWeWant = this.rat.getRFTransferRate() - this.rat.getHeldRF();
                int recievedEnergy = 0;
                try {
                    howMuchWeWant = Math.min(storage.getEnergyStored(), howMuchWeWant);
                    if (storage.extractEnergy(howMuchWeWant, true) > 0) {
                        recievedEnergy = storage.extractEnergy(howMuchWeWant, false);
                    }
                }
                catch (Exception duplicate) {
                    // empty catch block
                }
                if (recievedEnergy > 0) {
                    this.rat.setHeldRF(this.rat.getHeldRF() + recievedEnergy);
                }
            }
        } else if (this.type == PickupType.FLUID && (handler = entity.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN)).resolve().isPresent()) {
            IFluidHandler fluidHandler = (IFluidHandler)handler.resolve().get();
            int currentAmount = 0;
            if (!this.rat.transportingFluid.isEmpty()) {
                currentAmount = this.rat.transportingFluid.getAmount();
            }
            int howMuchWeWant = this.rat.getMBTransferRate() - currentAmount;
            FluidStack drainedStack = null;
            try {
                if (fluidHandler.getTanks() > 0) {
                    FluidStack firstTank = fluidHandler.getFluidInTank(0);
                    if (fluidHandler.getTanks() > 1) {
                        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                            FluidStack otherTank = fluidHandler.getFluidInTank(i);
                            if (this.rat.transportingFluid.isEmpty() || !this.rat.transportingFluid.isFluidEqual(otherTank)) continue;
                            firstTank = otherTank;
                        }
                    }
                    if (firstTank.isEmpty() && (this.rat.transportingFluid.isEmpty() || this.rat.transportingFluid.isFluidEqual(firstTank))) {
                        howMuchWeWant = Math.min(firstTank.getAmount(), howMuchWeWant);
                        fluidHandler.drain(howMuchWeWant, IFluidHandler.FluidAction.SIMULATE);
                        drainedStack = fluidHandler.drain(howMuchWeWant, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            }
            catch (Exception firstTank) {
                // empty catch block
            }
            if (drainedStack != null) {
                if (this.rat.transportingFluid.isEmpty()) {
                    this.rat.transportingFluid = drainedStack.copy();
                } else {
                    this.rat.transportingFluid.setAmount(this.rat.transportingFluid.getAmount() + Math.max(drainedStack.getAmount(), 0));
                }
                if (!this.rat.m_9236_().m_5776_()) {
                    RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateRatFluidPacket(this.rat.m_19879_(), this.rat.transportingFluid));
                }
                SoundEvent sound = this.rat.transportingFluid.isEmpty() ? SoundEvents.f_11781_ : SoundEvents.f_11778_;
                this.rat.m_5496_(sound, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public RatWorkGoal.TaskType getRatTaskType() {
        return RatWorkGoal.TaskType.PICKUP;
    }

    public static enum PickupType {
        INVENTORY,
        FLUID,
        ENERGY;

    }
}

